/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.StringUtil ;					// 6.2.0.0 (2015/02/27)

/**
 * 先頭１文字目が、アンダーバー"_" の場合は書込み禁止属性を考慮するレンデラークラスです。
 * (つまり先頭の"_"を削った状態で表示します)
 * データは"_"付きのため、テーブルモデルで登録に使用する際はentryタグのWRTCTRLを利用してください。
 *
 * このクラスは、不変オブジェクトとして、共有されます。
 *
 * @og.rev 3.0.0.4 (2003/02/26) 新規追加
 * @og.rev 5.4.3.6 (2012/01/19) コメント修正
 * @og.group データ表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_WRITABLE extends AbstractRenderer {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.2.0 (2016/01/29)" ;

	private static final CellRenderer DB_CELL = new Renderer_WRITABLE() ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public Renderer_WRITABLE() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.1.2.1 (2003/04/10) synchronized を、削除します。
	 *
	 * @param	clm	カラムオブジェクト
	 *
	 * @return	自分のインスタンス
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return DB_CELL;
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		// 6.3.9.1 (2015/11/27) Found 'DD'-anomaly for variable(PMD)
//		String temp = value;
//
//		if( StringUtil.startsChar( value , '_' ) ) {	// 6.2.0.0 (2015/02/27) １文字 String.startsWith
//			temp = value.substring( 1 );
//		}
//
//		return temp;

		return StringUtil.startsChar( value , '_' ) ? value.substring( 1 ) : value ;
	}
}
