/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

// import org.opengion.fukurou.system.OgBuilder ;				// 6.4.4.1 (2016/03/18)

/**
 * TableFilter_SEQUENCE_DERBY は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ここでは、シーケンス一覧の検索結果より、GF09 のシーケンス定義テーブルから
 * 必要な情報を取得し、シーケンス作成スクリプトを作成します。
 *
 * この処理を実行するには、DBTableModelのカラムとして、
 *  SEQNAME,INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHE
 * が必要です。
 *
 * ※MySQLに対して生成されるスクリプトでは、INCREBY,MINVAL,MAXVAL,FGCYCLE,SUCACHEは無視されます。
 *   なお、MySQLではシーケンスはサポートされていないため、シーケンス名と同じ名前のシーケンス採番テーブルを生成し、
 *   これを1ずつ加算してアップデートすることで、シーケンスをエミュレートします。
 *
 * @og.rev 6.4.5.0 (2016/04/08) 新規作成
 * @og.rev 6.8.1.0 (2017/07/14) JAVADB → DERBY に変更
 *
 * @version  6.4.5.0 (2016/04/08)
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8,
 */
public class TableFilter_SEQUENCE_DERBY extends TableFilter_SEQUENCE {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.8.1.0 (2017/07/14)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.5.0 (2016/04/08) 新規作成
	 * @og.rev 6.8.1.0 (2017/07/14) JAVADB → DERBY に変更
	 */
	public TableFilter_SEQUENCE_DERBY() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * シーケンス作成の処理を実行します。
	 *
	 * INSERTする度に自動的に増加していく番号で定義するので、通常のシーケンスは作成しません。
	 * ただし、現在値をクリア・変更（採番を再スタート）するためのスクリプトを作成しておきます。
	 * 実行時には、コミットも必要です。
	 *
	 * @og.rev 6.4.5.0 (2016/04/08) 新規作成
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	シーケンス作成
	 * @og.rtnNotNull
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data ) {
		return "";
	}
}
