/************************************************************************/
/* 旧 timeSet.js の内容を移植 5.2.1.0 (2010/10/01) 						*/
/*																		*/
/* 検索時の実行時間を画面に表示します。									*/
/* Revision: $Id$														*/
/************************************************************************/
var dystart ;
var qTime = 0;
var vTime = 0;
var pView = 0;
var tTime;

function timeSet() {
	dystart = new Date();
	return true;
}

function getValue( obj ) {
	var val = 0 , i ;
	if( obj != null ) {
		if( obj.length != null ) {
			for( i=0; i<obj.length; i++ ) {
				val = val + parseInt(obj[i].getAttribute("value"),10);
			}
		}
		else {
			val = obj.getAttribute("value");
		}
	}
	return val;
}

var viewRatio   = 50;
var maxViewTime = 5000;

function timecheck( inQueryTime,inViewTime ) {
	var queryTbl , viewTbl , pageTbl , totalTbl , qTime , vTime , dyend , pView , tTime ;

	queryTbl = document.getElementById("queryTbl");
	if( queryTbl == null || dystart == 0 || dystart == null ) { return; }

	viewTbl  = document.getElementById("viewTbl");
	pageTbl  = document.getElementById("pageTbl");
	totalTbl = document.getElementById("totalTbl");

	qTime = getValue( inQueryTime );
	vTime = getValue( inViewTime );

	dyend = new Date();
	pView = (dyend - dystart - qTime - vTime);
	tTime = (dyend - dystart);

	// 5.6.4.2 (2013/05/17)  pView がマイナスの場合は、0 に設定する。
	pView = ( pView < 0 ) ? 0 : pView;

	totalTbl.style.backgroundColor = "transparent";

	queryTbl.title = "DB: "		+ qTime + " [ms]" ;
	viewTbl.title  = "JSP: "	+ vTime + " [ms]" ;
	pageTbl.title  = "IE: "		+ pView + " [ms]" ;
	totalTbl.innerHTML = Math.round( tTime / 100 )/10 + " [s]";

	if( tTime > maxViewTime ) {
		totalTbl.style.backgroundColor = "#ffff33";
		viewRatio = viewRatio * maxViewTime / tTime;
	}

	queryTbl.innerHTML = "&nbsp;";
	viewTbl.innerHTML  = "&nbsp;";
	pageTbl.innerHTML  = "&nbsp;";

	queryTbl.width = Math.floor( qTime / viewRatio +1 );
	viewTbl.width  = Math.floor( vTime / viewRatio +1 );
	pageTbl.width  = Math.floor( pView / viewRatio +1 );

	dystart = 0;
}

/************************************************************************************************/
/* 旧 toggleFrame.js の内容を移植 5.2.1.0 (2010/10/01) 											*/
/*																								*/
/* フレームの拡大、縮小を行う、３色ボタンの制御を行います。										*/
/*																								*/
/* @og.rev 3.8.5.3 (2006/08/07) change CSS file userd.                                          */
/* @og.rev 3.8.9.1 (2007/06/15) Correspondence of case with frame division into three or more.	*/
/* @og.rev 5.1.4.0 (2010/03/01) for IE8 Frame Bug                                               */
/* Revision: $Id$																				*/
/************************************************************************************************/
$(function(){
	$('.toggleTop').click( function(){ toggleTopFrame(this); } );
	$('.toggleSub').click( function(){ toggleSubFrame(this); } );
	$('.toggleAll').click( function(){ toggleAllFrame(this); } );
});

var old_cols = null ;
var old_rows = null ;
var old_prnt = null ;
var toggleCol = false;	// true: FrameOpen false: FrameClose
var toggleRow = false;	// true: FrameOpen false: FrameClose
var toggleAll = false;	// true: FrameOpen false: FrameClose
var togglePrnt = false;	// true: FrameOpen false: FrameClose

function toggleTopFrame( tdx ) {
	var sTopFrameNM , oTopFrame , oFramesets ;

	sTopFrameNM = "TOP_FRAME";
	oTopFrame = top.document.getElementById(sTopFrameNM);			//IE,Opera
    if(!oTopFrame) {
		oFramesets = top.document.getElementsByName(sTopFrameNM);	//IE,FireFox
		if( oFramesets.length == 1 ) { oTopFrame = oFramesets[0]; }
	}

	if(!oTopFrame) { return; }
	// 5.1.8.0 (2010/07/01) マトリクスメニューで正しく表示されないバグを修正
	if(oTopFrame.cols.indexOf(',')<0) { return; }

	if( toggleCol ) {
		toggleCol = false;
//		oTopFrame.cols  = old_cols;
//		if( old_cols.split(",")[0] == 0 ) { // 4.2.0.1 (2008/3/31)
//		if( old_cols.split(",")[0] <= 10 ) { // 4.3.6.3 (2009/04/22)
		if( old_cols.split(",")[0] <= 10 || old_cols.split(",")[0] > 512 ) { // 5.1.4.0 (2010/03/01) for IE8 Frame Bug
			oTopFrame.cols  = "160,*";
		}
		else {
			oTopFrame.cols  = old_cols;
		}
		if( tdx != null ) {
			if( tdx.className.length == 0 ) { tdx.style.backgroundColor  = "Red"; }
			else { tdx.className = "toggleTop"; }
		}
	}
	else {
		toggleCol = true;
		old_cols = oTopFrame.cols ;
		oTopFrame.cols = "10,*";
		if( tdx != null ) {
			if( tdx.className.length == 0 ) { tdx.style.backgroundColor  = "Gray"; }
			else { tdx.className = "toggleOff"; }
		}
	}
}

function toggleSubFrame( tdx ) {
	var sSubFrameNM , oSubFrame , oFramesets , tbl , orgRows , tempRows , i ;

	sSubFrameNM = "SUB_FRAME";
	oSubFrame = parent.document.getElementById(sSubFrameNM);			//IE,Opera
	if(!oSubFrame) {
		oFramesets = parent.document.getElementsByName(sSubFrameNM);	//IE,FireFox
		if( oFramesets.length == 1 ) { oSubFrame = oFramesets[0]; }
	}

	if(!oSubFrame) { return; }

	if( toggleRow ) {
		toggleRow = false;
		// 5.1.4.0 (2010/03/01) for IE8 Frame Bug
//		oSubFrame.rows = old_rows;
		if( old_rows ) { oSubFrame.rows = old_rows; }
		if( tdx != null ) {
			if( tdx.className.length == 0 ) { tdx.style.backgroundColor  = "Green"; }
			else { tdx.className = "toggleSub"; }
		}
	}
	else {
		toggleRow = true;
		// 5.1.4.0 (2010/03/01) for IE8 Frame Bug
		if( oSubFrame.rows.split(",")[0] < 1000 ) {
			old_rows = oSubFrame.rows ;
			if( parent.QUERY != null ) {
				tbl = parent.QUERY.document.getElementById( "QUERY_TBL" );
				if( tbl != null ) {
					// 3.8.9.1 (2007/06/15)
					orgRows = oSubFrame.rows.split( "," ) ;
					tempRows = (tbl.offsetTop +  tbl.offsetHeight + tbl.parentNode.offsetTop) + ",*" ;
					for( i=2; i<orgRows.length; i++){
						tempRows = tempRows + "," + orgRows[i] ;
					}
					oSubFrame.rows = tempRows;
				}
			}
		}
		if( tdx != null ) {
			if( tdx.className.length == 0 ) { tdx.style.backgroundColor  = "Gray"; }
			else { tdx.className = "toggleOff"; }
		}
	}
}

function toggleAllFrame( tdx ) {
	if( toggleAll ) {
		toggleAll = false;
		if( toggleCol ) { toggleTopFrame(); }
		if( toggleRow ) { toggleSubFrame(); }
		if( tdx != null ) {
			if( tdx.className.length == 0 ) { tdx.style.backgroundColor  = "Blue"; }
			else { tdx.className = "toggleAll"; }
		}
	}
	else {
		toggleAll = true;
		if( ! toggleCol ) { toggleTopFrame(); }
		if( ! toggleRow ) { toggleSubFrame(); }
		if( tdx != null ) {
			if( tdx.className.length == 0 ) { tdx.style.backgroundColor  = "Gray"; }
			else { tdx.className = "toggleOff"; }
		}
	}
}

/* indx is frame address */
function toggleFrame( mark ) {
	var oFramesets , indx , i , j , orgRows , tempRows ;

	oFramesets = parent.document.getElementsByTagName("FRAMESET");
	if( oFramesets.length == 1 ) { oSubFrame = oFramesets[0]; }

	if(!oSubFrame) { return; }

	if( togglePrnt ) {
		togglePrnt = false;
		oSubFrame.rows = old_prnt;

		if( mark ) {
			mark.innerHTML = "(-)" ;
		}

	}
	else {
		togglePrnt = true;
		old_prnt = oSubFrame.rows ;

		indx = -1;
		for( j=0; j<parent.frames.length; j++ ) {
			if( self.frames.name == parent.frames[j].name ) {
				indx = j;
				break;
			}
		}

		orgRows = oSubFrame.rows.split( "," ) ;
		if( mark == null ) { orgRows[indx] = "0"; }
		else {
			orgRows[indx] = (mark.offsetTop +  mark.offsetHeight + mark.parentNode.offsetTop);
			mark.innerHTML = "(+)" ;
		}

		tempRows = orgRows[0] ;
		for( i=1; i<orgRows.length; i++){
			tempRows = tempRows + "," + orgRows[i] ;
		}
		oSubFrame.rows = tempRows;
	}
}

/*************************************************************************/
/* 旧 adjustFrameHeightEvent.js の内容を移植 5.2.1.0 (2010/10/01)        */
/*                                                                       */
/* フレームの高さを調整のためのイベント登録                              */
/* 関数本体はcommon/default.js                                           */
/*                                                                       */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離・イベントにJQuery利用     */
/* @og.rev 5.9.4.3 (2016/01/15) 遅延実行対応	                         */
/* @og.rev 5.9.5.1 (2016/02/12) ごく稀に1msecでは足りない場合がある      */
/*************************************************************************/

/* 遅延用 */
function adjustFrameHeightSleep(){
	if( $('body').width() == 0 ){
		setTimeout(function(){adjustFrameHeightSleep();},10);
	}
	else{
		adjustFrameHeight();
	}
}

/* onload時に実行 */
$(function(){
	if( $('body').width() == 0 ){ // 5.9.4.3 (2016/01/15)
//		setTimeout(function(){adjustFrameHeight();},1);
		setTimeout(function(){adjustFrameHeightSleep();},1);
		return ;
	}
	adjustFrameHeight();
});

/*************************************************************************/
/* 旧 focusFirstElm.js の内容を移植 5.2.1.0 (2010/10/01)                 */
/*                                                                       */
/* 一番最初の入力エリアにフォーカスを当て、フレームの高さを調整          */
/* 元のdefault.js内focus1()                                              */
/*                                                                       */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離・イベントにJQuery利用     */
/* @og.rev 5.3.6.0 (2011/06/01) QUERYのFocusの制御を追加                 */
/*************************************************************************/

/* onload時に実行 */
$(function(){
	if( typeof(h_qryFcs) == "undefined" || h_qryFcs != "false" ){
		focusFirstElm();
	}
});


/* 3.8.6.1 (2006/10/20) When the parentElement style is none, then focus is not applied.  */
function focusFirstElm() {
	var oAllForms , oMyBCR , bSetFocusToObj , f , i , obj ;

	oAllForms = document.getElementsByTagName("FORM");
	if ( oAllForms.length > 0 ) {
		bSetFocusToObj = false;
		f = oAllForms[0];
		for ( i = 0; i < f.elements.length; i++) {
			obj = f.elements[i];
			if ( obj != null && !obj.disabled && !obj.readOnly && (
				 obj.type == "text" ||
				 obj.type == "checkbox" ||
				 obj.type == "radio" ||
				 obj.type == "passwd" ||
				 obj.type == "textarea" ||
				 obj.type == "select-one" ||
				 obj.type == "select-multiple" ) ) {

				if(document.getBoxObjectFor) {	// Firefox
					oMyBCR = document.getBoxObjectFor(obj);
					if(oMyBCR.width != 0           ) { bSetFocusToObj = true; }
				}
				else if(obj.getBoundingClientRect) {	// IE
					oMyBCR = obj.getBoundingClientRect();
					if(oMyBCR.left  != oMyBCR.right) { bSetFocusToObj = true; }
				}
				if(bSetFocusToObj) { obj.focus(); break; }
			}
		}
		/* 3.5.4.0 (2003/11/25) Add  */
		historyBack();
	}
	/* 3.8.0.8 (2005/10/03) Add (Option) */
	// 4.3.5.0 (2009/02/01) イベントを分離
	// adjustFrameHeight();
}

/* 互換性のためのアラート */
function focus1() {
//	alert("custom/query_info.jsp及びcustom/result_info.jspで次の部分を削除して下さい。\n<script>タグ（ヘッダ固定とフォーカス）、BODYのonLoadとoncontextmenu属性");
	alert("Old Script Error!!\ncustom/query_info.jsp,custom/result_info.jsp Please delete the following part.\n<script>Tag(Header fix and Focus) , BODY onLoad and oncontextmenu Attribute");
}
