/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.HybsLoaderConfig;

public final class HybsLoaderFactory {
    private static final int SIZE = 1000;
    private static final Map<String, HybsLoader> LOADER_MAP = Collections.synchronizedMap(new LinkedHashMap<String, HybsLoader>(2000, 0.75f, true){
        private static final long serialVersionUID = 643320160304L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, HybsLoader> entry) {
            return this.size() > 1000;
        }
    });

    private HybsLoaderFactory() {
    }

    public static HybsLoader getLoader(HybsLoaderConfig hybsLoaderConfig) {
        return LOADER_MAP.computeIfAbsent(hybsLoaderConfig.getSrcDir(), string -> new HybsLoader(hybsLoaderConfig));
    }
}

