<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0005"
	title    = "ラベル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	2012/07/10 S.Li 概要説明にリンク追加
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" scope="{@scope}">
		select
		'1' as WRITABLE,A.CLM,A.NAME_JA,A.LNAME,A.SNAME,A.DESCRIPTION,A.COMMENTS,A.KBSAKU,A.KBLBL,A.FGLOAD,
		A.SYSTEM_ID,A.LANG,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ
		from GEA08 A
		where A.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "A.FGJ			=		'{@FGJ}'"			/>
		<og:and value = "A.LANG			=		'{@LANG}'"			/>
		<og:and value = "UPPER(CLM)		like	UPPER('{@CLM}')"	/>
		<og:and value = "A.NAME_JA		like	'{@NAME_JA}'"		/>
		<og:and value = "A.LNAME		like	'{@LNAME}'"			/>
		<og:and value = "A.SNAME		like	'{@SNAME}'"			/>
		<og:and value = "A.DESCRIPTION	like	'{@DESCRIPTION}'"	/>
		<og:and value = "A.KBSAKU		=		'{@KBSAKU}'"		/>
		<og:and value = "A.KBLBL		=		'{@KBLBL}'"			/>
		<og:and value = "A.FGLOAD		=		'{@FGLOAD}'"		/>
		<og:and value = "( A.CLM = A.NAME_JA {@NAME_MI} A.NAME_JA is null )" />
		<og:and value = "A.CDKH {@CDKH}" />
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,A.LANG,A.SYSTEM_ID DESC,A.KBSAKU DESC" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0003" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,{@SYSTEM_ID},[CLM],1" />
	<og:link column="DESCRIPTION" gamenId="GE0006" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,LANG,FGJ"
		vals="NEW,{@SYSTEM_ID},[CLM],[LANG],1" >
<img src="{@SYS.JSP}/image/link.gif" alt="Link" />[DESCRIPTION]
	</og:link>
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:equals val1="{@ACTION}" nullCheck="true">
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
			keys="noWritable" vals="null" />
		<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
			keys="noWritable" vals='"SYSTEM_ID,CLM,KBSAKU"' />
		<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="Z"
			keys="columnWritable,logicalDelete" vals="null,true" />
		<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
			keys="columnWritable" vals="null" />
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA04" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  value="update" lbl="COPY" command="COPY"
				keys="noWritable,sysins" vals="null,true" />
		</fieldset>
	</og:equals>
	<og:equals val1="{@ACTION}" val2="MINUS">
		<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
			keys="noWritable" vals="null" />
	</og:equals>
	<og:equals val1="{@ACTION}" val2="DIFFERENCE">
		<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
			keys="noWritable" vals='"SYSTEM_ID,CLM,KBSAKU"' />
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		{@USER.LASTSQL}
	</og:query>
	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,LANG,KBSAKU"
		diffKeys      = "NAME_JA,LNAME,SNAME,DESCRIPTION"
		slaveScope    = "request"
		modifyClms    = "UNIQ"
		display       = "true"
	/>
</og:equals>

<!--
<og:columnEditor column="DESCRIPTION" editor="TEXTAREA" param="8,100"/>
-->
<og:columnEditor columns="LNAME,DESCRIPTION" clazz="W100" />

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
