/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.OgRuntimeException;

public final class HybsDateUtil {
    private static final Map<String, String> DATE_FORMAT = new HashMap<String, String>();

    private HybsDateUtil() {
    }

    public static String parseNumber(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return "";
        }
        String string2 = DateSet.getDate("yyyyMMdd");
        String string3 = string.trim();
        string3 = string3.replaceAll("-", "/");
        int n = string3.indexOf(32);
        String string4 = string3;
        String string5 = null;
        if (n > 0) {
            string4 = string3.substring(0, n);
            string5 = string3.substring(n + 1);
        } else if (string3.indexOf(58) > 0) {
            string4 = string2;
            string5 = string3;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        if (string4 != null) {
            stringArray = string4.split("/");
            switch (stringArray.length) {
                case 1: {
                    stringBuilder.append(stringArray[0]);
                    break;
                }
                case 2: {
                    if (stringArray[0].length() < 4) {
                        stringBuilder.append(string2.substring(0, 4));
                    }
                    stringBuilder.append(HybsDateUtil.addZero(stringArray[0])).append(HybsDateUtil.addZero(stringArray[1]));
                    break;
                }
                default: {
                    if (stringArray[0].length() == 2) {
                        stringBuilder.append(string2.substring(0, 2));
                    }
                    stringBuilder.append(stringArray[0]).append(HybsDateUtil.addZero(stringArray[1])).append(HybsDateUtil.addZero(stringArray[2]));
                }
            }
        }
        if (string5 != null) {
            stringArray = string5.split(":");
            switch (stringArray.length) {
                case 1: {
                    stringBuilder.append(stringArray[0]);
                    break;
                }
                case 2: {
                    stringBuilder.append(HybsDateUtil.addZero(stringArray[0])).append(HybsDateUtil.addZero(stringArray[1])).append("00");
                    break;
                }
                default: {
                    stringBuilder.append(HybsDateUtil.addZero(stringArray[0])).append(HybsDateUtil.addZero(stringArray[1])).append(HybsDateUtil.addZero(stringArray[2]));
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String addZero(String string) {
        return string.length() == 1 ? "0" + string : string;
    }

    public static String parseTimestamp(String string) {
        if (string == null || string.length() != 8 && string.length() != 14) {
            String string2 = "\u65e5\u4ed8\u6587\u5b57\u5217\u306f\u3001\uff18\u6841 \u307e\u305f\u306f\u3001\uff11\uff14\u6841\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 value=[" + string + "]";
            throw new OgRuntimeException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(100).append(string.substring(0, 4)).append('-').append(string.substring(4, 6)).append('-').append(string.substring(6, 8)).append(' ');
        if (string.length() == 8) {
            stringBuilder.append("00:00:00");
        } else {
            stringBuilder.append(string.substring(8, 10)).append(':').append(string.substring(10, 12)).append(':').append(string.substring(12, 14));
        }
        return stringBuilder.toString();
    }

    public static String parseDate(String string, int n) {
        return HybsDateUtil.parseDate(string, n, n);
    }

    public static String parseDate(String string, int n, int n2) {
        if (string == null) {
            return "";
        }
        if (n2 > 14) {
            String string2 = "\u65e5\u4ed8\u767b\u9332\u306b\u8a31\u53ef\u3067\u304d\u308b\u6700\u5927\u6841\u6570\u306f\u3001\uff11\uff14\u30b1\u30bf\u3067\u3059\u3002 maxSize=[" + n2 + "]";
            throw new OgRuntimeException(string2);
        }
        String string3 = HybsDateUtil.parseNumber(string);
        int n3 = string3.length();
        if (n3 < n || n3 > n2) {
            String string4 = "\u65e5\u4ed8\u6587\u5b57\u5217\u306f\u3001\u6700\u5c0f[" + n + "] \u304b\u3089\u3001\u6700\u5927[" + n2 + "]\u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 value=[" + string + "]";
            throw new OgRuntimeException(string4);
        }
        return string3;
    }

    public static boolean isStrict(String string) {
        boolean bl;
        if (string == null || string.length() != 8 && string.length() != 14) {
            return false;
        }
        String string2 = string.length() == 8 ? "yyyyMMdd" : "yyyyMMddHHmmss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.JAPAN);
        simpleDateFormat.setLenient(false);
        try {
            simpleDateFormat.parse(string);
            bl = true;
        }
        catch (ParseException parseException) {
            bl = false;
        }
        return bl;
    }

    public static String getDateFormat(String string, String string2, String string3) {
        return HybsDateUtil.getDateFormat(string, string2, string3, 0);
    }

    public static String getDateFormat(String string, String string2, String string3, int n) {
        Calendar calendar = HybsDateUtil.getCalendar(string2);
        HybsDateUtil.calendarCalc(calendar, string3, n);
        String string4 = DATE_FORMAT.getOrDefault(string, string);
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = string.indexOf(71) == 0 ? new SimpleDateFormat(string4, new Locale("ja", "JP", "JP")) : new SimpleDateFormat(string4, Locale.JAPAN);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static void calendarCalc(Calendar calendar, String string) {
        HybsDateUtil.calendarCalc(calendar, string, 0);
    }

    public static void calendarCalc(Calendar calendar, String string, int n) {
        if (string != null && string.length() > 0) {
            if ("SD".equals(string)) {
                if (n != 0) {
                    calendar.add(2, n);
                }
                calendar.set(5, 1);
            } else if ("ED".equals(string)) {
                if (n != 0) {
                    calendar.add(2, n);
                }
                calendar.set(5, calendar.getActualMaximum(5));
            } else if ("SH".equals(string)) {
                int n2 = n == 0 ? 0 : (int)Math.floor(calendar.get(11) / n) * n;
                calendar.set(11, n2);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else if ("SM".equals(string)) {
                int n3 = n == 0 ? 0 : (int)Math.floor(calendar.get(12) / n) * n;
                calendar.set(12, n3);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else if ("SS".equals(string)) {
                int n4 = n == 0 ? 0 : (int)Math.floor(calendar.get(13) / n) * n;
                calendar.set(13, n4);
                calendar.set(14, 0);
            } else if ("EH".equals(string)) {
                int n5;
                int n6 = n5 = n == 0 ? 0 : (int)Math.ceil((double)calendar.get(11) / (double)n) * n;
                if (n5 == 0 || n5 >= 24) {
                    calendar.add(5, 1);
                    calendar.set(11, 0);
                } else {
                    calendar.set(11, n5);
                }
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else if ("EM".equals(string)) {
                int n7;
                int n8 = n7 = n == 0 ? 0 : (int)Math.ceil((double)calendar.get(12) / (double)n) * n;
                if (n7 == 0 || n7 >= 60) {
                    calendar.add(11, 1);
                    calendar.set(12, 0);
                } else {
                    calendar.set(12, n7);
                }
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else if ("ES".equals(string)) {
                int n9;
                int n10 = n9 = n == 0 ? 0 : (int)Math.ceil((double)calendar.get(13) / (double)n) * n;
                if (n9 == 0 || n9 >= 60) {
                    calendar.add(12, 1);
                    calendar.set(13, 0);
                } else {
                    calendar.set(13, n9);
                }
                calendar.set(14, 0);
            } else if ("BSD".equals(string)) {
                calendar.add(2, n - 1);
                calendar.set(5, 1);
            } else if ("BED".equals(string)) {
                calendar.add(2, n - 1);
                calendar.set(5, calendar.getActualMaximum(5));
            } else if ("ASD".equals(string)) {
                calendar.add(2, n + 1);
                calendar.set(5, 1);
            } else if ("AED".equals(string)) {
                calendar.add(2, n + 1);
                calendar.set(5, calendar.getActualMaximum(5));
            } else if ("SW".equals(string)) {
                int n11;
                if (n != 0) {
                    calendar.add(5, n * 7);
                }
                if ((n11 = calendar.get(7) - 2) > 0) {
                    calendar.add(5, -n11);
                } else if (n11 < 0) {
                    calendar.add(5, -6);
                }
            } else if ("EW".equals(string)) {
                int n12;
                if (n != 0) {
                    calendar.add(5, n * 7);
                }
                if ((n12 = calendar.get(7)) != 1) {
                    calendar.add(5, 8 - n12);
                }
            } else if ("YMD".equals(string)) {
                int n13 = n / 10000;
                int n14 = n / 100 % 100;
                int n15 = n % 100;
                calendar.add(1, n13);
                calendar.add(2, n14);
                calendar.add(5, n15);
            } else if ("HM".equals(string)) {
                int n16 = n / 100;
                int n17 = n % 100;
                calendar.add(11, n16);
                calendar.add(12, n17);
            } else if ("MI".equals(string)) {
                calendar.add(12, n);
            } else if (string.charAt(0) == 'H') {
                int n18 = n;
                if (string.length() > 1) {
                    n18 += Integer.parseInt(string.substring(1));
                }
                calendar.add(11, n18);
            } else if (string.charAt(0) == 'D') {
                int n19 = n;
                if (string.length() > 1) {
                    n19 += Integer.parseInt(string.substring(1));
                }
                calendar.add(5, n19);
            } else if (string.charAt(0) == 'M') {
                int n20 = n;
                if (string.length() > 1) {
                    n20 += Integer.parseInt(string.substring(1));
                }
                calendar.add(2, n20);
            } else {
                try {
                    int n21 = Integer.parseInt(string) + n;
                    calendar.add(5, n21);
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "\u65e5\u4ed8\u5909\u6570\u30d1\u30e9\u30e1\u30fc\u30bf\u306b\u3001\u4e0d\u6b63\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002\u4ee5\u4e0b\u306e\u4e2d\u304b\u3089\u6307\u5b9a\u3057\u306a\u304a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u6307\u5b9a\u53ef\u80fd\uff1a[SD,ED,SW,SH,SM,SS,EW,EH,EM,ES,H1\uff5eHXXX,D1\uff5eDXXX,M1\uff5eMXXX,HMS,BSD,BED,ASD,AED] prmB=[" + string + "]";
                    throw new OgRuntimeException(string2, numberFormatException);
                }
            }
        }
    }

    public static Calendar getCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string == null || string.isEmpty()) {
            return calendar;
        }
        String string2 = HybsDateUtil.parseNumber(string);
        if (string2.length() == 6) {
            string2 = string2 + "01";
        } else if (string2.length() < 8) {
            String string3 = "\u65e5\u4ed8\u6307\u5b9a\u30d1\u30e9\u30e1\u30fc\u30bf\u306b\u3001\u4e0d\u6b63\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002value=[" + string + "]";
            throw new OgRuntimeException(string3);
        }
        calendar.clear();
        int n = Integer.parseInt(string2.substring(0, 4));
        int n2 = Integer.parseInt(string2.substring(4, 6)) - 1;
        int n3 = Integer.parseInt(string2.substring(6, 8));
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (string2.length() >= 14) {
            n4 = Integer.parseInt(string2.substring(8, 10));
            n5 = Integer.parseInt(string2.substring(10, 12));
            n6 = Integer.parseInt(string2.substring(12, 14));
        }
        calendar.set(n, n2, n3, n4, n5, n6);
        return calendar;
    }

    public static String getDatePlus(String string, int n) {
        Calendar calendar = HybsDateUtil.getCalendar(string);
        calendar.add(5, n);
        return DateSet.getDate(calendar.getTimeInMillis(), "yyyyMMdd");
    }

    public static String getMonthPlus(String string, int n) {
        Calendar calendar = HybsDateUtil.getCalendar(string);
        calendar.set(5, 1);
        calendar.add(2, n);
        return DateSet.getDate(calendar.getTimeInMillis(), "yyyyMM");
    }

    public static String getDatePlus(String string, String string2, int n, String string3) {
        int n2 = 1;
        int n3 = n;
        if (string2 != null && !string2.isEmpty()) {
            boolean bl = true;
            char c = string2.charAt(string2.length() - 1);
            switch (c) {
                case 'y': {
                    n3 = 1;
                    break;
                }
                case 'M': {
                    n3 = 2;
                    break;
                }
                case 'd': {
                    n3 = 5;
                    break;
                }
                case 'H': {
                    n3 = 11;
                    break;
                }
                case 'm': {
                    n3 = 12;
                    break;
                }
                case 's': {
                    n3 = 13;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            n2 = bl ? Integer.parseInt(string2.substring(0, string2.length() - 1)) : Integer.parseInt(string2);
        }
        Calendar calendar = HybsDateUtil.getCalendar(string);
        calendar.add(n3, n2);
        return DateSet.getDate(calendar.getTimeInMillis(), string3);
    }

    static {
        DATE_FORMAT.put("YMD", "yyyyMMdd");
        DATE_FORMAT.put("Y2MD", "yyMMdd");
        DATE_FORMAT.put("YM", "yyyyMM");
        DATE_FORMAT.put("MD", "MMdd");
        DATE_FORMAT.put("HMS", "HHmmss");
        DATE_FORMAT.put("HM", "HHmm");
        DATE_FORMAT.put("YMDHMS", "yyyyMMddHHmmss");
        DATE_FORMAT.put("EEE", "EEE");
        DATE_FORMAT.put("YMDF", "yyyy/MM/dd");
        DATE_FORMAT.put("Y2MDF", "yy/MM/dd");
        DATE_FORMAT.put("YMF", "yyyy/MM");
        DATE_FORMAT.put("HMSF", "HH:mm:ss");
        DATE_FORMAT.put("HMF", "HH:mm");
        DATE_FORMAT.put("YMDHMSF", "yyyy/MM/dd HH:mm:ss");
        DATE_FORMAT.put("MDF", "MM/dd");
        DATE_FORMAT.put("MDEF", "MM/dd(EEE)");
        DATE_FORMAT.put("MD2F", "MM\u6708dd\u65e5");
        DATE_FORMAT.put("GYMDF", "GGGGyyyy\u5e74MM\u6708dd\u65e5");
        DATE_FORMAT.put("G2YMDF", "Gyyyy/MM/dd");
        DATE_FORMAT.put("GYMF", "GGGGyyyy\u5e74MM\u6708");
        DATE_FORMAT.put("GYF", "GGGGyyyy");
    }
}

