/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.system.Closer;								// 6.4.2.1 (2016/02/05)
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.ResultSetValue;							// 6.0.4.0 (2014/11/28)
import org.opengion.fukurou.util.ToString;								// 6.1.1.0 (2015/01/17)
import org.opengion.hayabusa.common.HybsSystemException;
import static org.opengion.fukurou.util.StringUtil.nval ;
import static org.opengion.fukurou.system.HybsConst.BR;					// 6.1.0.0 (2014/12/26) refactoring
import static org.opengion.fukurou.system.HybsConst.BUFFER_LARGE;		// 6.1.0.0 (2014/12/26) refactoring

import java.util.ArrayList;

import java.sql.DatabaseMetaData ;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

/**
 * DatabaseMetaData の情報を検索するタグです。
 *
 * ﾃﾞｰﾀﾍﾞｰｽに関する包括的な情報を提供する、DatabaseMetaData の内容を
 * 表示する、タグです。テスト的に使用します。
 *
 * @og.formSample
 * ●形式：
 *  &lt;og:databaseMetaData
 *      dbid            = &quot;{&#064;DBID}&quot;
 *      catalog         = &quot;{&#064;catalog}&quot;
 *      schema          = &quot;{&#064;schema}&quot;
 *      tableName       = &quot;{&#064;tableName}&quot;
 *      columnName      = &quot;{&#064;columnName}&quot;
 *      typeName        = &quot;{&#064;typeName}&quot;
 *      attributeName   = &quot;{&#064;attriName}&quot;
 *      procedureName   = &quot;{&#064;procName}&quot;
 *      maxRowCount     = &quot;{&#064;maxRowCount}&quot;
 *      likeKey         = &quot;{&#064;likeKey}&quot;
 *  /&gt;
 *
 * ●body：なし
 *
 * ●Tag定義：
 *   &lt;og:databaseMetaData
 *       dbid               【TAG】(通常は使いません)Queryオブジェクトを作成する時のDB接続IDを指定します(初期値:null)
 *       catalog            【TAG】(通常は使いません)Queryオブジェクトを作成する時のカタログを指定します
 *       schema             【TAG】(通常は使いません)Queryオブジェクトを作成する時のスキーマを指定します
 *       attributeName      【TAG】(通常は使いません)Queryオブジェクトを作成する時の属性名を指定します
 *       columnName         【TAG】(通常は使いません)Queryオブジェクトを作成する時のカラム名を指定します
 *       procedureName      【TAG】(通常は使いません)Queryオブジェクトを作成する時のプロダクト名を指定します
 *       tableName          【TAG】(通常は使いません)Queryオブジェクトを作成する時のテーブル名を指定します
 *       typeName           【TAG】(通常は使いません)Queryオブジェクトを作成する時のタイプ名を指定します
 *       maxRowCount        【TAG】maxRowCount ResultSetで検索するパラメータの最大検索件数を指定します(初期値:20)
 *       likeKey            【TAG】実行するメソッドを選別するための部分一致するｷｰを指定します
 *       debug              【TAG】デバッグ情報を出力するかどうか[true/false]を指定します(初期値:false)
 *   /&gt;
 *
 * ●使用例
 *       &lt;og:databaseMetaData /&gt;
 *
 * @og.group ＤＢ検索
 *
 * @version  0.9.0	2000/10/17
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class DatabaseMetaDataTag extends CommonTagSupport {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.2.1 (2016/02/05)" ;
	private static final long serialVersionUID = 642120160205L ;

	private static final String getTimeDateFunctions= "このﾃﾞｰﾀﾍﾞｰｽで使用可能な時間関数と日付関数をｺﾝﾏで区切ったﾘｽﾄを取得します。" ;
	private static final String supportsConvertFunc	= "このﾃﾞｰﾀﾍﾞｰｽによって、SQL の型間の CONVERT 関数がｻﾎﾟｰﾄされるかどうかを取得します。" ;
	private static final String getAttributes		= "指定されたｽｷｰﾏおよびｶﾀﾛｸﾞで使用可能なﾕｰｻﾞ定義の型 (UDT) のための指定された型の指定された属性に関する記述を取得します。  " ;
	private static final String getColumns			= "指定されたｶﾀﾛｸﾞで使用可能なﾃｰﾌﾞﾙ列の記述を取得します。  " ;
	private static final String getIndexInfo		= "指定されたﾃｰﾌﾞﾙのｲﾝﾃﾞｯｸｽと統計情報に関する記述を取得します。" ;
	private static final String getSuperTables		= "このﾃﾞｰﾀﾍﾞｰｽの特定のｽｷｰﾏで定義されているﾃｰﾌﾞﾙ階層の説明を取得します。  " ;
	private static final String getSuperTypes		= "このﾃﾞｰﾀﾍﾞｰｽの特定のｽｷｰﾏで定義されているﾕｰｻﾞ定義型 (UDT) 階層の説明を取得します。" ;
	private static final String getTypeInfo			= "このﾃﾞｰﾀﾍﾞｰｽでｻﾎﾟｰﾄされているすべての標準 SQL の型に関する記述を取得します。" ;

	private static final MetaDataInvoke[] METHOD_LIST = new MetaDataInvoke[] {
		  new MetaDataInvoke( "getCatalogSeparator" 		,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽがｶﾀﾛｸﾞ名とﾃｰﾌﾞﾙ名のｾﾊﾟﾚｰﾀとして使用する String" )
		, new MetaDataInvoke( "getCatalogTerm" 				,0,-1,	 "「catalog」に対するﾃﾞｰﾀﾍﾞｰｽﾍﾞﾝﾀﾞｰの推奨用語を取得します。" )
		, new MetaDataInvoke( "getDatabaseProductName" 		,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽ製品の名前を取得します。" )
		, new MetaDataInvoke( "getDatabaseProductVersion" 	,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽ製品のﾊﾞｰｼﾞｮﾝを取得します。" )
		, new MetaDataInvoke( "getDriverMajorVersion" 		,0,-1,	 "この JDBC ﾄﾞﾗｲﾊﾞのﾒｼﾞｬｰﾊﾞｰｼﾞｮﾝを取得します。" )
		, new MetaDataInvoke( "getDriverMinorVersion" 		,0,-1,	 "この JDBC ﾄﾞﾗｲﾊﾞのﾏｲﾅｰﾊﾞｰｼﾞｮﾝを取得します。" )
		, new MetaDataInvoke( "getDriverName" 				,0,-1,	 "この JDBC ﾄﾞﾗｲﾊﾞの名前を取得します。" )
		, new MetaDataInvoke( "getDriverVersion" 			,0,-1,	 "この JDBC ﾄﾞﾗｲﾊﾞのﾊﾞｰｼﾞｮﾝを String" )
		, new MetaDataInvoke( "getExtraNameCharacters" 		,0,-1,	 "引用符で囲まれていない識別名に使用できるすべての「特殊」文字 (a-z,A-Z,0-9,および _ 以外) を取得します。" )
		, new MetaDataInvoke( "getIdentifierQuoteString" 	,0,-1,	 "SQL 識別子を引用するのに使用する文字列を取得します。" )
		, new MetaDataInvoke( "getNumericFunctions" 		,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽで使用可能なｺﾝﾏで区切った数学関数のﾘｽﾄを取得します。" )
		, new MetaDataInvoke( "getProcedureTerm" 			,0,-1,	 "「procedure」に対するﾃﾞｰﾀﾍﾞｰｽﾍﾞﾝﾀﾞｰの推奨用語を取得します。" )
		, new MetaDataInvoke( "getSchemaTerm" 				,0,-1,	 "「schema」に対するﾃﾞｰﾀﾍﾞｰｽﾍﾞﾝﾀﾞｰの推奨用語を取得します。" )
		, new MetaDataInvoke( "getSearchStringEscape" 		,0,-1,	 "ﾜｲﾙﾄﾞｶｰﾄﾞ文字をｴｽｹｰﾌﾟするのに使用できる文字列を取得します。" )
		, new MetaDataInvoke( "getSQLKeywords" 				,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽの SQL ｷｰﾜｰﾄﾞであって、SQL92 のｷｰﾜｰﾄﾞではない、すべてのｷｰﾜｰﾄﾞをｺﾝﾏで区切ったﾘｽﾄを取得します。" )
		, new MetaDataInvoke( "getStringFunctions" 			,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽで使用可能なｺﾝﾏで区切った文字列関数のﾘｽﾄを取得します。" )
		, new MetaDataInvoke( "getSystemFunctions" 			,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽで使用可能なｺﾝﾏで区切ったｼｽﾃﾑ関数のﾘｽﾄを取得します。" )
		, new MetaDataInvoke( "getTimeDateFunctions" 		,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽで使用可能な時間関数と日付関数をｺﾝﾏで区切ったﾘｽﾄを取得します。" )
		, new MetaDataInvoke( "getURL" 						,0,-1,	 "この DBMS の URL を取得します。" )
		, new MetaDataInvoke( "getUserName" 				,0,-1,	 "このﾃﾞｰﾀﾍﾞｰｽに記録されているﾕｰｻﾞ名を取得します。" )

		, new MetaDataInvoke( "getDefaultTransactionIsolation" 	,0,-1, 	 "このﾃﾞｰﾀﾍﾞｰｽのﾃﾞﾌｫﾙﾄのﾄﾗﾝｻﾞｸｼｮﾝ遮断ﾚﾍﾞﾙを取得します。" )
		, new MetaDataInvoke( "getSQLStateType" 				,0,-1, 	 "Throwable.getSQLState によって返される SQLSTATE が X/Open (現在は Open Group) の SQL CLI であるか SQL99 であるかを示します。" )
		, new MetaDataInvoke( "getResultSetHoldability" 	,0,-1, 	 "この ResultSet ｵﾌﾞｼﾞｪｸﾄのﾃﾞﾌｫﾙﾄの保持機能を取得します。" )
		, new MetaDataInvoke( "allProceduresAreCallable" 	,0,-1, 	 "getProcedures ﾒｿｯﾄﾞによって返されるすべてのﾌﾟﾛｼｰｼﾞｬが、現在のﾕｰｻﾞから呼び出せるかどうかを取得します。" )
		, new MetaDataInvoke( "allTablesAreSelectable" 		,0,-1, 	 "getTables ﾒｿｯﾄﾞによって返されるすべてのﾃｰﾌﾞﾙが、現在のﾕｰｻﾞによって使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "dataDefinitionCausesTransactionCommit",0,-1,	"ﾄﾗﾝｻﾞｸｼｮﾝのﾃﾞｰﾀ定義文が、ﾄﾗﾝｻﾞｸｼｮﾝを強制的にコミットさせるかどうかを取得します。" )
		, new MetaDataInvoke( "dataDefinitionIgnoredInTransactions"  ,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ﾄﾗﾝｻﾞｸｼｮﾝでﾃﾞｰﾀ定義文が無視されるかどうかを取得します。" )
		, new MetaDataInvoke( "deletesAreDetected" 			,1,-1, 	 "ResultSet.rowDeleted ﾒｿｯﾄﾞを呼び出すことによって可視の行が削除されたことを検出できるかどうかを取得します。" )
		, new MetaDataInvoke( "doesMaxRowSizeIncludeBlobs" 	,0,-1, 	 "getMaxRowSize ﾒｿｯﾄﾞの戻り値が SQL ﾃﾞｰﾀの型の LONGVARCHAR および LONGVARBINARY を含むかどうかを取得します。" )
		, new MetaDataInvoke( "insertsAreDetected" 			,1,-1, 	 "ResultSet.rowInserted ﾒｿｯﾄﾞを呼び出すことによって可視の行が挿入されたことを検出できるかどうかを取得します。" )
		, new MetaDataInvoke( "isCatalogAtStart" 			,0,-1, 	 "完全修飾されたﾃｰﾌﾞﾙ名の開始部分 (または終了部分) にｶﾀﾛｸﾞが現れるかどうかを取得します。" )
		, new MetaDataInvoke( "isReadOnly" 					,0,-1, 	 "このﾃﾞｰﾀﾍﾞｰｽが読み込み専用モードかどうかを取得します。" )
		, new MetaDataInvoke( "locatorsUpdateCopy" 			,0,-1, 	 "LOB への変更が、ｺﾋﾟｰに対して行われたのか、LOB に直接行われたのかを示します。" )
		, new MetaDataInvoke( "nullPlusNonNullIsNull" 		,0,-1, 	 "このﾃﾞｰﾀﾍﾞｰｽが、NULL 値と非 NULL 値の連結を NULL とするかどうかを取得します。" )
		, new MetaDataInvoke( "nullsAreSortedAtEnd" 		,0,-1, 	 "NULL 値が、終了時にｿｰﾄ順にかかわらずｿｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "nullsAreSortedAtStart" 		,0,-1, 	 "NULL 値が、開始時にｿｰﾄ順にかかわらずｿｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "nullsAreSortedHigh" 			,0,-1, 	 "NULL 値が高位にｿｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "nullsAreSortedLow" 			,0,-1, 	 "NULL 値が下位にｿｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "othersDeletesAreVisible" 	,1,-1, 	 "他で行われた削除が可視かどうかを取得します。" )
		, new MetaDataInvoke( "othersInsertsAreVisible" 	,1,-1, 	 "他で行われた挿入が可視かどうかを取得します。" )
		, new MetaDataInvoke( "othersUpdatesAreVisible" 	,1,-1, 	 "他で行われた更新が可視かどうかを取得します。" )
		, new MetaDataInvoke( "ownDeletesAreVisible" 		,1,-1, 	 "結果セット自身の削除が可視かどうかを取得します。" )
		, new MetaDataInvoke( "ownInsertsAreVisible" 		,1,-1, 	 "結果セット自身の挿入が可視かどうかを取得します。" )
		, new MetaDataInvoke( "ownUpdatesAreVisible" 		,1,-1, 	 "指定された ResultSet オブジェクトについて、結果セット自身の更新が可視かどうかを取得します。" )
		, new MetaDataInvoke( "storesLowerCaseIdentifiers" 	,0,-1, 	 "このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符なしの SQL 識別子を、大文字小文字を区別しないで処理し、小文字で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "storesLowerCaseQuotedIdentifiers",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符付きの SQL 識別子を、大文字小文字を区別しないで処理し、小文字で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "storesMixedCaseIdentifiers" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符なしの SQL 識別子を、大文字小文字を区別しないで処理し、大文字小文字混在で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "storesMixedCaseQuotedIdentifiers",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符付きの SQL 識別子を、大文字小文字を区別しないで処理し、大文字小文字混在で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "storesUpperCaseIdentifiers" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符なしの SQL 識別子を、大文字小文字を区別しないで処理し、大文字で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "storesUpperCaseQuotedIdentifiers",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符付きの SQL 識別子を、大文字小文字を区別しないで処理し、大文字で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "supportsAlterTableWithAddColumn"	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、追加列のある ALTER TABLE がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsAlterTableWithDropColumn",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ﾄﾞﾛｯﾌﾟ列のある ALTER TABLE がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsANSI92EntryLevelSQL" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ANSI92 ｴﾝﾄﾘﾚﾍﾞﾙの SQL 文法がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsANSI92FullSQL" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ANSI92 完全ﾚﾍﾞﾙの SQL 文法がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsANSI92IntermediateSQL" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ANSI92 中間ﾚﾍﾞﾙの SQL 文法がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsBatchUpdates" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによってバッチ更新がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCatalogsInDataManipulation" 		,0,-1,	 "ﾃﾞｰﾀ操作文でｶﾀﾛｸﾞ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCatalogsInIndexDefinitions" 		,0,-1,	 "ｲﾝﾃﾞｯｸｽ定義文でｶﾀﾛｸﾞ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCatalogsInPrivilegeDefinitions"	,0,-1,	"特権定義文でｶﾀﾛｸﾞ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCatalogsInProcedureCalls" 	,0,-1,	"ﾌﾟﾛｼｰｼﾞｬ呼び出し文でｶﾀﾛｸﾞ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCatalogsInTableDefinitions" 	,0,-1,	"ﾃｰﾌﾞﾙ定義文でｶﾀﾛｸﾞ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsColumnAliasing"			 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって列の別名がｻﾎﾟｰﾄされるかどうかを取得します。  " )
	//	, new MetaDataInvoke( "supportsConvertFunc" 				,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、SQL の型間の CONVERT 関数がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCoreSQLGrammar" 				,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ODBC Core SQL 文法がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsCorrelatedSubqueries" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって照合関係ｻﾌﾞｸｴﾘｰがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsDataDefinitionAndDataManipulationTransactions"	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ﾄﾗﾝｻﾞｸｼｮﾝで、ﾃﾞｰﾀ定義文とﾃﾞｰﾀ操作文の両方がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsDataManipulationTransactionsOnly",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ﾄﾗﾝｻﾞｸｼｮﾝでﾃﾞｰﾀ操作文だけがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsDifferentTableCorrelationNames" 	,0,-1,	"ﾃｰﾌﾞﾙ相互関係名がｻﾎﾟｰﾄされる場合、ﾃｰﾌﾞﾙの名前と異なる名前であるという制限を付けるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsExpressionsInOrderBy" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ORDER BY ﾘｽﾄ中で式がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsExtendedSQLGrammar" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ODBC Extended SQL 文法がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsFullOuterJoins" 				,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、完全入れ子の外部結合がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsGetGeneratedKeys" 			,0,-1,	"文が実行されたあとに自動生成ｷｰを取得できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsGroupBy" 					,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、GROUP BY 節のﾌｫｰﾑがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsGroupByBeyondSelect" 		,0,-1,	"SELECT 文中のすべての列が GROUP BY 節に含まれるという条件で、このﾃﾞｰﾀﾍﾞｰｽによって、GROUP BY 節で SELECT 文中にない列の使用がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsGroupByUnrelated" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、GROUP BY 節で SELECT 文中にない列の使用がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsIntegrityEnhancementFacility",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、SQL Integrity Enhancement Facility がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsLikeEscapeClause" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、LIKE ｴｽｹｰﾌﾟ節の指定がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsLimitedOuterJoins" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、外部結合に関し、制限されたｻﾎﾟｰﾄが提供されるかどうかを取得します (supportsFullOuterJoins ﾒｿｯﾄﾞが true を返す場合は true)。" )
		, new MetaDataInvoke( "supportsMinimumSQLGrammar" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ODBC Minimum SQL 文法がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsMixedCaseIdentifiers" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符なしの SQL 識別子を、大文字小文字を区別して処理し、大文字小文字混在で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "supportsMixedCaseQuotedIdentifiers" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、大文字小文字が混在する引用符付きの SQL 識別子を、大文字小文字を区別して処理し、結果として大文字小文字混在で格納するかどうかを取得します。" )
		, new MetaDataInvoke( "supportsMultipleOpenResults" 		,0,-1,	"CallableStatement ｵﾌﾞｼﾞｪｸﾄから同時に返された複数の ResultSet ｵﾌﾞｼﾞｪｸﾄを持つことが可能かどうかを取得します。" )
		, new MetaDataInvoke( "supportsMultipleResultSets" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、execute ﾒｿｯﾄﾞの単一の呼び出しからの複数の ResultSet ｵﾌﾞｼﾞｪｸﾄの取得がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsMultipleTransactions" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが一度に複数のﾄﾗﾝｻﾞｸｼｮﾝを (異なった接続で) ｵｰﾌﾟﾝできるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsNamedParameters" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、callable 文への名前付きパラメータがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsNonNullableColumns" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽの列を非 null として定義できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsOpenCursorsAcrossCommit" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ｺﾐｯﾄ間でｶｰｿﾙがｵｰﾌﾟﾝされたままの状態がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsOpenCursorsAcrossRollback" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ﾛｰﾙﾊﾞｯｸ間でｶｰｿﾙがｵｰﾌﾟﾝされたままの状態がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsOpenStatementsAcrossCommit" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ｺﾐｯﾄ間で文がｵｰﾌﾟﾝされたままの状態がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsOpenStatementsAcrossRollback",0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ﾛｰﾙﾊﾞｯｸ間で文がｵｰﾌﾟﾝされたままの状態がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsOrderByUnrelated" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ORDER BY 節で SELECT 文中にない列の使用がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsOuterJoins" 					,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、外部結合のなんらかの形式がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsPositionedDelete" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、位置指定された DELETE 文がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsPositionedUpdate" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、位置指定された UPDATE 文がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsResultSetConcurrency" 		,2,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、指定された結果セットの型と与えられた並行処理の種類の組み合わせをｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsResultSetHoldability" 		,3,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、指定された結果セットの保持機能をｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsResultSetType" 				,4,ResultSet.TYPE_FORWARD_ONLY		,	"このﾃﾞｰﾀﾍﾞｰｽが、[TYPE_FORWARD_ONLY]指定された結果セットの型をｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsResultSetType" 				,4,ResultSet.TYPE_SCROLL_INSENSITIVE,	"このﾃﾞｰﾀﾍﾞｰｽが、[TYPE_SCROLL_INSENSITIVE]指定された結果セットの型をｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsResultSetType" 				,4,ResultSet.TYPE_SCROLL_SENSITIVE	,	"このﾃﾞｰﾀﾍﾞｰｽが、[TYPE_SCROLL_SENSITIVE]指定された結果セットの型をｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSavepoints" 					,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによってｾｰﾌﾞﾎﾟｲﾝﾄがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSchemasInDataManipulation" 	,0,-1,	"ﾃﾞｰﾀ操作文でｽｷｰﾏ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSchemasInIndexDefinitions" 	,0,-1,	"ｲﾝﾃﾞｯｸｽ定義文でｽｷｰﾏ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSchemasInPrivilegeDefinitions",0,-1,	"特権定義文でｽｷｰﾏ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSchemasInProcedureCalls" 	,0,-1,	"ﾌﾟﾛｼｰｼﾞｬ呼び出し文でｽｷｰﾏ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSchemasInTableDefinitions" 	,0,-1,	"ﾃｰﾌﾞﾙ定義文でｽｷｰﾏ名を使用できるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSelectForUpdate" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって SELECT FOR UPDATE 文がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsStatementPooling" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって文のﾌﾟｰﾙがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsStoredProcedures" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、ｽﾄｱﾄﾞﾌﾟﾛｼｰｼﾞｬｴｽｹｰﾌﾟ構文を使用するｽﾄｱﾄﾞﾌﾟﾛｼｰｼﾞｬｺｰﾙがｻﾎﾟｰﾄされるかどうかを判定します。" )
		, new MetaDataInvoke( "supportsSubqueriesInComparisons" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、比較式中でｻﾌﾞｸｴﾘｰがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSubqueriesInExists" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、EXISTS 式中でｻﾌﾞｸｴﾘｰがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSubqueriesInIns" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、IN 文中でｻﾌﾞｸｴﾘｰがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsSubqueriesInQuantifieds" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、定量化された式中でｻﾌﾞｸｴﾘｰがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsTableCorrelationNames" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによってﾃｰﾌﾞﾙ相互関係名がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsTransactionIsolationLevel" 	,4,Connection.TRANSACTION_READ_COMMITTED	,	"このﾃﾞｰﾀﾍﾞｰｽが、指定されたﾄﾗﾝｻﾞｸｼｮﾝ遮断ﾚﾍﾞﾙをｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsTransactionIsolationLevel" 	,4,Connection.TRANSACTION_READ_UNCOMMITTED	,	"このﾃﾞｰﾀﾍﾞｰｽが、指定されたﾄﾗﾝｻﾞｸｼｮﾝ遮断ﾚﾍﾞﾙをｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsTransactionIsolationLevel" 	,4,Connection.TRANSACTION_REPEATABLE_READ	,	"このﾃﾞｰﾀﾍﾞｰｽが、指定されたﾄﾗﾝｻﾞｸｼｮﾝ遮断ﾚﾍﾞﾙをｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsTransactionIsolationLevel" 	,4,Connection.TRANSACTION_SERIALIZABLE		,	"このﾃﾞｰﾀﾍﾞｰｽが、指定されたﾄﾗﾝｻﾞｸｼｮﾝ遮断ﾚﾍﾞﾙをｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "supportsTransactions" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによってﾄﾗﾝｻﾞｸｼｮﾝがｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsUnion" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって SQL UNION がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsUnionAll" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって SQL UNION ALL がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "updatesAreDetected" 		,1,-1,	"ResultSet.rowUpdated ﾒｿｯﾄﾞを呼び出すことによって可視の行が更新されたことを検出できるかどうかを取得します。" )
		, new MetaDataInvoke( "usesLocalFilePerTable" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、各ﾃｰﾌﾞﾙにﾌｧｲﾙを使用するかどうかを取得します。" )
		, new MetaDataInvoke( "usesLocalFiles" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、ﾛｰｶﾙﾌｧｲﾙにﾃｰﾌﾞﾙを格納するかどうかを取得します。" )
		, new MetaDataInvoke( "getAttributes" 			,72,-1,	"指定されたｽｷｰﾏおよびｶﾀﾛｸﾞで使用可能なﾕｰｻﾞ定義の型 (UDT) のための指定された型の指定された属性に関する記述を取得します。  " )
		, new MetaDataInvoke( "getBestRowIdentifier" 	,64,-1,	"行を一意に識別するﾃｰﾌﾞﾙの最適な列セットに関する記述を取得します。" )
		, new MetaDataInvoke( "getCatalogs" 			,50,-1,	"このﾃﾞｰﾀﾍﾞｰｽで使用可能なｶﾀﾛｸﾞ名を取得します。" )
		, new MetaDataInvoke( "getColumnPrivileges" 	,61,-1,	"ﾃｰﾌﾞﾙの列へのアクセス権に関する記述を取得します。  " )
		, new MetaDataInvoke( "getColumns" 				,61,-1,	"指定されたｶﾀﾛｸﾞで使用可能なﾃｰﾌﾞﾙ列の記述を取得します。  " )
		, new MetaDataInvoke( "getCrossReference" 		,65,-1,	"指定された主ｷｰﾃｰﾌﾞﾙの主ｷｰ列を参照する指定された外部のｷｰﾃｰﾌﾞﾙ中の、外部のｷｰ列に関する記述 (ﾃｰﾌﾞﾙが別のｷｰをインポートする方法を記述) を取得します。" )
		, new MetaDataInvoke( "getExportedKeys" 		,60,-1,	"指定されたﾃｰﾌﾞﾙの主ｷｰ列 (ﾃｰﾌﾞﾙによってｴｸｽﾎﾟｰﾄされた外部ｷｰ) を参照する外部ｷｰ列に関する記述を取得します。" )
		, new MetaDataInvoke( "getImportedKeys" 		,60,-1,	"ﾃｰﾌﾞﾙの外部ｷｰ列 (ﾃｰﾌﾞﾙによってｲﾝﾎﾟｰﾄされる主ｷｰ) を参照する主ｷｰ列に関する記述を取得します。" )
		, new MetaDataInvoke( "getIndexInfo" 			,63,-1,	"指定されたﾃｰﾌﾞﾙのｲﾝﾃﾞｯｸｽと統計情報に関する記述を取得します。" )
		, new MetaDataInvoke( "getPrimaryKeys" 			,60,-1,	"指定されたﾃｰﾌﾞﾙの主ｷｰ列の記述を取得します。" )
		, new MetaDataInvoke( "getProcedureColumns" 	,81,-1,	"指定されたｶﾀﾛｸﾞのｽﾄｱﾄﾞﾌﾟﾛｼｰｼﾞｬﾊﾟﾗﾒｰﾀと結果列に関する記述を取得します。  " )
		, new MetaDataInvoke( "getProcedures" 			,80,-1,	"指定されたｶﾀﾛｸﾞで使用可能なｽﾄｱﾄﾞﾌﾟﾛｼｰｼﾞｬに関する記述を取得します。  " )
		, new MetaDataInvoke( "getSchemas" 				,50,-1,	"このﾃﾞｰﾀﾍﾞｰｽで使用可能なｽｷｰﾏ名を取得します。" )
		, new MetaDataInvoke( "getSuperTables" 			,60,-1,	"このﾃﾞｰﾀﾍﾞｰｽの特定のｽｷｰﾏで定義されているﾃｰﾌﾞﾙ階層の説明を取得します。  " )
		, new MetaDataInvoke( "getSuperTypes" 			,70,-1,	"このﾃﾞｰﾀﾍﾞｰｽの特定のｽｷｰﾏで定義されているﾕｰｻﾞ定義型 (UDT) 階層の説明を取得します。" )
		, new MetaDataInvoke( "getTablePrivileges" 		,60,-1,	"ｶﾀﾛｸﾞで使用可能な各ﾃｰﾌﾞﾙに対するｱｸｾｽ権に関する記述を取得します。" )
		, new MetaDataInvoke( "getTables" 				,62,-1,	"指定されたｶﾀﾛｸﾞで使用可能なﾃｰﾌﾞﾙに関する記述を取得します。" )
		, new MetaDataInvoke( "getTableTypes" 			,50,-1,	"このﾃﾞｰﾀﾍﾞｰｽで使用可能なﾃｰﾌﾞﾙの型を取得します。" )
		, new MetaDataInvoke( "getTypeInfo" 			,50,-1,	"このﾃﾞｰﾀﾍﾞｰｽでｻﾎﾟｰﾄされているすべての標準 SQL の型に関する記述を取得します。" )
		, new MetaDataInvoke( "getUDTs" 				,71,-1,	"特定のｽｷｰﾏで定義されているﾕｰｻﾞ定義型 (UDT) の説明を取得します。" )
		, new MetaDataInvoke( "getVersionColumns" 		,60,-1,	"行の任意の値が変更された場合に、自動的に更新されるﾃｰﾌﾞﾙの列に関する記述を取得します。" )

	// 5.5.3.2 (2012/06/08) JDk1.6 用のﾒｿｯﾄﾞを追加します。
		, new MetaDataInvoke( "autoCommitFailureClosesAllResultSets"	,0,-1,	"autoCommit が true の場合に、ResultSet が保持可能であっても、すべてのｵｰﾌﾟﾝされた ResultSet がクローズされたことを SQLException が示すかどうかを取得します。" )
		, new MetaDataInvoke( "supportsConvert" 						,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽによって、JDBC 型 fromType と toType の間の変換に使用される JDBC ｽｶﾗｰ関数 CONVERT がｻﾎﾟｰﾄされるかどうかを取得します。" )
		, new MetaDataInvoke( "supportsStoredFunctionsUsingCallSyntax"	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽが、ｽﾄｱﾄﾞﾌﾟﾛｼｰｼﾞｬｰｴｽｹｰﾌﾟ構文を使用した、ﾕｰｻﾞ定義関数またはﾍﾞﾝﾀﾞｰ関数の呼び出しをｻﾎﾟｰﾄするかどうかを取得します。" )
		, new MetaDataInvoke( "getDatabaseMajorVersion" 	,0,-1,	"基本となるﾃﾞｰﾀﾍﾞｰｽのﾒｼﾞｬｰﾊﾞｰｼﾞｮﾝ番号を取得します。" )
		, new MetaDataInvoke( "getDatabaseMinorVersion" 	,0,-1,	"基本となるﾃﾞｰﾀﾍﾞｰｽのﾏｲﾅｰﾊﾞｰｼﾞｮﾝ番号を取得します。" )
		, new MetaDataInvoke( "getJDBCMajorVersion" 		,0,-1,	"このﾄﾞﾗｲﾊﾞの JDBC ﾒｼﾞｬｰﾊﾞｰｼﾞｮﾝ番号を取得します。" )
		, new MetaDataInvoke( "getJDBCMinorVersion" 		,0,-1,	"このﾄﾞﾗｲﾊﾞの JDBC ﾏｲﾅｰﾊﾞｰｼﾞｮﾝ番号を取得します。" )
		, new MetaDataInvoke( "getMaxBinaryLiteralLength" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽで、ｲﾝﾗｲﾝﾊﾞｲﾅﾘﾘﾃﾗﾙ中に入れられる 16 進数の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxCatalogNameLength" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ｶﾀﾛｸﾞ名の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxCharLiteralLength" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ｷｬﾗｸﾀﾘﾃﾗﾙの最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxColumnNameLength" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、列名の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxColumnsInGroupBy" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、GROUP BY 節中の列数の最大値を取得します。" )
		, new MetaDataInvoke( "getMaxColumnsInIndex" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ｲﾝﾃﾞｯｸｽ中の列数の最大値を取得します。" )
		, new MetaDataInvoke( "getMaxColumnsInOrderBy" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ORDER BY 節中の列数の最大値を取得します。" )
		, new MetaDataInvoke( "getMaxColumnsInSelect" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、SELECT ﾘｽﾄ中の列数の最大値を取得します。" )
		, new MetaDataInvoke( "getMaxColumnsInTable" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ﾃｰﾌﾞﾙ中の列数の最大値を取得します。" )
		, new MetaDataInvoke( "getMaxConnections" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽに対して可能な並行接続の最大数を取得します。" )
		, new MetaDataInvoke( "getMaxCursorNameLength" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ｶｰｿﾙ名の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxIndexLength" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ｲﾝﾃﾞｯｸｽの全部分を含む、ｲﾝﾃﾞｯｸｽの最大ﾊﾞｲﾄ数を取得します。" )
		, new MetaDataInvoke( "getMaxProcedureNameLength" 	,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ﾌﾟﾛｼｰｼﾞｬｰ名の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxRowSize" 				,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、1 行の最大ﾊﾞｲﾄ数を取得します。" )
		, new MetaDataInvoke( "getMaxSchemaNameLength" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ｽｷｰﾏ名の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxStatementLength" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、SQL 文の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxStatements" 			,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽの同時にｵｰﾌﾟﾝできるｱｸﾃｨﾌﾞな文の最大数を取得します。" )
		, new MetaDataInvoke( "getMaxTableNameLength" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ﾃｰﾌﾞﾙ名の最大文字数を取得します。" )
		, new MetaDataInvoke( "getMaxTablesInSelect" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、SELECT 文の最大ﾃｰﾌﾞﾙ数を取得します。" )
		, new MetaDataInvoke( "getMaxUserNameLength" 		,0,-1,	"このﾃﾞｰﾀﾍﾞｰｽでの、ﾕｰｻﾞ名の最大文字数を取得します。" )

		, new MetaDataInvoke( "getClientInfoProperties"		,50,-1,	"ﾄﾞﾗｲﾊﾞがｻﾎﾟｰﾄするｸﾗｲｱﾝﾄ情報ﾌﾟﾛﾊﾟﾃｨｰのﾘｽﾄを取得します。")
		, new MetaDataInvoke( "getFunctionColumns"			,81,-1,	"指定されたｶﾀﾛｸﾞのｼｽﾃﾑ関数またはﾕｰｻﾞ関数のﾊﾟﾗﾒｰﾀと返される型に関する記述を取得します。")
		, new MetaDataInvoke( "getFunctions"				,80,-1,	"指定されたｶﾀﾛｸﾞで使用可能なｼｽﾃﾑ関数およびﾕｰｻﾞ関数に関する記述を取得します。")
	} ;

	// 4.0.0.0 (2007/10/10) dbid の初期値を、"DEFAULT" から null に変更
	private String	dbid			;
	private String	catalog			;
	private String	schema			;
	private String	tableName		;
	private String	columnName		;
	private String	typeName		;
	private String	attributeName	;
	private String	procedureName	;
	private int		rowNo			;
	private int		maxRowCount		= 20;		// 5.5.3.2 (2012/06/08) 最大検索件数を、指定できるようにする。
	private String	likeKey			;			// 5.5.3.2 (2012/06/08) 特定の処理だけを実行できるように、あいまい検索

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public DatabaseMetaDataTag() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * Taglibの終了タグが見つかったときに処理する doEndTag() を オーバーライドします。
	 *
	 * @og.rev 3.8.7.0 (2006/12/15) アクセスログ取得の為,ApplicationInfoオブジェクトを設定
	 * @og.rev 4.0.0.1 (2007/12/03) try ～ catch ～ finally をきちんと行う。
	 *
	 * @return	後続処理の指示(EVAL_PAGE)
	 */
	@Override
	public int doEndTag() {
		debugPrint();		// 4.0.0 (2005/02/28)
		Connection conn = null;
		boolean errFlag = true;
		try {
			conn = ConnectionFactory.connection( dbid,getApplicationInfo() );	// 3.8.7.0 (2006/12/15)
			final DatabaseMetaData metaData = conn.getMetaData() ;

			callPrintMessage( metaData );
			errFlag = false;		// エラーではない
		}
		catch( final Throwable ex) {
			final String errMsg = "ﾃﾞｰﾀﾍﾞｰｽ処理を実行できませんでした。"
						+ ex.getMessage()  + CR ;

			throw new HybsSystemException( errMsg,ex );		// 3.5.5.4 (2004/04/15) 引数の並び順変更
		}
		finally {
			// 以下のコーディングの見直しを考える必要有り。
			// Connection はプールしている為、close() しても再利用されるだけ。
			if( errFlag ) { ConnectionFactory.remove( conn,dbid ); }	// 削除
			else {			ConnectionFactory.close( conn,dbid );  }	// 返却
		}

		jspPrint( "処理が完了しました。" + CR );		// 5.5.3.2 (2012/06/08) 終了メッセージ追加
		return EVAL_PAGE ;
	}

	/**
	 * タグリブオブジェクトをリリースします。
	 * キャッシュされて再利用されるので、フィールドの初期設定を行います。
	 *
	 * @og.rev 4.0.0.0 (2007/10/10) dbid の初期値を、"DEFAULT" から null に変更
	 * @og.rev 5.5.3.2 (2012/06/08) maxRowCount 最大検索件数を、指定できるようにする。
	 * @og.rev 5.5.3.2 (2012/06/08) likeKey 特定の処理だけを実行できるように、あいまい検索
	 */
	@Override
	protected void release2() {
		super.release2();
		dbid			= null ;
		catalog			= null ;
		schema			= null ;
		tableName		= null ;
		columnName		= null ;
		typeName		= null ;
		procedureName	= null ;
		attributeName	= null ;
		rowNo			= 0;
		maxRowCount		= 20;		// 5.5.3.2 (2012/06/08) 最大検索件数を、指定できるようにする。
		likeKey			= null;		// 5.5.3.2 (2012/06/08) 特定の処理だけを実行できるように、あいまい検索
	}

	/**
	 * 画面にテーブルタグの(TR)として、情報を出力します。
	 *
	 * 第一引数が、String の場合のオーバーロードメソッドです。
	 *
	 * @param	arg1	第一引数(String)
	 * @param	lbl		ラベル
	 * @param	msg		メッセージ
	 */
	private void printMessage( final String arg1, final String lbl, final String msg ) {
		final String str = "<tr class=\"row_" + (rowNo++ % 2) + "\"><td>"
				 + rowNo + "</td><td>"			// 5.5.3.2 (2012/06/08) 行番号を表示
				 + lbl + "</td><td>" + arg1 + "</td><td>" + msg + "</td></tr>" + CR ;
		jspPrint( str );
	}

	/**
	 * 画面にテーブルとして、情報を出力します。
	 *
	 * 第一引数が、ResultSet の場合のオーバーロードメソッドです。
	 *
	 * @param	resultSet	ResultSetオブジェクト
	 * @param	msg			メッセージ
	 */
	private void printMessage( final ResultSet resultSet, final String msg ) {
		final String str = msg + CR + makeTableTag( resultToString( resultSet ) ) ;
		jspPrint( str );
	}

	/**
	 * 画面にテーブルとして、情報を出力します。
	 *
	 * 第一引数が、存在しない場合のオーバーロードメソッドです。
	 *
	 * @param	lbl	ラベル
	 * @param	msg	メッセージ
	 */
	private void printMessage( final String lbl, final String msg ) {
		final String str = msg + CR + "<table><tr><td>" + lbl + "</td></tr></table>" + CR ;
		jspPrint( str );
	}

	/**
	 * 指定の文字列配列をテーブル上に表示する為の、テーブルを作成します。
	 *
	 * @og.rev 5.5.3.2 (2012/06/08) 行番号を表示するように修正
	 *
	 * @param	data	文字列配列の配列
	 *
	 * @return	文字列配列を表示する為のHTMLテーブル書式
	 * @og.rtnNotNull
	 */
	private String makeTableTag( final String[][] data ) {
		if( data == null || data.length == 0 ) { return "" ; }

		final int maxRow = data.length ;
		final int maxClm = data[0].length ;

		final StringBuilder buf = new StringBuilder( BUFFER_LARGE )
			.append( "<table>" ).append( CR )
			.append( "<tr class=\"row_h\"><th>No</th>" );		// 5.5.3.2 (2012/06/08) 行番号を表示
		for( int clm=0; clm<maxClm; clm++ ) {
			buf.append( "<th>" ).append( data[0][clm] ).append( "</th>" );
		}
		buf.append( "</tr>" ).append( CR );

		for( int row=1; row<maxRow; row++ ) {
			buf.append( "<tr class=\"row_" ).append( (row-1) % 2 )
				.append( "\"><td>" ).append( row ).append( "</td>" );			// 5.5.3.2 (2012/06/08) 行番号を表示
			for( int clm=0; clm<maxClm; clm++ ) {
				buf.append( "<td>" ).append( data[row][clm] ).append( "</td>" );
			}
			buf.append( "</tr>" ).append( CR );
		}
		buf.append( "</table>" ).append( CR );

		return buf.toString();
	}

	/**
	 * ステートメントと引数により、Queryを実行します。
	 * これは、Prepared クエリーの検索のみ実行します。
	 * 結果は,すべて文字列に変換されて格納されます。
	 *
	 * @og.rev 5.5.3.2 (2012/06/08) 最大検索件数を、指定できるようにする。
	 * @og.rev 6.0.4.0 (2014/11/28) ResultSetValue を使用するように変更。
	 *
	 * @param   resultSet ResultSetオブジェクト
	 *
	 * @return  ResultSetの検索結果配列
	 * @og.rtnNotNull
	 */
	private String[][] resultToString( final ResultSet resultSet ) {
		final ArrayList<String[]> data = new ArrayList<>();
		try {
			// 6.0.4.0 (2014/11/28) ResultSetValue を使用するように変更。
			final ResultSetValue rsv = new ResultSetValue( resultSet );

			data.add( rsv.getNames() );

			// とりあえず MAX １０件とする。
			int maxcnt = 0 ;
	 		// 5.5.3.2 (2012/06/08) 最大検索件数を、指定できるようにする。
			while( rsv.next() && maxcnt++ < maxRowCount ) {
				data.add( rsv.getValues() );
			}
		}
		catch( final SQLException ex) {
			final String errMsg = "処理結果を実行できませんでした。"
						+ ex.getMessage();		// 5.1.8.0 (2010/07/01) errMsg 修正
			throw new HybsSystemException( errMsg,ex );		// 3.5.5.4 (2004/04/15) 引数の並び順変更
		}

		final int size = data.size();
		String[][] rtn = new String[size][];
		for( int i=0; i<size; i++ ) {
			rtn[i] = data.get(i);
		}

		return rtn;
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のDB接続IDを指定します(初期値:null)。
	 *
	 * @og.tag Queryオブジェクトを作成する時のDB接続IDを指定します。
	 *
	 * @param	id ﾃﾞｰﾀﾍﾞｰｽ接続ID
	 */
	public void setDbid( final String id ) {
		dbid = nval( getRequestParameter( id ),dbid );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のカタログを指定します(初期値:null)。
	 *
	 * @og.tag Queryオブジェクトを作成する時のカタログを指定します。
	 *
	 * @param	val	ｶﾀﾛｸﾞ情報
	 */
	public void setCatalog( final String val ) {
		catalog = nval( getRequestParameter( val ),catalog );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のスキーマを指定します。
	 *
	 * @og.tag Queryオブジェクトを作成する時のｽｷｰﾏを指定します。
	 *
	 * @param	val	ｽｷｰﾏ情報
	 */
	public void setSchema( final String val ) {
		schema = nval( getRequestParameter( val ),schema );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のテーブル名を指定します。
	 *
	 * @og.tag Queryオブジェクトを作成する時のテーブル名を指定します。
	 *
	 * @param	val	テーブル名情報
	 */
	public void setTableName( final String val ) {
		tableName = nval( getRequestParameter( val ),tableName );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のカラム名を指定します。
	 *
	 * @og.tag Queryオブジェクトを作成する時のカラム名を指定します。
	 *
	 * @param	val	カラム名情報
	 */
	public void setColumnName( final String val ) {
		columnName = nval( getRequestParameter( val ),columnName );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のタイプ名を指定します。
	 *
	 * @og.tag Queryオブジェクトを作成する時のタイプ名を指定します。
	 *
	 * @param	val	タイプ名情報
	 */
	public void setTypeName( final String val ) {
		typeName = nval( getRequestParameter( val ),typeName );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時のプロダクト名を指定します。
	 *
	 * @og.tag Queryオブジェクトを作成する時のプロダクト名を指定します。
	 *
	 * @param	val	プロダクト名情報
	 */
	public void setProcedureName( final String val ) {
		procedureName = nval( getRequestParameter( val ),procedureName );
	}

	/**
	 * 【TAG】(通常は使いません)Queryオブジェクトを作成する時の属性名を指定します。
	 *
	 * @og.tag Queryオブジェクトを作成する時の属性名を指定します。
	 *
	 * @param	val	属性名情報
	 */
	public void setAttributeName( final String val ) {
		attributeName = nval( getRequestParameter( val ),attributeName );
	}

	/**
	 * 【TAG】maxRowCount ResultSetで検索するパラメータの最大検索件数を指定します(初期値:20)。
	 *
	 * @og.tag
	 ResultSetで検索する最大検索件数を指定します
	 * 大量に検索されて、処理速度が低下するのを避けるため、最大件数を指定します。
	 * 他のタグの maxRowCount の初期値設定(初期値:DB_MAX_ROW_COUNT)は利用せず、独自に設定値を持っています。
	 * 0は、無制限とします。
	 *
	 * @og.rev 5.5.3.2 (2012/06/08) likeKey 特定の処理だけを実行できるように、あいまい検索
	 * @og.rev 5.5.8.5 (2012/11/27) 0を無制限として処理します。
	 *
	 * @param	maxSize	最大件数
	 */
	public void setMaxRowCount( final String maxSize ) {
		maxRowCount = nval( getRequestParameter( maxSize ),maxRowCount );
		if( maxRowCount == 0 ) { maxRowCount = Integer.MAX_VALUE ; }			// 5.5.8.5 (2012/11/27)
	}

	/**
	 * 【TAG】実行するメソッドを選別するための部分一致するキーを指定します。
	 *
	 * @og.tag
	 * DatabaseMetaData で取得できる各種情報をアクセスするにあたり、指定のキーで部分一致する
	 * メソッドだけ処理するように指定します。
	 * メソッドの部分一致で判断します。
	 * 処理は、大文字、小文字を認識したうえで、部分一致で判定します。
	 *
	 * @og.rev 5.5.3.2 (2012/06/08) likeKey 特定の処理だけを実行できるように、あいまい検索
	 *
	 * @param	key	実行するﾒｿｯﾄﾞを選別するためのｷｰ
	 */
	public void setLikeKey( final String key ) {
		likeKey = nval( getRequestParameter( key ),likeKey );
	}

	/**
	 * 各ﾒｿｯﾄﾞ情報を画面に出力していきます。
	 *
	 * @og.rev 5.5.3.2 (2012/06/08) JDk1.6 用のﾒｿｯﾄﾞを追加します。
	 * @og.rev 6.4.2.1 (2016/02/05) try-with-resources 文が使えないので、通常の try 文で、close する。
	 *
	 * @param metaData DatabaseMetaDataオブジェクト
	 * @throws Throwable 何らかのエラーが発生した場合。
	 */
	private void callPrintMessage( final DatabaseMetaData metaData ) throws Throwable {
		// 単体のリターン値を持つ メタﾃﾞｰﾀ

		final Integer type = ResultSet.TYPE_FORWARD_ONLY ;
		final Integer concurrency = ResultSet.CONCUR_READ_ONLY;
		final Integer holdability = ResultSet.CLOSE_CURSORS_AT_COMMIT;

		jspPrint( "<table>" );
		jspPrint( "<tr class=\"row_h\"><th>No</th><th>ｷｰ</th><th>値</th><th>説明</th></tr>" );

		// 5.5.3.2 (2012/06/08) 個別に呼び出す箇所を、リフレクションに変更。
		for( int i=0; i<METHOD_LIST.length; i++ ) {
			final MetaDataInvoke inv = METHOD_LIST[i];
			if( inv.isUseMethod( likeKey ) && inv.getType() < 10 ) {
				Object obj = null;
				boolean isFume = false;		// 6.0.2.5 (2014/10/31) default に break を追記する為に、ロジック修正
				switch( inv.getType() ) {
					// 6.1.0.0 (2014/12/26) findBugs: Bug type DB_DUPLICATE_SWITCH_CLAUSES (click for details)
					// switch 文の2つの case のために同じコードを使用しています。
					case 0:
					case 4: obj = inv.invokeA( metaData );					break;
					case 1: obj = inv.invokeA( metaData,type );				break;
					case 2: obj = inv.invokeA( metaData,type,concurrency ); break;
					case 3: obj = inv.invokeA( metaData,holdability );		break;
					default : isFume = true;								break;				// 6.0.2.5 (2014/10/31)
				}
				if( isFume ) { jspPrint( "*** タイプ不明 ***" + BR ); continue; }	// 6.0.2.5 (2014/10/31)
				final String msg = (obj == null) ? inv.getErrMsg() : String.valueOf( obj );

				final String str = "<tr class=\"row_" + (rowNo++ % 2) + "\"><td>"
						+ rowNo + "</td><td>"			// 5.5.3.2 (2012/06/08) 行番号を表示
						+ inv.getMethod() + "</td><td>" + msg + "</td><td>" + inv.getComment() + "</td></tr>" + CR ;
				jspPrint( str );
			}
		}
		try { printMessage( metaData.getTimeDateFunctions() ,"getTimeDateFunctions",getTimeDateFunctions ); }
			catch( final Throwable e ) { printMessage( e.getMessage(),"getTimeDateFunctions",getTimeDateFunctions ); }

		jspPrint( "</table>" );

		if( metaData.supportsConvert() ) {
			supportsConvert( metaData );
		}

		// 5.5.3.2 (2012/06/08) 個別に呼び出す箇所を、リフレクションに変更。
		for( int i=0; i<METHOD_LIST.length; i++ ) {
			final MetaDataInvoke inv = METHOD_LIST[i];
			if( inv.isUseMethod( likeKey ) && inv.getType() >= 10 ) {
				ResultSet obj = null;
				// 6.4.2.1 (2016/02/05) try-with-resources 文が使えないので、通常の try 文で、close する。
				try {
					boolean isFume = false;		// 6.0.2.5 (2014/10/31) default に break を追記する為に、ロジック修正
					switch( inv.getType() ) {
						case 50: obj = inv.invokeB( metaData ); break;
						case 60:
						case 62:
						case 63:
						case 64:
						case 65: obj = inv.invokeB( metaData, catalog, schema, tableName ); break;
						case 70:
						case 71: obj = inv.invokeB( metaData, catalog, schema, typeName ); break;
						case 61: obj = inv.invokeB( metaData, catalog, schema, tableName, columnName ); break;
						case 72: obj = inv.invokeB( metaData, catalog, schema, typeName, attributeName ); break;
						case 81: obj = inv.invokeB( metaData, catalog, schema, procedureName, columnName ); break;
						case 80: obj = inv.invokeB( metaData, catalog, schema, procedureName ); break;
						default : isFume = true; break;												// 6.0.2.5 (2014/10/31)
					}
					if( isFume ) { jspPrint( "*** タイプ不明 ***" + BR ); continue; }	// 6.0.2.5 (2014/10/31)

					jspPrint( inv.getMethod() + ":" + inv.getComment() + BR );
					// 6.4.1.1 (2016/01/16) PMD refactoring. Avoid if (x != y) ..; else ..;
					if( obj == null ) {
						jspPrint( inv.getErrMsg() + BR );
					}
					else {
						jspPrint( makeTableTag( resultToString( obj ) ) );
					}
				}
				finally {
					Closer.resultClose( obj );
				}

			}
		}

		// 以下、リフレクションが、エラーなどで結果を返さないﾒｿｯﾄﾞ。
		jspPrint( "****************************************************************************************************" + BR );

		if( likeKey == null || "getAttributes".indexOf( likeKey ) >= 0 ) {
			jspPrint( "getAttributes:" + getAttributes + BR );
			try { printMessage( metaData.getAttributes(catalog, schema, typeName, attributeName) ,getAttributes); }
				catch( final Throwable e ) { printMessage( e.getMessage() ,getAttributes); }
		}
		if( likeKey == null || "getColumns".indexOf( likeKey ) >= 0 ) {
			jspPrint( "getColumns:" + getColumns + BR );
			try { printMessage( metaData.getColumns(catalog, schema, tableName, columnName) ,getColumns); }
				catch( final Throwable e ) { printMessage( e.getMessage() ,getColumns); }
		}
		if( likeKey == null || "getIndexInfo".indexOf( likeKey ) >= 0 ) {
			jspPrint( "getIndexInfo:" + getIndexInfo + BR );
			try { printMessage( metaData.getIndexInfo(catalog, schema, tableName, false, false) ,getIndexInfo); }
				catch( final Throwable e ) { printMessage( e.getMessage() ,getIndexInfo); }
		}
		if( likeKey == null || "getSuperTables".indexOf( likeKey ) >= 0 ) {
			jspPrint( "getSuperTables:" + getSuperTables + BR );
			try { printMessage( metaData.getSuperTables(catalog, schema, tableName) ,getSuperTables); }
				catch( final Throwable e ) { printMessage( e.getMessage() ,getSuperTables); }
		}
		if( likeKey == null || "getSuperTypes".indexOf( likeKey ) >= 0 ) {
			jspPrint( "getSuperTypes:" + getSuperTypes + BR );
			try { printMessage( metaData.getSuperTypes(catalog, schema, typeName) ,getSuperTypes); }
				catch( final Throwable e ) { printMessage( e.getMessage() ,getSuperTypes); }
		}
		if( likeKey == null || "getTypeInfo".indexOf( likeKey ) >= 0 ) {
			jspPrint( "getTypeInfo:" + getTypeInfo + BR );
			try { printMessage( metaData.getTypeInfo() ,getTypeInfo); }
				catch( final Throwable e ) { printMessage( e.getMessage() ,getTypeInfo); }
		}
	}

	/**
	 * ﾃﾞｰﾀﾍﾞｰｽの Types 定数を文字列に変換したテーブルを画面に出力します。
	 *
	 * @param metaData DatabaseMetaDataオブジェクト
	 * @throws Throwable 何らかのエラーが発生した場合。
	 * @see java.sql.Types
	 */
	private void supportsConvert( final DatabaseMetaData metaData ) throws Throwable {

		final int cnt = 36;
		int[]    key = new int[cnt] ;
		String[] msg = new String[cnt] ;

		int i = 0;
		key[i] = Types.ARRAY ;			msg[i++] = "ARRAY" ;			// 0
		key[i] = Types.BIGINT ;			msg[i++] = "BIGINT" ;			// 1
		key[i] = Types.BINARY ;			msg[i++] = "BINARY" ;			// 2
		key[i] = Types.BIT ;			msg[i++] = "BIT" ;				// 3
		key[i] = Types.BLOB ;			msg[i++] = "BLOB" ;				// 4
		key[i] = Types.BOOLEAN ;		msg[i++] = "BOOLEAN" ;			// 5
		key[i] = Types.CHAR ;			msg[i++] = "CHAR" ;				// 6
		key[i] = Types.CLOB ;			msg[i++] = "CLOB" ;				// 7
		key[i] = Types.DATALINK ;		msg[i++] = "DATALINK" ;			// 8
		key[i] = Types.DATE ;			msg[i++] = "DATE" ;				// 9
		key[i] = Types.DECIMAL ;		msg[i++] = "DECIMAL" ;			// 10
		key[i] = Types.DISTINCT ;		msg[i++] = "DISTINCT" ;			// 11
		key[i] = Types.DOUBLE ;			msg[i++] = "DOUBLE" ;			// 12
		key[i] = Types.FLOAT ;			msg[i++] = "FLOAT" ;			// 13
		key[i] = Types.INTEGER ;		msg[i++] = "INTEGER" ;			// 14
		key[i] = Types.JAVA_OBJECT ;	msg[i++] = "JAVA_OBJECT" ;		// 15
		key[i] = Types.LONGNVARCHAR ;	msg[i++] = "LONGNVARCHAR" ;		// 16	5.5.3.2 (2012/06/08)
		key[i] = Types.LONGVARBINARY ;	msg[i++] = "LONGVARBINARY" ;	// 17
		key[i] = Types.LONGVARCHAR ;	msg[i++] = "LONGVARCHAR" ;		// 18
		key[i] = Types.NCHAR ;			msg[i++] = "NCHAR" ;			// 19	5.5.3.2 (2012/06/08)
		key[i] = Types.NCLOB ;			msg[i++] = "NCLOB" ;			// 20	5.5.3.2 (2012/06/08)
		key[i] = Types.NULL ;			msg[i++] = "NULL" ;				// 21
		key[i] = Types.NUMERIC ;		msg[i++] = "NUMERIC" ;			// 22
		key[i] = Types.NVARCHAR ;		msg[i++] = "NVARCHAR" ;			// 23	5.5.3.2 (2012/06/08)
		key[i] = Types.OTHER ;			msg[i++] = "OTHER" ;			// 24
		key[i] = Types.REAL ;			msg[i++] = "REAL" ;				// 25
		key[i] = Types.REF ;			msg[i++] = "REF" ;				// 26
		key[i] = Types.ROWID ;			msg[i++] = "ROWID" ;			// 27	5.5.3.2 (2012/06/08)
		key[i] = Types.SMALLINT ;		msg[i++] = "SMALLINT" ;			// 28	5.5.3.2 (2012/06/08)
		key[i] = Types.SQLXML ;			msg[i++] = "SQLXML" ;			// 29
		key[i] = Types.STRUCT ;			msg[i++] = "STRUCT" ;			// 30
		key[i] = Types.TIME ;			msg[i++] = "TIME" ;				// 31
		key[i] = Types.TIMESTAMP ;		msg[i++] = "TIMESTAMP" ;		// 32
		key[i] = Types.TINYINT ;		msg[i++] = "TINYINT" ;			// 33
		key[i] = Types.VARBINARY ;		msg[i++] = "VARBINARY" ;		// 34
		key[i] = Types.VARCHAR ;		msg[i  ] = "VARCHAR" ;			// 35

		// それぞれ、Types 名称用のフィールドを追加
		String[][] table = new String[cnt+1][cnt+1];		// ヘッダー行を追加
		for( int hd=0; hd<cnt; hd++ ) {
			table[0][hd+1] = msg[hd];		// 行のヘッダー
			table[hd+1][0] = msg[hd];		// 列のヘッダー
		}

		for( int row=0; row<cnt; row++ ) {
			for( int clm=0; clm<cnt; clm++ ) {
				if( metaData.supportsConvert( key[row], key[clm]) ) {
					table[row+1][clm+1] = "○" ;
				}
				else {
					table[row+1][clm+1] = "×" ;
				}
			}
		}

		jspPrint( supportsConvertFunc + BR );
		jspPrint( makeTableTag( table ) );
	}

	/**
	 * メソッド処理を行う内部クラス
	 */
	private static final class MetaDataInvoke {
		private static final int     scope    = 0;
		private static final boolean nullable = true;

		private final String  method  ;
		private final int     type    ;			// 0:引数なし 1: 2: 3: 4:内部value
		private final Integer value   ;
		private final String  comment ;

		private String errMsg;

		/**
		 * メソッド処理を行うクラスのコンストラクター
		 *
		 * @param	method	メソッドの文字列表現
		 * @param	type	呼出しタイプ
		 * @param	value	設定値
		 * @param	comment	この処理に関するコメント
		 */
		public MetaDataInvoke( final String method,final int type,final int value,final String comment ) {
			this.method  = method  ;
			this.type	 = type    ;
			this.value   = Integer.valueOf(value) ;
			this.comment = comment ;
		}

		/**
		 * メソッドを返します。
		 *
		 * @return	メソッド
		 */
		public String getMethod() { return method; }

		/**
		 * LIKEキーをメソッドが含むかどうか。
		 *
		 * @param	likeKey LIKEキー
		 * @return	LIKEキーが、null か、または、LIKEキーをメソッドが含む場合、true
		 */
		public boolean isUseMethod( final String likeKey ) {
			return likeKey == null || method.indexOf( likeKey ) >= 0 ;
		}

		/**
		 * タイプを返します。
		 *
		 * @return	タイプ
		 */
		public int getType() { return type; }

		/**
		 * コメントを返します。
		 *
		 * @return	コメント
		 */
		public String getComment() { return comment; }

		/**
		 * エラーメッセージを返します。
		 *
		 * @return	エラーメッセージ
		 */
		public String getErrMsg() { return errMsg; }

		/**
		 * DatabaseMetaDataのオブジェクトを元に、動的にメソッド呼び出しを行います。
		 * メタデータ情報の取出しに使用します。
		 * 処理タイプに応じたメソッド呼び出しを行います。
		 *
		 * 0	引数なし
		 * 1	(int)
		 * 2	(int,int)
		 * 3	(int)
		 * 4	内部value
		 *
		 * @param	metaData	DatabaseMetaDataオブジェクト
		 * @param	vals		引数の文字列配列(可変長引数)
		 * @return	実行結果のオブジェクト
		 */
		public Object invokeA( final DatabaseMetaData metaData , final Integer... vals  ) {
			Object obj = null ;
			synchronized( metaData ) {
				try {
					if( type == 0 ) {
						obj = metaData.getClass().getMethod( method ).invoke(metaData);
					} else if( type == 1 || type == 3 ) {
						obj = metaData.getClass().getMethod( method,int.class )
													.invoke(metaData,vals[0]);
					} else if( type == 2 ) {
						obj = metaData.getClass().getMethod( method,int.class,int.class )
													.invoke(metaData,vals[0],vals[1]);
					} else if( type == 4 ) {
						obj = metaData.getClass().getMethod( method,int.class )
													.invoke(metaData,value);
					} else {
						errMsg = "*** リフレクションタイプなしエラー ***";
					}
				}
				catch( final Throwable ex ) {
					errMsg = "*** 実行時エラー ***" + ex.getMessage();
					obj = null;				// "*** 実行時エラー ***"
				}
			}
			if( obj == null && errMsg == null ) { errMsg = "ｻﾎﾟｰﾄされない機能です。"; }
			return obj ;
		}

		/**
		 * DatabaseMetaDataのオブジェクトを元に、動的にメソッド呼び出しを行います。
		 * メタデータ情報の取出しに使用します。
		 * 処理タイプに応じたメソッド呼び出しを行います。
		 *
		 * 50	引数なし
		 * 60	(catalog, schema, tableName)
		 * 70	(catalog, schema, typeName)
		 * 80	(catalog, schema, procedureName)
		 * 62	(catalog, schema, tableName, (String[])null)	 // String[]
		 * 71	(catalog, schema, typeName, (int[])null)		 // int[]
		 * 63	(catalog, schema, tableName, false, false)
		 * 61	(catalog, schema, tableName, columnName)
		 * 72	(catalog, schema, typeName, attributeName)
		 * 81	(catalog, schema, procedureName, columnName)
		 * 64	(catalog, schema, tableName, (int)scope, (boolean)nullable)
		 * 65	(catalog, schema, tableName, (String)null, (String)null, (String)null)
		 *
		 * @param	metaData	DatabaseMetaDataオブジェクト
		 * @param	vals		引数の文字列配列(可変長引数)
		 * @return	ResultSetオブジェクト
		 */
		public ResultSet invokeB( final DatabaseMetaData metaData , final String... vals  ) {
			ResultSet obj = null ;
			synchronized( metaData ) {
				try {
					if( type == 50 ) {	// 引数なし
						obj = (ResultSet)metaData.getClass().getMethod( method ).invoke(metaData);
					} else if( type == 60 || type == 70 || type == 80 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class )
								.invoke(metaData,vals[0],vals[1],vals[2]);
					} else if( type == 62 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class,String[].class )
								.invoke(metaData,vals[0],vals[1],vals[2],null);
					} else if( type == 71 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class,int[].class )
								.invoke(metaData,vals[0],vals[1],vals[2],null);
					} else if( type == 63 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class,boolean.class,boolean.class )
								.invoke(metaData,vals[0],vals[1],vals[2],false,false);
					} else if( type == 61 || type == 72 || type == 81 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class,String.class )
								.invoke(metaData,vals[0],vals[1],vals[2],vals[3]);
					} else if( type == 64 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class,int.class,boolean.class )
								.invoke(metaData,vals[0],vals[1],vals[2],scope,nullable);
					} else if( type == 65 ) {
						obj = (ResultSet)metaData.getClass()
								.getMethod( method,String.class,String.class,String.class,String.class,String.class,String.class )
								.invoke(metaData,vals[0],vals[1],vals[2],null,null,null);
					} else {
						errMsg = "*** リフレクションタイプなしエラー ***";
					}
				}
				catch( final Throwable ex ) {
					errMsg = "*** 実行時エラー ***" + ex.getMessage();
					obj = null;				// "*** 実行時エラー ***"
				}
			}
			if( obj == null && errMsg == null ) { errMsg = "ｻﾎﾟｰﾄされない機能です。"; }
			return obj ;
		}
	}

	/**
	 * このオブジェクトの文字列表現を返します。
	 * 基本的にデバッグ目的に使用します。
	 *
	 * @return このクラスの文字列表現
	 * @og.rtnNotNull
	 */
	@Override
	public String toString() {
		return ToString.title( this.getClass().getName() )
				.println( "VERSION"			,VERSION	)
				.println( "dbid"			,dbid		)
				.println( "catalog"			,catalog	)
				.println( "schema"			,schema		)
				.println( "tableName"		,tableName	)
				.println( "columnName"		,columnName	)
				.println( "typeName"		,typeName	)
				.println( "procedureName"	,procedureName)
				.println( "attributeName"	,attributeName)
				.println( "rowNo"			,rowNo		)
				.println( "Other..."		,getAttributes().getAttribute() )
				.fixForm().toString() ;
	}
}
