/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.ChartFactory;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsCategoryAxis;
import org.opengion.hayabusa.io.HybsCategoryPlot;
import org.opengion.hayabusa.io.HybsURLGenerator;

public class ChartCreate {
    private String title;
    private String chartType;
    private String domainLabel;
    private boolean showLegend = true;
    private RectangleEdge rectEdge = RectangleEdge.BOTTOM;
    private PlotOrientation plotOri = PlotOrientation.VERTICAL;
    private Color chartBackColor;
    private Color plotBackColor;
    private int rotationLabel;
    private boolean useVerticalLabels;
    private String domainMarker;
    private boolean useDomainLabel = true;
    private boolean useMarkerLabel = true;
    private int seriesPikup = -1;
    private HybsURLGenerator urlGen;
    private String categoryMargin;
    private String lowerMargin;
    private String upperMargin;
    private boolean isDebug;
    private boolean useDomainLine;
    private Color domainLineColor;
    private boolean useRangeLine = true;
    private Color rangeLineColor;
    private int categorySkip = 1;
    private int categoryCutNo = -1;
    private int rangeSkip = -1;
    private boolean useToolTip;
    private CategoryAnchor categoryAnchor;
    private List<ChartDataset> chartDataset;
    private String dateAxisFormat = "MM/dd";
    private SegmentedTimeline timeLine;

    public JFreeChart getChart() {
        ChartPlot chartPlot = ChartFactory.newChartPlot(this.chartType);
        Plot plot = chartPlot.getPlot(this);
        if (this.plotBackColor != null) {
            plot.setBackgroundPaint((Paint)this.plotBackColor);
        }
        JFreeChart jFreeChart = new JFreeChart(this.title, JFreeChart.DEFAULT_TITLE_FONT, plot, this.showLegend);
        if (this.showLegend) {
            jFreeChart.getLegend().setPosition(this.rectEdge);
        }
        if (this.chartBackColor != null) {
            jFreeChart.setBackgroundPaint((Paint)this.chartBackColor);
        }
        if (this.categoryAnchor != null && plot instanceof CategoryPlot) {
            ((CategoryPlot)plot).setDomainGridlinePosition(this.categoryAnchor);
        }
        return jFreeChart;
    }

    public static JFreeChart modifying(JFreeChart jFreeChart, int n) {
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        if (categoryPlot instanceof HybsCategoryPlot) {
            ((HybsCategoryPlot)categoryPlot).setSeriesPikup(n);
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        int n2 = categoryDataset.getRowCount();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        if (n >= 0 && n < n2) {
            categoryItemRenderer.setBasePaint((Paint)Color.CYAN);
            categoryItemRenderer.setSeriesPaint(n, (Paint)Color.RED);
        }
        return jFreeChart;
    }

    protected HybsCategoryPlot makeCategoryPlot() {
        HybsCategoryPlot hybsCategoryPlot = new HybsCategoryPlot(this.seriesPikup);
        hybsCategoryPlot.setOrientation(this.plotOri);
        hybsCategoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        hybsCategoryPlot.setDomainGridlinesVisible(this.useDomainLine);
        if (this.domainLineColor != null) {
            hybsCategoryPlot.setDomainGridlinePaint(this.domainLineColor);
        }
        hybsCategoryPlot.setRangeGridlinesVisible(this.useRangeLine);
        if (this.rangeLineColor != null) {
            hybsCategoryPlot.setRangeGridlinePaint(this.rangeLineColor);
        }
        hybsCategoryPlot.setRangeSkip(this.rangeSkip);
        if (this.domainMarker != null) {
            CategoryMarker categoryMarker = new CategoryMarker((Comparable)((Object)this.domainMarker));
            categoryMarker.setDrawAsLine(true);
            if (this.useMarkerLabel) {
                categoryMarker.setLabel(this.domainMarker);
            }
            hybsCategoryPlot.addDomainMarker(categoryMarker);
        }
        return hybsCategoryPlot;
    }

    protected CategoryAxis makeCategoryAxis() {
        double d;
        HybsCategoryAxis hybsCategoryAxis = new HybsCategoryAxis(this.domainLabel, this.categorySkip, this.categoryCutNo);
        if (this.categoryMargin != null) {
            d = Double.parseDouble(this.categoryMargin);
            hybsCategoryAxis.setCategoryMargin(d);
        }
        if (this.lowerMargin != null) {
            d = Double.parseDouble(this.lowerMargin);
            hybsCategoryAxis.setLowerMargin(d);
        }
        if (this.upperMargin != null) {
            d = Double.parseDouble(this.upperMargin);
            hybsCategoryAxis.setUpperMargin(d);
        }
        if (this.rotationLabel > 0) {
            hybsCategoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(Math.PI / (double)this.rotationLabel)));
        } else if (this.rotationLabel < 0) {
            hybsCategoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(Math.PI / (double)(-this.rotationLabel))));
        }
        hybsCategoryAxis.setVisible(this.useDomainLabel);
        if (this.isDebug) {
            System.out.println("CategoryMargin=" + hybsCategoryAxis.getCategoryMargin());
            System.out.println("LowerMargin=" + hybsCategoryAxis.getLowerMargin());
            System.out.println("UpperMargin=" + hybsCategoryAxis.getUpperMargin());
        }
        return hybsCategoryAxis;
    }

    public void setDatasetList(List<ChartDataset> list) {
        this.chartDataset = list;
        if (this.chartDataset != null) {
            ChartDataset chartDataset = this.chartDataset.get(0);
            this.chartType = chartDataset.getChartType();
        }
    }

    protected List<ChartDataset> getDatasetList() {
        return this.chartDataset;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setDomainLabel(String string) {
        this.domainLabel = string;
    }

    protected String getDomainLabel() {
        return this.domainLabel;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public void setRectangleEdge(String string) {
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'T': {
                    this.rectEdge = RectangleEdge.TOP;
                    break;
                }
                case 'B': {
                    this.rectEdge = RectangleEdge.BOTTOM;
                    break;
                }
                case 'R': {
                    this.rectEdge = RectangleEdge.RIGHT;
                    break;
                }
                case 'L': {
                    this.rectEdge = RectangleEdge.LEFT;
                    break;
                }
                default: {
                    String string2 = "\u6307\u5b9a\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + HybsConst.CR + "TOP,BOTTOM,RIGHT,LEFT \u306e\u4e2d\u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                    throw new HybsSystemException(string2);
                }
            }
        }
    }

    public void setPlotOrientation(String string) {
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'V': {
                    this.plotOri = PlotOrientation.VERTICAL;
                    break;
                }
                case 'H': {
                    this.plotOri = PlotOrientation.HORIZONTAL;
                    break;
                }
                default: {
                    String string2 = "\u6307\u5b9a\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + HybsConst.CR + "VERTICAL,HORIZONTAL \u306e\u4e2d\u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                    throw new HybsSystemException(string2);
                }
            }
        }
    }

    protected PlotOrientation getPlotOrientation() {
        return this.plotOri;
    }

    public void setChartBackColor(String string) {
        if (string != null && string.length() > 0) {
            this.chartBackColor = ColorMap.getColorInstance((String)string);
        }
    }

    public void setPlotBackColor(String string) {
        if (string != null && string.length() > 0) {
            this.plotBackColor = ColorMap.getColorInstance((String)string);
        }
    }

    public void setRotationLabel(int n) {
        this.rotationLabel = n;
    }

    public void setUseVerticalLabels(boolean bl) {
        this.useVerticalLabels = bl;
        if (this.useVerticalLabels && this.rotationLabel == 0) {
            this.rotationLabel = 2;
        }
    }

    protected int getRotationLabel() {
        return this.rotationLabel;
    }

    public void setDomainMarker(String string) {
        if (string != null && string.length() > 0) {
            this.domainMarker = string;
        }
    }

    public void setUseDomainLabel(boolean bl) {
        this.useDomainLabel = bl;
    }

    protected boolean isUseDomainLabel() {
        return this.useDomainLabel;
    }

    public void setUseMarkerLabel(boolean bl) {
        this.useMarkerLabel = bl;
    }

    public void setSeriesPikup(int n) {
        this.seriesPikup = n;
    }

    public void setCategorySkip(int n) {
        this.categorySkip = n;
    }

    public void setCategoryCutNo(int n) {
        if (n > 0) {
            this.categoryCutNo = n;
        }
    }

    protected int getSeriesPikup() {
        return this.seriesPikup;
    }

    public void setRangeSkip(int n) {
        this.rangeSkip = n;
    }

    public void setImageMapUrl(String string) {
        if (string != null) {
            this.urlGen = new HybsURLGenerator(string);
        }
    }

    protected HybsURLGenerator getURLGenerator() {
        return this.urlGen;
    }

    protected boolean isUseToolTip() {
        return this.useToolTip;
    }

    public void setCategoryMargin(String string) {
        this.categoryMargin = string;
    }

    public void setLowerMargin(String string) {
        this.lowerMargin = string;
    }

    public void setUpperMargin(String string) {
        this.upperMargin = string;
    }

    public void setUseDomainLine(boolean bl) {
        this.useDomainLine = bl;
    }

    public void setDomainLineColor(String string) {
        if (string != null) {
            this.domainLineColor = ColorMap.getColorInstance((String)string);
        }
    }

    public void setUseRangeLine(boolean bl) {
        this.useRangeLine = bl;
    }

    public void setUseToolTip(boolean bl) {
        this.useToolTip = bl;
    }

    public void setRangeLineColor(String string) {
        if (string != null) {
            this.rangeLineColor = ColorMap.getColorInstance((String)string);
        }
    }

    public void setCategoryAnchor(String string) {
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'S': {
                    this.categoryAnchor = CategoryAnchor.START;
                    break;
                }
                case 'M': {
                    this.categoryAnchor = CategoryAnchor.MIDDLE;
                    break;
                }
                case 'E': {
                    this.categoryAnchor = CategoryAnchor.END;
                    break;
                }
                default: {
                    String string2 = "\u6307\u5b9a\u306eAnchor\u306f\u9069\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + HybsConst.CR + "START,MIDDLE,END \u306e\u4e2d\u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                    throw new HybsSystemException(string2);
                }
            }
        }
    }

    public void setDateAxisFormat(String string) {
        if (string != null && string.length() > 0) {
            this.dateAxisFormat = string;
        }
    }

    public void setSegmentedTimelineInfo(int n, int n2, int n3, String string) {
        if (n > 0) {
            this.timeLine = new SegmentedTimeline((long)(n * 60 * 1000), n2, n3);
            if (string != null && string.length() >= 8) {
                Calendar calendar = HybsDateUtil.getCalendar((String)string);
                this.timeLine.setStartTime(calendar.getTimeInMillis());
            }
        }
    }

    protected DateAxis getDateAxis() {
        DateAxis dateAxis = new DateAxis(this.domainLabel);
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.dateAxisFormat, Locale.JAPAN));
        if (this.useVerticalLabels) {
            dateAxis.setVerticalTickLabels(this.useVerticalLabels);
        }
        if (this.timeLine != null) {
            dateAxis.setTimeline((Timeline)this.timeLine);
        }
        return dateAxis;
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }
}

