/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.ObjectConverter;

public class JDBC42ObjectConverter
implements ObjectConverter {
    @Override
    public boolean setObject(FBField field, Object object) throws SQLException {
        if (object instanceof LocalDate) {
            switch (field.requiredType) {
                case 91: {
                    LocalDate localDate = (LocalDate)object;
                    field.setFieldData(field.field.encodeLocalDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()));
                    return true;
                }
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof LocalTime) {
            switch (field.requiredType) {
                case 92: {
                    LocalTime localTime = (LocalTime)object;
                    field.setFieldData(field.field.encodeLocalTime(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano()));
                    return true;
                }
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            switch (field.requiredType) {
                case 91: {
                    field.setFieldData(field.field.encodeLocalDate(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth()));
                    return true;
                }
                case 92: {
                    field.setFieldData(field.field.encodeLocalTime(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano()));
                    return true;
                }
                case 93: {
                    field.setFieldData(field.field.encodeLocalDateTime(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano()));
                    return true;
                }
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof OffsetTime) {
            switch (field.requiredType) {
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof OffsetDateTime) {
            switch (field.requiredType) {
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        }
        return false;
    }
}

