/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Locale;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableReader;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ReadTableTag
extends CommonTagSupport {
    private static final String VERSION = "5.7.7.2 (2014/06/20)";
    private static final long serialVersionUID = 577220140620L;
    private static final int ERROR_ROW_COUNT = 200;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    private String separator = "\t";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String readerClass = HybsSystem.sys("TABLE_READER_DEFAULT_CLASS");
    private int maxRowCount = -1;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String notfoundMsg = "MSG0077";
    private int executeCount = -1;
    private String modifyType = null;
    private String adjustColumns = null;
    private String checkColumns = null;
    private String nullCheck = null;
    private transient DBTableModel table = null;
    private String command = "NEW";
    private String tableId = "h_tblmdl";
    private String sheetName = null;
    private String sheetNos = null;
    private String sheetConstKeys = null;
    private String sheetConstAdrs = null;
    private String nullBreakClm = null;
    private String columns = null;
    private boolean useNumber = true;
    private boolean stopZero = false;
    private static final String[] AUTO_READER_CLASS = new String[]{"Excel", "Calc", "Default", "Default"};
    private static final String[] AUTO_READER_ENCODE = new String[]{null, null, "UnicodeLittle", "Windows-31J"};
    private boolean isMainTrans = true;
    private int skipRowCount = 0;
    private String[] matchKeys = null;
    private String[] matchVals = null;
    private boolean useRenderer = HybsSystem.sysBool("USE_TABLE_READER_RENDERER");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        if (this.check(this.command, COMMAND_LIST)) {
            int n;
            String[] stringArray;
            String[] stringArray2;
            this.useMainTrans(this.isMainTrans);
            this.startQueryTransaction(this.tableId);
            if ("session".equals(this.getScope())) {
                this.removeSessionAttribute(this.tableId);
                this.removeSessionAttribute("h_vform");
            }
            if (this.maxRowCount < 0) {
                this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
            }
            BufferedReader bufferedReader = null;
            if ("AutoReader".equalsIgnoreCase(this.readerClass)) {
                if (this.columns != null && this.columns.length() > 0) {
                    String string = "columns\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306f\u3001readerClass=\"AutoReader\"\u306f\u4f7f\u3048\u307e\u305b\u3093";
                    throw new HybsSystemException(string);
                }
                stringArray2 = AUTO_READER_CLASS;
                stringArray = AUTO_READER_ENCODE;
            } else {
                stringArray2 = new String[]{this.readerClass};
                stringArray = new String[]{this.encode};
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < stringArray2.length; ++n) {
                this.readerClass = stringArray2[n];
                this.encode = stringArray[n];
                try {
                    if ("Excel".equalsIgnoreCase(this.readerClass) || "Calc".equalsIgnoreCase(this.readerClass)) {
                        this.create(null);
                    } else {
                        bufferedReader = this.getBufferedReader();
                        this.create(bufferedReader);
                    }
                    stringBuilder = null;
                }
                catch (Throwable throwable) {
                    try {
                        stringBuilder.append("readerClass=[").append(this.readerClass).append("],encode=[").append(this.encode).append("] Error!").append(HybsSystem.CR).append(throwable.getMessage()).append(HybsSystem.CR);
                    }
                    catch (Throwable throwable2) {
                        Closer.ioClose(bufferedReader);
                        throw throwable2;
                    }
                    Closer.ioClose((Closeable)bufferedReader);
                    continue;
                }
                Closer.ioClose((Closeable)bufferedReader);
                break;
            }
            if (stringBuilder != null) {
                String string = stringBuilder.toString();
                System.err.print(string);
                throw new HybsSystemException(string);
            }
            if (this.table != null) {
                ErrorMessage errorMessage;
                this.executeCount = this.table.getRowCount();
                if (this.modifyType != null) {
                    for (n = 0; n < this.executeCount; ++n) {
                        this.table.setModifyType(n, this.modifyType);
                    }
                }
                if ((errorMessage = this.checkTableColumn(this.table)) != null && !errorMessage.isOK()) {
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                    return 5;
                }
            }
            if (!this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("ReadTableTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
            StringBuilder stringBuilder2 = new StringBuilder(50);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder2.append(this.executeCount);
                    stringBuilder2.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder2.append(HybsSystem.BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder2.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder2.append(HybsSystem.BR);
                }
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.jspPrint(stringBuilder2.toString());
        }
        int n = this.executeCount == 0 && this.stopZero ? 5 : 6;
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = "\t";
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.readerClass = HybsSystem.sys("TABLE_READER_DEFAULT_CLASS");
        this.maxRowCount = -1;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.notfoundMsg = "MSG0077";
        this.executeCount = -1;
        this.modifyType = null;
        this.command = CMD_NEW;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.sheetName = null;
        this.sheetNos = null;
        this.sheetConstKeys = null;
        this.sheetConstAdrs = null;
        this.nullBreakClm = null;
        this.columns = null;
        this.useNumber = true;
        this.adjustColumns = null;
        this.checkColumns = null;
        this.nullCheck = null;
        this.stopZero = false;
        this.isMainTrans = true;
        this.skipRowCount = 0;
        this.matchKeys = null;
        this.matchVals = null;
        this.useRenderer = HybsSystem.sysBool("USE_TABLE_READER_RENDERER");
    }

    protected void create(BufferedReader bufferedReader) {
        String string = HybsSystem.sys("TableReader_" + this.readerClass);
        TableReader tableReader = (TableReader)HybsSystem.newInstance(string);
        tableReader.setResourceManager(this.getResource());
        tableReader.setSeparator(this.separator);
        tableReader.setEncode(this.encode);
        tableReader.setColumns(this.columns);
        tableReader.setUseNumber(this.useNumber);
        tableReader.setMaxRowCount(this.maxRowCount);
        tableReader.setSkipRowCount(this.skipRowCount);
        tableReader.setUseRenderer(this.useRenderer);
        tableReader.setMatchKeys(this.matchKeys);
        tableReader.setMatchVals(this.matchVals);
        tableReader.setDebug(this.isDebug());
        if (tableReader.isExcel()) {
            tableReader.setFilename(HybsSystem.url2dir(StringUtil.urlAppend((String)this.fileURL, (String)this.filename, (String[])new String[0])));
            tableReader.setSheetName(this.sheetName);
            tableReader.setSheetNos(this.sheetNos);
            tableReader.setSheetConstData(this.sheetConstKeys, this.sheetConstAdrs);
            tableReader.setNullBreakClm(this.nullBreakClm);
            tableReader.readDBTable();
        } else {
            tableReader.readDBTable(bufferedReader);
        }
        this.table = tableReader.getDBTableModel();
    }

    private BufferedReader getBufferedReader() {
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        String string = HybsSystem.url2dir(this.fileURL);
        File file = new File(StringUtil.urlAppend((String)string, (String)this.filename, (String[])new String[0]));
        BufferedReader bufferedReader = FileUtil.getBufferedReader((File)file, (String)this.encode);
        return bufferedReader;
    }

    private int[] makeClmNos(String string, DBTableModel dBTableModel) {
        int[] nArray;
        if (string == null) {
            nArray = new int[]{};
        } else if ("*".equals(string)) {
            int n = dBTableModel.getColumnCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            String[] stringArray = StringUtil.csv2Array((String)string);
            int n = stringArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dBTableModel.getColumnNo(stringArray[i]);
            }
        }
        return nArray;
    }

    private ErrorMessage checkTableColumn(DBTableModel dBTableModel) {
        ErrorMessage errorMessage = new ErrorMessage("Check Columns Error!");
        int n = dBTableModel.getRowCount();
        int[] nArray = this.makeClmNos(this.adjustColumns, dBTableModel);
        int[] nArray2 = this.makeClmNos(this.checkColumns, dBTableModel);
        int[] nArray3 = this.makeClmNos(this.nullCheck, dBTableModel);
        boolean bl = nArray.length > 0;
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            int n3;
            String[] stringArray = (String[])dBTableModel.getValues(i);
            DBColumn[] dBColumnArray = dBTableModel.getDBColumns();
            boolean bl2 = false;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                stringArray[n2] = dBColumnArray[n2].valueSet(stringArray[n2]);
            }
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = nArray2[n3];
                object = dBColumnArray[n2].valueCheck(stringArray[n2]);
                if (object.getKekka() <= 0) continue;
                bl2 = true;
                errorMessage.append(i + 1, dBColumnArray[n2].valueCheck(stringArray[n2]));
            }
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                n2 = nArray3[n3];
                if (stringArray[n2] != null && stringArray[n2].length() != 0) continue;
                bl2 = true;
                object = dBColumnArray[n2].getLabel();
                errorMessage.addMessage(i + 1, 2, "ERR0012", new String[]{object});
            }
            if (this.isDebug() && bl2) {
                errorMessage.addMessage(i + 1, 0, "Debug Info", new String[]{Arrays.toString(dBTableModel.getValues(i))});
            }
            if (bl && !bl2) {
                dBTableModel.setValues(stringArray, i);
            }
            if (errorMessage.size() > 200) break;
        }
        return errorMessage;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setReaderClass(String string) {
        this.readerClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readerClass);
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
        if (this.maxRowCount == 0) {
            this.maxRowCount = Integer.MAX_VALUE;
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setModifyType(String string) {
        this.modifyType = this.getRequestParameter(string);
    }

    public void setSheetName(String string) {
        this.sheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetName);
    }

    public void setSheetNos(String string) {
        this.sheetNos = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetNos);
        if (this.sheetNos != null && this.sheetNos.length() > 0) {
            boolean bl = false;
            for (int i = 0; i < this.sheetNos.length(); ++i) {
                char c = this.sheetNos.charAt(i);
                if (c == '-' || c == ',' || c == '*' && (i == 0 || i == this.sheetNos.length() - 1) || c >= '0' && c <= '9') continue;
                bl = true;
                break;
            }
            if (bl) {
                String string2 = "sheetNos \u306e\u6307\u5b9a\u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002sheetNos=[" + this.sheetNos + "]";
                throw new HybsSystemException(string2);
            }
        }
    }

    public void setSheetConstKeys(String string) {
        this.sheetConstKeys = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setSheetConstAdrs(String string) {
        this.sheetConstAdrs = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setNullBreakClm(String string) {
        this.nullBreakClm = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setCheckColumns(String string) {
        this.checkColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.checkColumns);
    }

    public void setAdjustColumns(String string) {
        this.adjustColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.adjustColumns);
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nullCheck);
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    public void setStopZero(String string) {
        this.stopZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopZero);
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setMatchKeys(String string) {
        this.matchKeys = this.getCSVParameter(string);
        if (this.matchVals != null && this.matchKeys.length != this.matchVals.length) {
            String string2 = "matchKeys\u5c5e\u6027\u3068matchVals\u5c5e\u6027\u306e\u500b\u6570\u304c\u5408\u3044\u307e\u305b\u3093\u3002" + HybsSystem.CR + " matchKeys=[" + this.matchKeys.length + "]:KEYS=" + StringUtil.array2csv((String[])this.matchKeys) + HybsSystem.CR + " matchVals=[" + this.matchVals.length + "]:VLAS=" + StringUtil.array2csv((String[])this.matchVals) + HybsSystem.CR;
            throw new HybsSystemException(string2);
        }
    }

    public void setMatchVals(String string) {
        this.matchVals = this.getCSVParameter(string);
        if (this.matchKeys != null && this.matchKeys.length != this.matchVals.length) {
            String string2 = "matchKeys\u5c5e\u6027\u3068matchVals\u5c5e\u6027\u306e\u500b\u6570\u304c\u5408\u3044\u307e\u305b\u3093\u3002" + HybsSystem.CR + " matchKeys=[" + this.matchKeys.length + "]:KEYS=" + StringUtil.array2csv((String[])this.matchKeys) + HybsSystem.CR + " matchVals=[" + this.matchVals.length + "]:VLAS=" + StringUtil.array2csv((String[])this.matchVals) + HybsSystem.CR;
            throw new HybsSystemException(string2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("separator", (Object)this.separator).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("encode", (Object)this.encode).println("readerClass", (Object)this.readerClass).println("maxRowCount", (Object)this.maxRowCount).println("displayMsg", (Object)this.displayMsg).println("executeCount", (Object)this.executeCount).println("modifyType", (Object)this.modifyType).println("checkColumns", (Object)this.checkColumns).println("adjustColumns", (Object)this.adjustColumns).println("nullCheck", (Object)this.nullCheck).println("command", (Object)this.command).println("tableId", (Object)this.tableId).println("sheetName", (Object)this.sheetName).println("sheetNos", (Object)this.sheetNos).println("columns", (Object)this.columns).println("useNumber", (Object)this.useNumber).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

