/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class ReplaceString {
    private final Set<ReplaceData> set = new TreeSet<ReplaceData>();

    public void add(int n, int n2, String string) {
        this.set.add(new ReplaceData(n, n2, string));
    }

    public String replaceAll(String string) {
        Iterator<ReplaceData> iterator = this.set.iterator();
        StringBuilder stringBuilder = new StringBuilder(string);
        while (iterator.hasNext()) {
            ReplaceData replaceData = iterator.next();
            stringBuilder = replaceData.replace(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static class ReplaceData
    implements Comparable<ReplaceData> {
        private final int start;
        private final int end;
        private final String newStr;
        private final int hCode;

        public ReplaceData(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.newStr = string;
            this.hCode = (string + n + "_" + n2).hashCode();
        }

        public StringBuilder replace(StringBuilder stringBuilder) {
            return stringBuilder.replace(this.start, this.end, this.newStr);
        }

        public boolean isOverlap(ReplaceData replaceData) {
            return replaceData == null || replaceData.end >= this.start && this.end >= replaceData.start;
        }

        @Override
        public int compareTo(ReplaceData replaceData) {
            if (replaceData == null) {
                String string = "\u5f15\u6570\u306b null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
                throw new IllegalArgumentException(string);
            }
            if (replaceData.hCode == this.hCode) {
                return 0;
            }
            if (this.isOverlap(replaceData)) {
                String string = "\u6bd4\u8f03\u5bfe\u7167\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3068\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3057\u3066\u3044\u307e\u3059\u3002 this =[" + this.start + "],[" + this.end + "],[" + this.newStr + "]" + " other=[" + replaceData.start + "],[" + replaceData.end + "],[" + replaceData.newStr + "]";
                throw new IllegalArgumentException(string);
            }
            return replaceData.start - this.start;
        }

        public boolean equals(Object object) {
            if (object instanceof ReplaceData) {
                ReplaceData replaceData = (ReplaceData)object;
                return this.start == replaceData.start && this.end == replaceData.end && this.newStr.equals(replaceData.newStr);
            }
            return false;
        }

        public int hashCode() {
            return this.hCode;
        }
    }
}

