/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.magnum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.magnum.Environment;
import org.openstack4j.model.magnum.EnvironmentBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagnumEnvironment
implements Environment {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="PATH")
    private String path;
    @JsonProperty(value="LD_LIBRARY_PATH")
    private String ldLibraryPath;

    public static EnvironmentBuilder builder() {
        return new EnvironmentConcreteBuilder();
    }

    @Override
    public EnvironmentBuilder toBuilder() {
        return new EnvironmentConcreteBuilder(this);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLdLibraryPath() {
        return this.ldLibraryPath;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("path", (Object)this.path).add("ldLibraryPath", (Object)this.ldLibraryPath).toString();
    }

    public static class EnvironmentConcreteBuilder
    implements EnvironmentBuilder {
        MagnumEnvironment model;

        public EnvironmentConcreteBuilder() {
            this(new MagnumEnvironment());
        }

        public EnvironmentConcreteBuilder(MagnumEnvironment model) {
            this.model = model;
        }

        @Override
        public Environment build() {
            return this.model;
        }

        @Override
        public EnvironmentBuilder from(Environment in) {
            if (in != null) {
                this.model = (MagnumEnvironment)in;
            }
            return this;
        }

        @Override
        public EnvironmentBuilder path(String path) {
            this.model.path = path;
            return this;
        }

        @Override
        public EnvironmentBuilder ldLibraryPath(String ldLibraryPath) {
            this.model.ldLibraryPath = ldLibraryPath;
            return this;
        }
    }
}

