/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.DataSourceService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.DataSource;
import org.openstack4j.openstack.sahara.domain.SaharaDataSource;
import org.openstack4j.openstack.sahara.domain.SaharaDataSourceUnwrapped;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class DataSourceServiceImpl
extends BaseSaharaServices
implements DataSourceService {
    @Override
    public List<? extends DataSource> list() {
        return this.get(SaharaDataSource.DataSources.class, this.uri("/data-sources", new Object[0])).execute().getList();
    }

    @Override
    public DataSource get(String datasourceId) {
        Preconditions.checkNotNull((Object)datasourceId);
        return this.get(SaharaDataSource.class, this.uri("/data-sources/%s", datasourceId)).execute();
    }

    @Override
    public DataSource create(DataSource datasource) {
        Preconditions.checkNotNull((Object)datasource);
        SaharaDataSourceUnwrapped unwrapped = new SaharaDataSourceUnwrapped(datasource);
        return this.post(SaharaDataSource.class, this.uri("/data-sources", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String datasourceId) {
        Preconditions.checkNotNull((Object)datasourceId);
        return this.deleteWithResponse(this.uri("/data-sources/%s", datasourceId)).execute();
    }
}

