/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.block;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.openstack4j.model.ModelEntity;

public interface VolumeBackup
extends ModelEntity {
    public String getId();

    public String getName();

    public String getDescription();

    public String getVolumeId();

    public String getContainer();

    public Boolean isIncremental();

    public String getZone();

    public Status getStatus();

    public int getSize();

    public Date getCreated();

    public String getFailReason();

    public int getObjectCount();

    public Boolean hasDependent();

    public String getSnapshotId();

    public static enum Status {
        AVAILABLE,
        CREATING,
        DELETING,
        ERROR,
        ERROR_RESTORING,
        RESTORING,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

