/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.CalendarDBData;
import org.opengion.hayabusa.resource.CalendarData;
import org.opengion.hayabusa.resource.CalendarQuery;

public final class CalendarFactory {
    private static final Map<String, CalendarData> pool = new WeakHashMap<String, CalendarData>();
    private static final Map<String, CalendarQuery> queryClassPool = new WeakHashMap<String, CalendarQuery>();
    private static CalendarData pgCalData = null;
    private static final String PG_CALENDAR_DATA_CLASS = HybsSystem.sys("DEFAULT_CALENDAR_CLASS");
    private static final Object lock = new Object();
    private static final String DBID = HybsSystem.sys("RESOURCE_CALENDAR_DBID");
    private static boolean useDB = HybsSystem.sysBool("USE_CALENDAR_DATABASE");
    private static final ApplicationInfo appInfo;

    private CalendarFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalendarData getCalendarData(String string, String string2, String string3, String string4, String string5) {
        Object object = lock;
        synchronized (object) {
            if (pgCalData == null) {
                pgCalData = (CalendarData)HybsSystem.newInstance(PG_CALENDAR_DATA_CLASS);
            }
        }
        if (!useDB) return pgCalData;
        if (string == null) {
            return pgCalData;
        }
        String string6 = string + ":" + string2 + ":" + string3 + ":" + string4 + ":" + string5;
        Object object2 = lock;
        synchronized (object2) {
            object = pool.get(string6);
        }
        if (object != null) return object;
        String[] stringArray = lock;
        synchronized (lock) {
            String[][] stringArray2;
            object2 = queryClassPool.get(string);
            if (object2 == null) {
                stringArray2 = HybsSystem.sys("CalendarQuery_" + string);
                object2 = (CalendarQuery)HybsSystem.newInstance((String)stringArray2);
                queryClassPool.put(string, (CalendarQuery)object2);
            }
            // ** MonitorExit[var8_10] (shouldn't be in output)
            stringArray = object2.checkArgment(string2, string3, string4, string5);
            stringArray2 = DBUtil.dbExecute((String)object2.getQuery(), (String[])stringArray, (ApplicationInfo)appInfo, (String)DBID);
            boolean bl = object2.isFlatTable();
            if (stringArray2 == null) return pgCalData;
            if (stringArray2.length <= 0) return pgCalData;
            object = new CalendarDBData(stringArray2, bl);
            Object object3 = lock;
            synchronized (object3) {
                pool.put(string6, (CalendarData)object);
                return object;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = lock;
        synchronized (object) {
            pool.clear();
            queryClassPool.clear();
            useDB = HybsSystem.sysBool("USE_CALENDAR_DATABASE");
        }
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                CalendarFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
        boolean bl = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
        if (bl) {
            String string = HybsSystem.sys("SYSTEM_ID");
            appInfo = new ApplicationInfo();
            appInfo.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            appInfo.setModuleInfo("CalendarFactory", null, null);
        } else {
            appInfo = null;
        }
    }
}

