/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NIOControlPacket;
import oracle.net.ns.NIODataDescriptorPacket;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.NetworkCompressionCodec;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpsNTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class SessionAtts
implements SQLnetDef {
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    private int sdu;
    private int tdu;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled = false;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect = false;
    protected String connectData;
    public boolean anoActive;
    protected boolean isLargeSDU = false;
    protected int negotiatedSDU = -1;
    protected boolean redirecting = false;
    protected boolean isJavaNetNIO = false;
    SocketChannel socketChannel;
    public NIONSDataChannel dataChannel;
    NIOMarkerPacket markerPacket;
    NIODataDescriptorPacket ddPacket;
    NIOControlPacket controlPacket;
    NTAdapter.NetworkAdapterType networkType;
    public ByteBuffer buffer = null;
    ByteBuffer payloadBuffer = null;
    ByteBuffer headerBuffer = null;
    public ByteBuffer payloadDataBuffer = null;
    boolean useNativeBuffers = false;
    boolean needToReleaseMSGQBuffer = false;
    String networkCompression;
    ArrayList<String> networkCompressionLevelsArray;
    int networkCompressionThreshold;
    String negotiatedNetworkCompression;
    boolean networkCompressionEnabled;
    int negotiatedNetworkCompressionScheme;
    NetworkCompressionCodec compressionCodec;
    String traceId;

    public SessionAtts(NSProtocol nSProtocol, int n2, int n3, boolean bl, boolean bl2) {
        this.sdu = n2;
        this.tdu = n3;
        this.ns = nSProtocol;
        this.anoActive = false;
        this.connected = false;
        if (bl) {
            this.dataChannel = new NIONSDataChannel(this);
            this.markerPacket = new NIOMarkerPacket(this);
            this.ddPacket = new NIODataDescriptorPacket(this);
            this.controlPacket = new NIOControlPacket(this);
            this.useNativeBuffers = bl2;
            this.isJavaNetNIO = true;
        }
    }

    protected void initializeBuffer(int n2) throws IOException {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            if (this.buffer == null) {
                MQLNTAdapter cfr_ignored_0 = (MQLNTAdapter)this.nt;
                this.buffer = MQLNTAdapter.getBufferManager().acquire(n2);
                this.needToReleaseMSGQBuffer = true;
            }
        } else {
            this.buffer = this.useNativeBuffers ? ByteBuffer.allocateDirect(n2) : ByteBuffer.allocate(n2);
        }
        this.sliceBuffer(this.buffer);
    }

    private void sliceBuffer(ByteBuffer byteBuffer) {
        byteBuffer.clear().limit(8);
        this.headerBuffer = byteBuffer.slice();
        byteBuffer.clear().position(8).limit(this.getSDU());
        this.payloadBuffer = byteBuffer.slice();
        byteBuffer.clear().position(10).limit(this.getSDU());
        this.payloadDataBuffer = byteBuffer.slice();
    }

    public void setSDU(int n2) {
        this.sdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (n2 <= 0 ? 65518 : (n2 > 65518 ? 65518 : (n2 < 512 ? 512 : n2))) : (n2 <= 0 ? 8192 : (n2 > 0x200000 ? 0x200000 : (n2 < 512 ? 512 : n2)));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int n2) {
        this.tdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (n2 <= 0 ? 65518 : (n2 > 65518 ? 65518 : (n2 < 255 ? 255 : n2))) : (n2 <= 0 ? 0x200000 : (n2 > 0x200000 ? 0x200000 : (n2 < 255 ? 255 : n2)));
    }

    public int getTDU() {
        return this.tdu;
    }

    void setNegotiatedSDUAndTDU(int n2, int n3) throws IOException {
        this.setTDU(n3);
        if (n3 < n2) {
            this.setSDU(n3);
        } else {
            this.setSDU(n2);
        }
        this.negotiatedSDU = this.sdu;
        this.initializeBuffer(this.getSDU());
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.nt).setNegotiatedSDUAndTDU(this.sdu, this.tdu);
        }
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    void renegotiateSSLSession() throws IOException {
        ((TcpsNTAdapter)this.nt).renegotiateSession();
        if (this.isJavaNetNIO) {
            this.socketChannel = this.nt.getSocketChannel();
        } else {
            this.ntInputStream = this.nt.getInputStream();
            this.ntOutputStream = this.nt.getOutputStream();
        }
    }

    @DisableTrace
    public String toString() {
        return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
    }

    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        if (netInputStream == null || netOutputStream == null) {
            throw new NetException(300);
        }
        this.nsInputStream = netInputStream;
        this.nsOutputStream = netOutputStream;
        this.anoActive = true;
    }

    public void turnEncryptionOn(NIONSDataChannel nIONSDataChannel) throws NetException {
        if (nIONSDataChannel == null) {
            throw new NetException(300);
        }
        this.dataChannel = nIONSDataChannel;
        this.anoActive = true;
    }

    public int getANOFlags() {
        int n2 = 1;
        if (this.ano != null) {
            n2 = this.ano.getNAFlags();
        }
        return n2;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public void setNegotiatedOptions(int n2) {
        this.negotiatedOptions = n2;
    }

    public int getNegotiatedOptions() {
        return this.negotiatedOptions;
    }

    public ConnOption getcOption() {
        return this.cOption;
    }

    void setConnectData(String string) {
        this.connectData = string;
    }

    String getConnectData() {
        return this.connectData;
    }

    void setBuffer(ByteBuffer byteBuffer) {
        if (this.needToReleaseMSGQBuffer) {
            MQLNTAdapter cfr_ignored_0 = (MQLNTAdapter)this.nt;
            MQLNTAdapter.getBufferManager().release(this.buffer);
            this.needToReleaseMSGQBuffer = false;
        }
        this.buffer = byteBuffer;
        this.sliceBuffer(this.buffer);
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

