/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;

public class OdfNamespace
implements Comparable,
NamespaceContext {
    private static Map<String, String> namesspacesByPrefix = new HashMap<String, String>();
    private static Map<String, String> namesspacesByUri = new HashMap<String, String>();
    private String mUri;
    private String mPrefix;
    private static SortedSet mNamespaces;

    public OdfNamespace() {
    }

    private OdfNamespace(String uri) {
        this(null, uri);
    }

    private OdfNamespace(String prefix, String uri) {
        if (uri != null && uri.length() > 0) {
            this.mUri = uri;
        }
        if (prefix != null && prefix.length() > 0) {
            this.mPrefix = prefix;
        }
    }

    public OdfName getOdfName(String name) {
        int i = name.indexOf(58);
        if (i >= 0) {
            return OdfName.get(this, name.substring(i + 1));
        }
        return OdfName.get(this, name);
    }

    public static OdfNamespace get(String uri) {
        OdfNamespace result;
        OdfNamespace newns = new OdfNamespace(uri);
        SortedSet<OdfNamespace> tail = mNamespaces.tailSet(newns);
        if (tail.size() > 0 && (result = tail.first()).equals(uri)) {
            return result;
        }
        mNamespaces.add(newns);
        return newns;
    }

    public static OdfNamespace get(OdfNamespaceNames name) {
        return OdfNamespace.get(name.getPrefix(), name.getNamespaceUri());
    }

    public static OdfNamespace get(String prefix, String uri) {
        OdfNamespace newns = new OdfNamespace(prefix, uri);
        SortedSet<OdfNamespace> tail = mNamespaces.tailSet(newns);
        for (Object e : tail) {
            OdfNamespace result = (OdfNamespace)e;
            if (!((Object)tail.first()).equals(uri)) break;
            if (!result.getPrefix().equals(prefix)) continue;
            return result;
        }
        mNamespaces.add(newns);
        return newns;
    }

    public boolean hasPrefix() {
        return this.mPrefix != null;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getUri() {
        return this.mUri;
    }

    public boolean equals(Object obj) {
        if (this.mUri != null) {
            return this.mUri.equals(obj.toString());
        }
        return this.mUri == obj;
    }

    public int hashCode() {
        if (this.mUri != null) {
            return this.mUri.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.mUri;
    }

    public static String[] splitQName(String qname) {
        String localpart = qname;
        String prefix = null;
        int colon = qname.indexOf(58);
        if (colon > 0) {
            localpart = qname.substring(colon + 1);
            prefix = qname.substring(0, colon);
        }
        return new String[]{prefix, localpart};
    }

    public static String getPrefixPart(String qname) {
        return OdfNamespace.splitQName(qname)[0];
    }

    public static String getLocalPart(String qname) {
        return OdfNamespace.splitQName(qname)[1];
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String getNamespaceURI(String prefix) {
        return namesspacesByPrefix.get(prefix);
    }

    public static String getNamespaceURIByPrefix(String prefix) {
        return namesspacesByPrefix.get(prefix);
    }

    public String getPrefix(String namespaceUri) {
        return namesspacesByUri.get(namespaceUri);
    }

    public Iterator getPrefixes(String namespaceuri) {
        return namesspacesByPrefix.keySet().iterator();
    }

    static {
        for (OdfNamespaceNames ns : OdfNamespaceNames.values()) {
            namesspacesByPrefix.put(ns.getPrefix(), ns.getNamespaceUri());
            namesspacesByUri.put(ns.getNamespaceUri(), ns.getPrefix());
        }
        mNamespaces = new TreeSet();
    }
}

