/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.taglet;

import com.sun.tools.doclets.standard.Standard;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.ClassDoc;

/**
 * 標準ドックレット com.sun.tools.doclets.standard.Standard のカスタマイズ版です。
 * 
 * クラスの概要説明部分の文書を、&lt;pre%gt; ・・・ &lt;/pre%gt; 処理します。
 *
 * @og.rev  6.0.2.0 (2014/09/19) 新規追加
 * @version  6.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK8.0,
 */
@SuppressWarnings(value={"deprecation"})			// Ver7.0.0.0
public final class DocletStandard {

	/**
	 * デフォルトコンストラクタ
	 * すべてが、staticメソッドなので、オブジェクトを作成させない。
	 *
	 * @og.rev 6.0.2.5 (2014/10/31) 新規追加
	 */
	private DocletStandard() {}

	/**
	 * Doclet のエントリポイントメソッドです。
	 *
	 * @og.rev 6.0.2.0 (2014/09/19) 新規追加
	 *
	 * @param	root	エントリポイントのRootDocオブジェクト
	 *
	 * @return 正常実行時 true
	 */
	public static boolean start( final RootDoc root ) {
		for( final ClassDoc classdoc : root.classes() ) {
			classdoc.setRawCommentText( "<pre>" + classdoc.getRawCommentText() + "</pre>" );
		}

		return Standard.start( root ); 
	}

	/**
	 * カスタムオプションを使用するドックレットの必須メソッド optionLength(String) です。
	 *
	 * ドックレットに認識させる各カスタムオプションに、 optionLength がその
	 * オプションを構成する要素 (トークン) の数を返さなければなりません。
	 * このカスタムオプションでは、 -tag オプションそのものと
	 * その値の 2 つの要素で構成されるので、作成するドックレットの
	 * optionLengthメソッドは、 -tag オプションに対して 2 を返さなくては
	 * なりません。また、認識できないオプションに対しては、0 を返します。
	 *
	 * @param	option	オプション文字列
	 *
	 * @return	要素(トークン) の数
	 */
	public static int optionLength( final String option ) {
		return Standard.optionLength(option);
	}
}
