/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class DBEventColumn {
    private static final String EVENT_COLUMN_URL = HybsSystem.sys("JSP") + "/" + HybsSystem.sys("EVENT_COLUMN_URL");
    private final String name;
    private final String eventColumn;
    private final String eventValue;
    private final String eventUrl;
    private final String renderer;
    private final String editor;
    private final String rendParam;
    private final String editParam;
    private final String valParam;
    private final Pattern trgPattern = Pattern.compile("(?<=\\{@)[^.]+?(?=\\})");
    private final boolean flgEncrypt = HybsSystem.sysBool("EVENT_SQL_ENCRYPT");
    private final HybsCryptography hc = this.flgEncrypt ? new HybsCryptography() : null;

    public DBEventColumn(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.name = string;
        this.eventColumn = string2;
        this.eventValue = string3;
        this.eventUrl = string4 != null && string4.length() > 0 ? string4 : EVENT_COLUMN_URL;
        this.renderer = string5;
        this.editor = string6;
        this.rendParam = string7;
        this.editParam = string8;
        this.valParam = "{@" + this.evColReplace(string2).replace(",", "}:{@") + "}";
    }

    public String getName() {
        return this.name;
    }

    public String getEventColumn() {
        return this.eventColumn;
    }

    public String getEventURL() {
        return this.eventUrl;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getRendParam() {
        StringFormat stringFormat = new StringFormat(this.rendParam, this.valParam, this.name);
        return this.flgEncrypt ? this.hc.encrypt(stringFormat.format()) : stringFormat.format();
    }

    public String getEditParam() {
        StringFormat stringFormat = new StringFormat(this.editParam, this.valParam, this.name);
        return this.flgEncrypt ? this.hc.encrypt(stringFormat.format()) : stringFormat.format();
    }

    public String getEventValue() {
        StringFormat stringFormat = new StringFormat(this.eventValue, this.valParam, this.name);
        return stringFormat.format();
    }

    private String evColReplace(String string) {
        String[] stringArray = string != null && string.indexOf(44) >= 0 ? StringUtil.csv2Array((String)string) : new String[]{string};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) != '_') continue;
            stringArray[i] = stringArray[i].substring(1);
        }
        return StringUtil.array2csv((String[])stringArray);
    }

    private String getTrgCsv(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        Matcher matcher = this.trgPattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(200);
        while (matcher.find()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(matcher.group());
        }
        return stringBuilder.toString();
    }

    public String getRendParamKeys() {
        if (!this.flgEncrypt || this.rendParam == null || this.rendParam.length() == 0) {
            return "";
        }
        StringFormat stringFormat = new StringFormat(this.rendParam, this.valParam, this.name);
        return this.getTrgCsv(stringFormat.format());
    }

    public String getEditParamKeys() {
        if (!this.flgEncrypt || this.editParam == null || this.editParam.length() == 0) {
            return "";
        }
        StringFormat stringFormat = new StringFormat(this.editParam, this.valParam, this.name);
        return this.getTrgCsv(stringFormat.format());
    }

    public boolean isFlgEncrypt() {
        return this.flgEncrypt;
    }
}

