package org.opengion.fukurou.model;

import java.io.File;
import java.io.FileFilter;

/**
 * ファイル情報の格納クラス
 * 
 * listFilesで取得した、
 * ディレクトリとファイル一覧情報の格納用クラスです。
 * 
 * @og.group ファイル操作
 * 
 * @og.rev 5.10.8.0 (2019/02/01) 新規作成
 * @author oota
 * @since JDK7.0
 */
public class FileOperationInfo extends AbstractFileOperation {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "7.0.1.9 (2019/02/04)" ;
	private static final long serialVersionUID = 701920190204L ;

	/** クラス変数 */
	private String path;
	private String name;
	private String parent;
	private long size;
	private long lastModified;
	private boolean isFile;
	private boolean isDirectory;
	private boolean isHidden;
	private boolean canRead;
	private boolean canWrite;

	/**
	 * コンストラクタ
	 */
	public FileOperationInfo() {
		// クラス変数の初期化
		path = "";
		name = "";
		parent = "";
		size = 0;
		lastModified = 0;
		isFile = false;
		isDirectory = false;
		isHidden = false;
		canRead = true;
		canWrite = true;
	}

	/** Getter ・ Setter */
	@Override
	public String getPath() {
		return path;
	}

	/**
	 * @param path
	 */
	public void setPath(String path) {
		this.path = path;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String getParent() {
		return parent;
	}

	/**
	 * @param parent
	 */
	public void setParent(String parent) {
		this.parent = parent;
	}

	@Override
	public long length() {
		return size;
	}

	/**
	 * @param size
	 */
	public void setSize(long size) {
		this.size = size;
	}

	@Override
	public long lastModified() {
		return lastModified;
	}

	/**
	 * @param lastModified
	 */
	public void setLastModifiedValue(long lastModified) {
		this.lastModified = lastModified;
	}

	@Override
	public boolean isFile() {
		return isFile;
	}

	/**
	 * @param isFile
	 */
	public void setFile(boolean isFile) {
		this.isFile = isFile;
	}

	@Override
	public boolean isDirectory() {
		return isDirectory;
	}

	/**
	 * @param isDirectory
	 */
	public void setDirectory(boolean isDirectory) {
		this.isDirectory = isDirectory;
	}

	@Override
	public boolean isHidden() {
		return isHidden;
	}

	/**
	 * @param isHidden
	 */
	public void setHidden(boolean isHidden) {
		this.isHidden = isHidden;
	}

	@Override
	public boolean canRead() {
		return canRead;
	}

	/**
	 * @param canRead
	 */
	public void setCanRead(boolean canRead) {
		this.canRead = canRead;
	}

	@Override
	public boolean canWrite() {
		return canWrite;
	}

	/**
	 * @param canWrite
	 */
	public void setCanWrite(boolean canWrite) {
		this.canWrite = canWrite;
	}

	/**
	 * １つ下の、ディレクトリ・ファイル一覧を取得します。
	 */
//	@Override
//	public FileOperation[] listFiles(FileOperationFileFilter filter) {
	public File[] listFiles(FileFilter filter) {
		FileOperation file = FileOperationFactory.newStorageOperation(path);
		return file.listFiles(filter);
	}

	/**
	 * compareToでは、パスの比較を行います。
	 */
//	@Override
//	public int compareTo(FileOperation trg) {
	public int compareTo(File trg) {
		return getPath().compareToIgnoreCase(trg.getPath());
	}

	/**
	 * カノニカルファイル取得メソッドでは、自身を返します。
	 */
	@Override
	public FileOperation getCanonicalFile() {
		return this;
	}
}
