/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.StringUtil;

public abstract class CloudFileOperation
extends FileOperation {
    private static final String VERSION = "7.0.2.1 (2019/03/04)";
    private static final long serialVersionUID = 702120190304L;
    private static final int BUFFER_SIZE = 4096;
    protected final String conPath;
    protected final String conBucket;
    private static final String UNIMPLEMNTED_ERR = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u672a\u5b9f\u88c5\u306e\u30e1\u30bd\u30c3\u30c9\u3067\u3059\u3002";
    private static final char FS = '/';

    public CloudFileOperation(String string, String string2) {
        super(string2);
        this.conPath = this.editPath(this.replaceFileSeparetor(string2));
        this.conBucket = string;
        if (StringUtil.isNull(this.conBucket)) {
            throw new RuntimeException("\u30d0\u30b1\u30c3\u30c8\u672a\u6307\u5b9a\u3067\u3059\u3002hayabusa\u5229\u7528\u3067\u306f\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u306e\u300cCLOUD_BUCKET\u300d\u306b\u30d0\u30b1\u30c3\u30c8\u540d\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    @Override
    public abstract void write(InputStream var1) throws IOException;

    @Override
    public abstract InputStream read() throws FileNotFoundException;

    @Override
    public abstract boolean delete();

    @Override
    public abstract boolean copy(String var1);

    @Override
    public abstract long length();

    @Override
    public abstract long lastModified();

    @Override
    public abstract boolean isFile();

    @Override
    public abstract boolean isDirectory();

    @Override
    public abstract File[] listFiles(FileFilter var1);

    @Override
    public abstract File getParentFile();

    @Override
    public String getPath() {
        return this.conPath;
    }

    @Override
    public String getAbsolutePath() {
        return this.conPath;
    }

    @Override
    public String getName() {
        return this.drawName(this.conPath);
    }

    @Override
    public String getParent() {
        return this.drawParent(this.conPath);
    }

    @Override
    public boolean move(String string) {
        boolean bl = false;
        bl = this.copy(string);
        if (bl) {
            bl = this.delete();
        }
        return bl;
    }

    @Override
    public boolean exists() {
        return this.isDirectory() | this.isFile();
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    @Override
    public boolean mkdirs() {
        return true;
    }

    @Override
    public boolean renameTo(File file) {
        return this.move(file.getPath());
    }

    @Override
    public boolean canWrite() {
        return this.exists();
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean createNewFile() throws IOException {
        boolean bl = false;
        if (!this.exists()) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                this.write(byteArrayInputStream);
                bl = true;
            }
            catch (Throwable throwable) {
                Closer.ioClose(byteArrayInputStream);
                throw throwable;
            }
            Closer.ioClose(byteArrayInputStream);
        }
        return bl;
    }

    @Override
    public boolean setLastModified(long l) {
        return true;
    }

    @Override
    public FileOperation getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public String toString() {
        return this.conPath;
    }

    protected String editPath(String string) {
        if (StringUtil.isNull(string)) {
            return "";
        }
        String string2 = string;
        if ('/' == (string2 = string2.replaceAll("//+", "/")).charAt(0)) {
            string2 = string2.substring(1);
        }
        string2 = this.rTrim(string2, '.');
        string2 = this.rTrim(string2, '/');
        return string2;
    }

    protected String drawParent(String string) {
        int n = string.lastIndexOf(47);
        Object object = "";
        if (n > 0) {
            object = string.substring(0, string.lastIndexOf(47));
        }
        if ("/".equals(File.separator)) {
            object = File.separator + (String)object;
        }
        return object;
    }

    protected String drawName(String string) {
        int n = string.lastIndexOf(47);
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(string.lastIndexOf(47) + 1);
        }
        return string2;
    }

    protected String setDirTail(String string) {
        if (StringUtil.isNull(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if ('/' != string.charAt(string.length() - 1)) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    protected String rTrim(String string, char c) {
        String string2 = string;
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == c; --i) {
            n = i;
            if (n != 0) continue;
            string2 = "";
        }
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected String replaceFileSeparetor(String string) {
        if (StringUtil.isNull(string)) {
            return "";
        }
        return string.replaceAll("\\\\", "/");
    }

    protected File[] filter(List<File> list, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (!fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] toByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean canExecute() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public void deleteOnExit() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public File getAbsoluteFile() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public long getFreeSpace() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public long getTotalSpace() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public long getUsableSpace() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public boolean isAbsolute() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public boolean setReadable(boolean bl) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public boolean setReadable(boolean bl, boolean bl2) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public boolean setWritable(boolean bl) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public boolean setWritable(boolean bl, boolean bl2) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    @Override
    public URI toURI() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }
}

