/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.system.OgBuilder;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.TableFormatter;
import org.opengion.plugin.view.ViewForm_HTMLTable;

public class ViewForm_HTMLGanttTable
extends ViewForm_HTMLTable {
    private static final String VERSION = "7.0.1.0 (2018/10/15)";
    private TableFormatter headerFormat;
    private TableFormatter[] bodyFormats;
    private TableFormatter footerFormat;
    private int bodyFormatsCount;
    private TableFormatter[] itdFormats;
    private String ganttHeadLine;
    private int[] groupCols;
    private int posDuration = -1;
    private int posDystart = -1;
    private String formatDystart = "yyyyMMdd";
    private double minDuration;
    private double headerDuration = this.minDuration = StringUtil.parseDouble((String)"1.0");
    private static final int BODYFORMAT_MAX_COUNT = 10;
    private static final Pattern TDTH_PTN = Pattern.compile("\\<(td|th)([^\\>]*)\\>(.*)\\</(td|th)\\>", 34);
    private int maxDayCnt;
    private String headerLocale;
    private String[] headDays;
    private int headDaysCnt;
    private static final String CHECK_ROW = "<input type=\"hidden\" name=\"h_rowSel\" value=\"";
    private boolean useSeqDay;
    private String startDay;
    private String endDay;
    private boolean useItd;

    @Override
    public void clear() {
        super.clear();
        this.headerFormat = null;
        this.bodyFormats = null;
        this.footerFormat = null;
        this.bodyFormatsCount = 0;
        this.ganttHeadLine = null;
        this.itdFormats = null;
        this.groupCols = null;
        this.posDuration = -1;
        this.posDystart = -1;
        this.formatDystart = "yyyyMMdd";
        this.headerDuration = this.minDuration = StringUtil.parseDouble((String)"1.0");
        this.maxDayCnt = 0;
        this.headerLocale = null;
        this.headDays = null;
        this.headDaysCnt = 0;
        this.useSeqDay = false;
        this.startDay = null;
        this.endDay = null;
        this.useItd = false;
    }

    @Override
    public String create(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getRowCount();
        if (n5 == 0) {
            return "";
        }
        if (this.headerFormat == null) {
            throw new HybsSystemException("ViewTag\u3067 canUseFormat() = true \u306e\u5834\u5408\u3001Formatter \u306f\u5fc5\u9808\u3067\u3059\u3002");
        }
        this.headerLine = null;
        int n6 = this.getLastNo(0, n5);
        int n7 = this.getBackLinkCount();
        int n8 = this.getHeaderSkipCount();
        int n9 = 1;
        this.paramInit();
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(this.getCountForm(0, n5));
        this.ganttHeadLine = this.posDuration < 0 ? this.getGanttHeadNoDuration(0, n6) : this.getGanttHead(0, n6);
        stringBuilder.append(this.getHeader());
        if (this.bodyFormatsCount == 0) {
            this.bodyFormats[0] = this.headerFormat;
            ++this.bodyFormatsCount;
        } else {
            for (int i = 0; i < this.bodyFormatsCount; ++i) {
                this.bodyFormats[i].makeFormat(this.getDBTableModel());
                this.setFormatNoDisplay(this.bodyFormats[i]);
                if (this.itdFormats[i] == null) continue;
                this.itdFormats[i].makeFormat(this.getDBTableModel());
                this.setFormatNoDisplay(this.itdFormats[i]);
            }
        }
        String[] stringArray = new String[this.groupCols.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        StringBuilder stringBuilder2 = new StringBuilder(500);
        StringBuilder stringBuilder3 = new StringBuilder(500);
        boolean bl = false;
        int n10 = 0;
        TableFormatter tableFormatter = null;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = 1;
            if (!this.isSameGroup(n4, stringArray)) {
                bl = this.getDBTableModel().isRowChecked(n4);
                if (n4 != 0) {
                    while (this.headDays != null && this.headDaysCnt < this.headDays.length) {
                        stringBuilder3.append("<td></td>");
                        ++this.headDaysCnt;
                    }
                    stringBuilder.append(StringUtil.replace((String)stringBuilder2.toString(), (String)"h_itd_marker", (String)stringBuilder3.toString()));
                    stringBuilder3.setLength(0);
                    this.headDaysCnt = 0;
                }
                stringBuilder2.setLength(0);
                for (int i = 0; i < this.bodyFormatsCount; ++i) {
                    int n11;
                    TableFormatter tableFormatter2 = this.bodyFormats[i];
                    if (!tableFormatter2.isUse(n4, this.getDBTableModel())) continue;
                    tableFormatter = this.itdFormats[i];
                    stringBuilder2.append("<tbody").append(this.getBgColorCycleClass(n10++)).append('>').append(tableFormatter2.getTrTag());
                    if (this.isNumberDisplay()) {
                        String string = "<td" + tableFormatter2.getRowspan();
                        stringBuilder2.append(this.makeCheckbox(string, n4, n7, true));
                        n3 = 0;
                    }
                    for (n11 = 0; n11 < tableFormatter2.getLocationSize(); ++n11) {
                        int n12;
                        Object object = tableFormatter2.getFormat(n11);
                        int n13 = tableFormatter2.getLocation(n11);
                        if (!tableFormatter2.isNoClass() && n13 >= 0 && (n12 = ((String)object).lastIndexOf("<td")) >= 0) {
                            String string = " class=\"" + this.getClassName(n13) + "\" ";
                            object = ((String)object).substring(0, n12 + 3) + string + ((String)object).substring(n12 + 3);
                        }
                        stringBuilder2.append((String)object);
                        if (n13 >= 0) {
                            stringBuilder2.append(this.getTypeCaseValue(tableFormatter2.getType(n11), n4, n13));
                            continue;
                        }
                        stringBuilder2.append(tableFormatter2.getSystemFormat(n4, n13));
                    }
                    stringBuilder2.append(tableFormatter2.getFormat(n11)).append("</tbody>").append(CR);
                }
                if (n8 > 0 && n9 % n8 == 0) {
                    stringBuilder2.append("<tbody class=\"row_h\" >").append(this.getHeadLine()).append("</tbody>");
                    n9 = 1;
                } else {
                    ++n9;
                }
            }
            if ((bl || this.isChecked(n4)) && n3 != 0) {
                this.getDBTableModel().setRowWritable(n4, true);
                stringBuilder.append(CHECK_ROW).append(n4).append("\" >");
            }
            this.formatItd(n4, tableFormatter, stringBuilder3);
        }
        if (stringBuilder3.length() > 0) {
            while (this.headDays != null && this.headDaysCnt < this.headDays.length) {
                stringBuilder3.append("<td></td>");
                ++this.headDaysCnt;
            }
            stringBuilder.append(StringUtil.replace((String)stringBuilder2.toString(), (String)"h_itd_marker", (String)stringBuilder3.toString()));
        }
        if (this.minDuration < 1.0) {
            n4 = this.useItd ? (int)Math.round((double)this.maxDayCnt / this.minDuration) : this.headerFormat.getLocationSize();
            stringBuilder.append("<tbody><tr class=\"dummy\">").append(CR);
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr></tbody>").append(CR);
        }
        if (this.footerFormat != null) {
            stringBuilder.append(this.getTableFoot(this.footerFormat));
        }
        stringBuilder.append("</table>").append(CR).append(this.getScrollBarEndDiv());
        return stringBuilder.toString();
    }

    private void paramInit() {
        String string = this.getParam("h_groupColumns", "PRJCODE,RESOURCE_ID");
        String string2 = this.getParam("h_durationColumn", null);
        String string3 = this.getParam("h_dystartColumn", "DYSTART");
        String string4 = this.getParam("h_minDuration", "1.0");
        this.formatDystart = this.getParam("h_dystartFormat", "yyyyMMdd");
        this.headerLocale = this.getParam("h_headerLocale", "ja");
        this.startDay = this.getParam("h_startDay", null);
        this.endDay = this.getParam("h_endDay", null);
        String string5 = this.getParam("h_useSeqDay", "false");
        this.useSeqDay = Boolean.parseBoolean(string5);
        DBTableModel dBTableModel = this.getDBTableModel();
        if (string2 != null) {
            this.posDuration = dBTableModel.getColumnNo(string2);
        }
        this.posDystart = dBTableModel.getColumnNo(string3);
        String[] stringArray = StringUtil.csv2Array((String)string);
        this.groupCols = new int[stringArray.length];
        for (int i = 0; i < this.groupCols.length; ++i) {
            this.groupCols[i] = dBTableModel.getColumnNo(stringArray[i]);
        }
        this.minDuration = StringUtil.parseDouble((String)string4);
        if (this.minDuration <= 0.0) {
            throw new HybsSystemException("\u6700\u5c0f\u671f\u9593\u5358\u4f4d(minDuration)\u304c\u3001\uff10 \u304b\u305d\u308c\u4ee5\u4e0b\u3067\u3059\u3002");
        }
        String string6 = this.getParam("h_headerDuration", string4);
        this.headerDuration = StringUtil.parseDouble((String)string6);
        if (this.headerDuration <= 0.0) {
            throw new HybsSystemException("\u30d8\u30c3\u30c0\u30fc\u306e\u8868\u793a\u671f\u9593(headerDuration)\u304c\u3001\uff10 \u304b\u305d\u308c\u4ee5\u4e0b\u3067\u3059\u3002");
        }
        if (this.posDuration < 0 && (Double.compare(this.minDuration, 1.0) != 0 || Double.compare(this.headerDuration, 1.0) != 0)) {
            throw new HybsSystemException("\u671f\u9593\u30ab\u30e9\u30e0(durationColumn)\u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u6700\u5c0f\u671f\u9593\u5358\u4f4d(minDuration)\u304a\u3088\u3073\u3001\u30d8\u30c3\u30c0\u30fc\u306e\u8868\u793a\u671f\u9593(headerDuration)\u3092 '1' \u4ee5\u5916\u306b\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
    }

    private boolean isSameGroup(int n, String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = this.groupCols.length > 0;
        if (bl) {
            int n2;
            for (n2 = 0; bl && n2 < this.groupCols.length; ++n2) {
                bl = stringArray[n2].equals(this.getValue(n, this.groupCols[n2]));
            }
            if (!bl) {
                for (n2 = 0; n2 < this.groupCols.length; ++n2) {
                    stringArray[n2] = this.getValue(n, this.groupCols[n2]);
                }
            }
        }
        return bl;
    }

    @Override
    protected String getTableHead() {
        this.headerFormat.makeFormat(this.getDBTableModel());
        this.setFormatNoDisplay(this.headerFormat);
        StringBuilder stringBuilder = new StringBuilder(200);
        if (this.isNumberDisplay()) {
            stringBuilder.append(NUMBER_DISPLAY);
        }
        return new OgBuilder().appendIf(this.isNumberDisplay(), new CharSequence[]{stringBuilder.toString()}).appendCR(new CharSequence[]{"<thead id=\"header\">"}).append(new CharSequence[]{this.getHeadLine()}).appendCR(new CharSequence[]{"</thead>"}).toString();
    }

    @Override
    protected String getHeadLine() {
        if (this.headerLine == null) {
            this.headerLine = this.getHeadLine("<th" + this.headerFormat.getRowspan());
        }
        return this.headerLine;
    }

    @Override
    protected String getHeadLine(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(200).append(this.headerFormat.getTrTag()).append(CR);
        if (this.isNumberDisplay()) {
            if (this.isUseCheckControl() && "checkbox".equals(this.getSelectedType())) {
                stringBuilder.append(string).append("></th>").append(string).append('>').append(this.getAllCheckControl()).append("</th>").append(string).append('>').append(this.getNumberHeader()).append("</th>");
            } else {
                stringBuilder.append(string).append(" colspan=\"3\">").append(this.getNumberHeader()).append("</th>");
            }
        }
        for (n = 0; n < this.headerFormat.getLocationSize(); ++n) {
            stringBuilder.append(this.headerFormat.getFormat(n));
            int n2 = this.headerFormat.getLocation(n);
            if (n2 < 0) continue;
            stringBuilder.append(this.getSortedColumnLabel(n2));
        }
        stringBuilder.append(this.headerFormat.getFormat(n)).append(CR);
        if (stringBuilder.indexOf("h_itd_marker") >= 0) {
            this.useItd = true;
        }
        return StringUtil.replace((String)stringBuilder.toString(), (String)"h_itd_marker", (String)this.ganttHeadLine);
    }

    private String getGanttHead(int n, int n2) {
        int n3;
        int n4;
        String string;
        Object object;
        String[] stringArray = new String[this.groupCols.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        Locale locale = new Locale(this.headerLocale);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.formatDystart, locale);
        double d = 0.0;
        Date date = null;
        for (int i = n; i < n2 && (this.isSameGroup(i, stringArray) || i == n); ++i) {
            d += StringUtil.parseDouble((String)this.getValue(i, this.posDuration));
            try {
                if (date != null) continue;
                date = simpleDateFormat.parse(this.getValue(i, this.posDystart));
                continue;
            }
            catch (ParseException parseException) {
                String string2 = "DYSTART\u306b\u6307\u5b9a\u3057\u305f\u65e5\u4ed8\u5f62\u5f0f\u3068\u7570\u306a\u308b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002[" + this.getValue(i, this.posDystart) + "] => [" + simpleDateFormat.toPattern() + "]";
                throw new HybsSystemException(string2, (Throwable)parseException);
            }
        }
        String string3 = "";
        String string4 = "MM/dd";
        if (this.headerFormat != null && ((Matcher)(object = TDTH_PTN.matcher(string = this.headerFormat.getItdBody().trim()))).find()) {
            string3 = ((Matcher)object).group(2);
            string4 = ((Matcher)object).group(3);
        }
        try {
            simpleDateFormat.applyPattern(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = "thead\u306e\u5185\u306eitd\u306e\u5185\u5074\u306b\u6307\u5b9a\u3055\u308c\u305f\u65e5\u4ed8\u306e\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059\u3002(" + string4 + ")";
            throw new HybsSystemException((String)object, (Throwable)illegalArgumentException);
        }
        int n5 = (int)Math.round(this.headerDuration / this.minDuration);
        object = n5 == 1 ? "<th " + string3 + ">" : "<th colspan=\"" + n5 + "\" " + string3 + ">";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.maxDayCnt = (int)Math.round(d / this.headerDuration);
        if (this.headerDuration >= 1.0) {
            n4 = (int)Math.round(this.headerDuration);
            n3 = 5;
        } else {
            n4 = (int)Math.round(24.0 * this.headerDuration);
            n3 = 11;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.maxDayCnt; ++i) {
            stringBuilder.append((String)object).append(simpleDateFormat.format(calendar.getTime())).append("</th>");
            calendar.add(n3, n4);
        }
        return stringBuilder.toString();
    }

    private String getGanttHeadNoDuration(int n, int n2) {
        Comparable<Date> comparable;
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray = new String[this.groupCols.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        String string = "";
        String string2 = "MM/dd";
        if (this.headerFormat != null && ((Matcher)(object3 = TDTH_PTN.matcher((CharSequence)(object2 = this.headerFormat.getItdBody().trim())))).find()) {
            string = ((Matcher)object3).group(2);
            string2 = ((Matcher)object3).group(3);
        }
        object2 = new Locale(this.headerLocale);
        object3 = new SimpleDateFormat(this.formatDystart, (Locale)object2);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = n; i < n2; ++i) {
            object = this.getValue(i, this.posDystart);
            treeSet.add((String)object);
        }
        if (this.useSeqDay) {
            if (this.startDay == null) {
                this.startDay = (String)treeSet.first();
            }
            if (this.endDay == null) {
                this.endDay = (String)treeSet.last();
            }
            try {
                Calendar calendar = Calendar.getInstance();
                object = ((DateFormat)object3).parse(this.startDay);
                calendar.setTime((Date)object);
                cloneable = Calendar.getInstance();
                comparable = ((DateFormat)object3).parse(this.endDay);
                ((Calendar)cloneable).setTime((Date)comparable);
                ((Calendar)cloneable).set(11, 12);
                while (calendar.before(cloneable)) {
                    treeSet.add(((DateFormat)object3).format(calendar.getTime()));
                    calendar.add(5, 1);
                }
            }
            catch (ParseException parseException) {
                object = "startDay,endDay\u306b\u6307\u5b9a\u3057\u305f\u65e5\u4ed8\u5f62\u5f0f\u3068\u7570\u306a\u308b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002[" + this.startDay + "],[[" + this.endDay + "] => [" + ((SimpleDateFormat)object3).toPattern() + "]";
                throw new HybsSystemException((String)object, (Throwable)parseException);
            }
        }
        this.headDays = treeSet.toArray(new String[treeSet.size()]);
        StringBuilder stringBuilder = new StringBuilder(200);
        object = "<th " + string + ">";
        cloneable = new SimpleDateFormat(string2, Locale.JAPAN);
        comparable = Calendar.getInstance();
        for (int i = 0; i < this.headDays.length; ++i) {
            try {
                ((Calendar)comparable).setTime(((DateFormat)object3).parse(this.headDays[i]));
                stringBuilder.append((String)object).append(((DateFormat)cloneable).format(((Calendar)comparable).getTime())).append("</th>");
                continue;
            }
            catch (ParseException parseException) {
                String string3 = "DYSTART\u306b\u6307\u5b9a\u3057\u305f\u65e5\u4ed8\u5f62\u5f0f\u3068\u7570\u306a\u308b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002[" + this.headDays[i] + "] => [" + ((SimpleDateFormat)object3).toPattern() + "]";
                throw new HybsSystemException(string3, (Throwable)parseException);
            }
        }
        return stringBuilder.toString();
    }

    private void formatItd(int n, TableFormatter tableFormatter, StringBuilder stringBuilder) {
        int n2;
        int n3;
        if (tableFormatter == null) {
            stringBuilder.setLength(0);
        }
        if (this.posDuration >= 0) {
            n3 = (int)Math.round(StringUtil.parseDouble((String)this.getValue(n, this.posDuration)) / this.minDuration);
        } else {
            String string = this.getValue(n, this.posDystart);
            int n4 = this.headDays[this.headDaysCnt].compareTo(string);
            ++this.headDaysCnt;
            while (n4 < 0 && this.headDaysCnt < this.headDays.length) {
                stringBuilder.append("<td></td>");
                n4 = this.headDays[this.headDaysCnt].compareTo(string);
                ++this.headDaysCnt;
            }
            if (n4 != 0) {
                String string2 = "\u65e5\u4ed8\u3051\u30d8\u30c3\u30c0\u30fc\u3068\u65e5\u4ed8\u3051\u30c7\u30fc\u30bf\u306b\u77db\u76fe\u304c\u767a\u751f\u3057\u3066\u3044\u307e\u3059\u3002" + CR + "groupColumns \u3067\u65e5\u4ed8\u3051\u304c\u30e6\u30cb\u30fc\u30af\u306b\u306a\u3063\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002row=[" + (n + 1) + "] , today=[" + string + "]";
                throw new HybsSystemException(string2);
            }
            n3 = 1;
        }
        for (n2 = 0; n2 < tableFormatter.getLocationSize(); ++n2) {
            String string = tableFormatter.getFormat(n2);
            int n5 = tableFormatter.getLocation(n2);
            if (n2 == 0 && n3 != 1) {
                string = StringUtil.replace((String)string, (String)"<td", (String)("<td colspan=\"" + n3 + "\""));
            }
            stringBuilder.append(string);
            if (n5 >= 0) {
                stringBuilder.append(this.getTypeCaseValue(tableFormatter.getType(n2), n, n5));
                continue;
            }
            stringBuilder.append(tableFormatter.getSystemFormat(n, n5));
        }
        stringBuilder.append(tableFormatter.getFormat(n2));
    }

    public void setFormatterList(List<TableFormatter> list) {
        Object object;
        int n;
        this.bodyFormats = new TableFormatter[10];
        this.bodyFormatsCount = 0;
        block5: for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            switch (object.getFormatType()) {
                case TYPE_HEAD: {
                    this.headerFormat = object;
                    continue block5;
                }
                case TYPE_BODY: {
                    this.bodyFormats[this.bodyFormatsCount++] = object;
                    continue block5;
                }
                case TYPE_FOOT: {
                    this.footerFormat = object;
                    continue block5;
                }
                default: {
                    throw new HybsSystemException("FormatterType \u306e\u5b9a\u7fa9\u5916\u306e\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
                }
            }
        }
        this.itdFormats = new TableFormatter[this.bodyFormatsCount];
        for (n = 0; n < this.bodyFormatsCount; ++n) {
            object = this.bodyFormats[n].getItdBody().trim();
            this.itdFormats[n] = new TableFormatter();
            this.itdFormats[n].setFormat((String)object);
        }
    }

    @Override
    public boolean canUseFormat() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }
}

