/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.text.MessageFormat;
import java.util.Arrays;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.LabelInterface;

public final class LabelData
implements LabelInterface {
    public static final int CLM = 0;
    public static final int SNAME = 1;
    public static final int LNAME = 2;
    public static final int DESCRIPTION = 3;
    public static final int DATA_SIZE = 4;
    static final int FG_LOAD = 4;
    static final int UNIQ = 5;
    static final int SYSTEM_ID = 6;
    private final String key;
    private final String label;
    private final String shortLabel;
    private final String longLabel;
    private final String description;
    private final boolean official;
    private final boolean isFormat;
    private final String rawShortLabel;
    private final boolean isFormatDesc;
    private final String rawLongLabel;

    public LabelData(String string) {
        this(string, string);
    }

    public LabelData(String string, String string2) {
        this.key = string.intern();
        this.label = string2;
        this.shortLabel = string2;
        this.longLabel = string2;
        this.description = "";
        this.official = false;
        this.isFormat = false;
        this.rawShortLabel = string2;
        this.isFormatDesc = false;
        this.rawLongLabel = string2;
    }

    LabelData(String[] stringArray) {
        this.key = stringArray[0].intern();
        this.label = StringUtil.yenN2br((String)stringArray[2]);
        this.description = StringUtil.yenN2br((String)stringArray[3]);
        this.official = true;
        this.isFormat = this.label.indexOf(123) >= 0;
        String string = null;
        this.rawLongLabel = this.label;
        if (this.description.isEmpty()) {
            this.isFormatDesc = false;
            string = StringUtil.htmlFilter((String)this.label, (boolean)true);
            this.longLabel = this.label;
        } else {
            this.isFormatDesc = this.description.indexOf(123) >= 0;
            string = StringUtil.htmlFilter((String)this.description, (boolean)true);
            this.longLabel = "<span title=\"" + string + "\">" + this.label + "</span>";
        }
        String string2 = stringArray[1];
        if (string2 == null || string2.isEmpty()) {
            this.shortLabel = this.longLabel;
            this.rawShortLabel = this.label;
        } else {
            this.shortLabel = "<span title=\"" + string + "\">" + string2 + "</span>";
            this.rawShortLabel = string2;
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public String getLongLabel() {
        return this.longLabel;
    }

    @Override
    public String getLongLabel(String string) {
        Object object = string == null ? this.longLabel : "<span title=\"" + StringUtil.htmlFilter((String)string, (boolean)true) + "\">" + this.label + "</span>";
        return object;
    }

    @Override
    public String getMessage(String ... stringArray) {
        String string;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[]{} : stringArray;
        if (this.isFormat) {
            try {
                string = MessageFormat.format(this.label, stringArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "MessageFormat\u30a8\u30e9\u30fc: Key [" + this.key + "] Pattern [" + this.label + "] Arguments [" + Arrays.toString(stringArray2) + "]";
                throw new HybsSystemException(string2, illegalArgumentException);
            }
        } else if (this.official) {
            string = this.label;
        } else {
            StringBuilder stringBuilder = new StringBuilder(200).append(this.label);
            for (String string3 : stringArray2) {
                if (string3 == null || string3.equals(this.label)) continue;
                stringBuilder.append(' ').append(string3);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescription(String ... stringArray) {
        String string;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[]{} : stringArray;
        if (this.isFormatDesc) {
            try {
                string = MessageFormat.format(this.description, stringArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "MessageFormat\u30a8\u30e9\u30fc: Key [" + this.key + "] Pattern [" + this.description + "] Arguments [" + Arrays.toString(stringArray2) + "]";
                throw new HybsSystemException(string2, illegalArgumentException);
            }
        } else {
            string = this.description;
        }
        return string;
    }

    @Override
    public boolean isOfficial() {
        return this.official;
    }

    public String getRawLongLabel() {
        return this.rawLongLabel;
    }

    public String getRawShortLabel() {
        return this.rawShortLabel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("CLM :").append(this.key).append(" SNAME :").append(this.shortLabel).append(" LNAME :").append(this.longLabel).append(" DESCRIPTION :").append(this.description).append(HybsConst.CR);
        return stringBuilder.toString();
    }
}

