<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7001"
	title    = "取込要求ﾃｰﾌﾞﾙ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select	SYSTEM_ID , RSRV_NO , NAME_JA , EXECID , FGYKAN
				 , DIR_BASE , DIR_SUB , DIR_WORK , DIR_BKUP_OK , DIR_BKUP_NG , FILE_FILTER
				 , RELEASE_NOTES , RDC_CODE , DYUPD , USRUPD , FGJ , UNIQ
		from GE70
	<og:where>
		<og:and value = "SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>
		<og:and value = "RSRV_NO	=		'{@RSRV_NO}'"		/>
		<og:and value = "NAME_JA	like	'{@NAME_JA}'"		/>
		<og:and value = "EXECID		like	'{@EXECID}'"		/>
		<og:and value = "FGYKAN		=		'{@FGYKAN}'"		/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhere.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,RSRV_NO" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="RSRV_NO" gamenId="GE7002" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,RSRV_NO,FGJ"
		vals="NEW,{@SYSTEM_ID},[RSRV_NO],1" />
	<og:link column="EXECID" gamenId="GE7004" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,EXECID,FGJ"
		vals="NEW,{@SYSTEM_ID},[EXECID],1" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,RSRV_NO"  />
	<og:submit  action="DELETE"  columnWritable="null" />
	<br />
</og:writeCheck>

<og:columnEditor columns="FILE_FILTER" clazz="W100" />
<og:columnEditor columns="SYSTEM_ID,RSRV_NO,EXECID,FGYKAN" must="true" />

<og:view
	viewFormType = "HTMLTable"
	command 	= "{@command}"
	noDisplay	= "UNIQ"
	checked 	= "{@checked}"
	startNo 	= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
