/*
 * Copyright (c) 2017 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;

/**
 * RunExec は、取込処理を実行するクラスの共通インターフェースです。
 *
 *<pre>
 *
 * ここでは、個々の取込ファイルを解析して、処理を実行します。
 *
 *</pre>
 *
 * @og.rev 7.0.0.0 (2017/07/07) 新規作成
 *
 * @version  7.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8,
 */
public interface RunExec {

	/**
	 * 実際に処理を実行するプログラムのメソッド。
	 *
	 * @param	path 処理するファイルパス
	 * @param	ge72Data GE72 テーブルデータ
	 * @return	処理件数(正は成功、マイナスは異常時の行番号)
	 */
	int exec( final Path path , final String[] ge72Data );
}
