<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT02"
	title	= "リソースマスタ登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "CDBUN,CDRSC"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select RESOURCE_ID,CDBUN,CDRSC,NAME_JA,FUNC,SU_LOAD,CONTACTS,PHONE,FGJ
		from GF63
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "RESOURCE_ID like '{@RESOURCE_ID}'"    />
		<og:and value = "CDBUN       like '{@CDBUN}'"      />
		<og:and value = "CDRSC       like '{@CDRSC}'"      />
		<og:and value = "NAME_JA        like '{@NAME_JA}'"       />
		<og:and value = "FUNC    like '{@FUNC}'"   />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "CDBUN,CDRSC" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />

	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF65" /></strong></legend>
		<og:submit  value="insertGF65" lbl="INSERT" command="MODIFY" />
		<og:select name="PRJCODE" td="no">
			<og:queryOption>
					select PRJCODE,PRJCODE,NAME_JA from GF62
					group by PRJCODE,NAME_JA order by 1
			</og:queryOption>
		</og:select>
	</fieldset><br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}"  />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
