// package org.opengion.fukurou.util;
package org.opengion.fukurou.business;

// import org.opengion.fukurou.business.BizLogicHelper;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.HybsLoaderFactory;
import org.opengion.fukurou.util.HybsLoaderConfig;
import org.opengion.fukurou.db.TransactionImpl;

/**
 * bizLogicファイル共通クラス
 * bizLogicファイルを処理するための、
 * 共通クラスです。
 *
 * @og.rev 5.10.15.2 (2019/09/20) 新規作成
 * 
 * @version 5
 * @author oota
 * @since JDK7
 */
public final class BizUtil {
	
	/**
	 * private コンスタクター
	 * インスタンスは生成せずに、利用します。
	 */
	private BizUtil() {	}
	
	/**
	 * bizLogicファイルの実行 bizLogicファイルをホットデプロイして、
	 * 処理を実行します。
	 * 
	 * @param srcDir ソースディレクトリ
	 * @param classDir クラスディレクトリ
	 * @param isAutoCompile オートコンプリートフラグ
	 * @param isHotDeploy ホットデプロイフラグ
	 * @param classPath クラスパス
	 * @param systemId システムID
	 * @param logicName ロジック名
	 * @param keys キーリスト
	 * @param vals 値リスト
	 * @throws Throwable エラー情報
	 */
	public static void actBizLogic(final String srcDir, final String classDir, final boolean isAutoCompile, final boolean isHotDeploy, final String classPath,
			final String systemId, final String logicName, final String[] keys, final String[] vals) throws Throwable {

		// bizクラスファイルのホットデプロイ
		final HybsLoader ldr = HybsLoaderFactory
				.getLoader(new HybsLoaderConfig(srcDir, classDir, isAutoCompile, isHotDeploy, classPath));

		final BizLogicHelper helper = new BizLogicHelper(logicName, ldr);

		final TransactionImpl tran = new TransactionImpl(null);
		helper.setTransaction(tran);
		helper.setDbid(systemId);
		helper.setKeys(keys);
		helper.setVals(vals);

		try {
			// bizLogic実行
			helper.exec();
			
			// 正常に実行された場合
			tran.commit();
			tran.finish();
		}catch(Throwable e) {
			// エラー発生時
			tran.rollback();
			throw  e;
		} finally {
			if (tran != null) {
				tran.close();
//				tran.realClose();
			}
		}
	}
}
