/****************************************************************************/
/* GE65 ( キュー管理マスタ )                                                */
/*                                                                          */
/* Created : 2019/09/02 09:36:19                                            */
/****************************************************************************/
CREATE TABLE GE65 (
   SYSTEM_ID    VARCHAR2 (  10 )                    NOT NULL            /*  10 ｼｽﾃﾑID       */
 , QUEUEID      VARCHAR2 ( 100 )                    NOT NULL            /*  20 キューID     */
 , QUESYU       VARCHAR2 (  10 )                    NOT NULL            /*  30 キュー種別   */
 , JMSURL       VARCHAR2 ( 100 )                                        /*  40 JMS接続先    */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0   NOT NULL            /*  50 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1' NOT NULL            /*  60 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (  14 )                                        /*  70 登録日時     */
 , PGSET        VARCHAR2 (  10 )                                        /*  80 作成PG       */
 , PGPSET       VARCHAR2 (  10 )                                        /*  90 作成親PG     */
 , USRSET       VARCHAR2 (  10 )                                        /* 100 作成社員     */
 , DYUPD        VARCHAR2 (  14 )                                        /* 110 更新日時     */
 , PGUPD        VARCHAR2 (  10 )                                        /* 120 更新PG       */
 , PGPUPD       VARCHAR2 (  10 )                                        /* 130 更新親PG     */
 , USRUPD       VARCHAR2 (  10 )                                        /* 140 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GE65S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE65T00 
  BEFORE INSERT ON GE65
  FOR EACH ROW 
  BEGIN 
    SELECT GE65S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
