/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.block.options;

import com.google.common.collect.Lists;
import java.util.List;
import org.openstack4j.model.common.functions.RangesToHeaderNameValue;
import org.openstack4j.model.common.header.HeaderNameValue;
import org.openstack4j.model.common.header.IfCondition;
import org.openstack4j.model.common.header.Range;

public class DownloadOptions {
    List<HeaderNameValue> headers = Lists.newArrayList();

    private DownloadOptions() {
    }

    public static DownloadOptions create() {
        return new DownloadOptions();
    }

    public DownloadOptions range(Range ... ranges) {
        HeaderNameValue h = RangesToHeaderNameValue.INSTANCE.apply(ranges);
        if (h != null) {
            this.headers.add(h);
        }
        return this;
    }

    public DownloadOptions header(String name, Object value) {
        if (name != null) {
            this.headers.add(new HeaderNameValue(name, value));
        }
        return this;
    }

    public DownloadOptions conditions(IfCondition ... condition) {
        if (condition != null) {
            for (IfCondition c : condition) {
                this.headers.add(c.toHeader());
            }
        }
        return this;
    }

    public List<HeaderNameValue> getHeaders() {
        return this.headers;
    }
}

