/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.common;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.DLPayload;

public class DLPayloadEntity
implements DLPayload {
    private final HttpResponse response;

    private DLPayloadEntity(HttpResponse response) {
        this.response = response;
    }

    public static DLPayloadEntity create(HttpResponse response) {
        return new DLPayloadEntity(response);
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public InputStream getInputStream() {
        return this.response.getInputStream();
    }

    @Override
    public void writeToFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        try (InputStream inputStream = this.response.getInputStream();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
    }
}

