/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.magnum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.magnum.Baymodel;
import org.openstack4j.model.magnum.BaymodelBuilder;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagnumBaymodel
implements Baymodel {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="insecure_registry")
    private String insecureRegistry;
    @JsonProperty(value="links")
    private List<GenericLink> links;
    @JsonProperty(value="http_proxy")
    private String httpProxy;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    @JsonProperty(value="floating_ip_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean floatingIpEnabled;
    @JsonProperty(value="fixed_subnet")
    private String fixedSubnet;
    @JsonProperty(value="master_flavor_id")
    private String masterFlavorId;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="no_proxy")
    private String noProxy;
    @JsonProperty(value="https_proxy")
    private String httpsProxy;
    @JsonProperty(value="tls_disabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean tlsDisabled;
    @JsonProperty(value="keypair_id")
    private String keypairId;
    @JsonProperty(value="public")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean publicBaymodel;
    @JsonProperty(value="docker_volume_size")
    private String dockerVolumeSize;
    @JsonProperty(value="server_type")
    private String serverType;
    @JsonProperty(value="external_network_id")
    private String externalNetworkId;
    @JsonProperty(value="cluster_distro")
    private String clusterDistro;
    @JsonProperty(value="image_id")
    private String imageId;
    @JsonProperty(value="volume_driver")
    private String volumeDriver;
    @JsonProperty(value="registry_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean registryEnabled;
    @JsonProperty(value="docker_storage_driver")
    private String dockerStorageDriver;
    @JsonProperty(value="apiserver_port")
    private String apiserverPort;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="network_driver")
    private String networkDriver;
    @JsonProperty(value="fixed_network")
    private String fixedNetwork;
    @JsonProperty(value="coe")
    private String coe;
    @JsonProperty(value="flavor_id")
    private String flavorId;
    @JsonProperty(value="master_lb_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean masterLbEnabled;
    @JsonProperty(value="dns_nameserver")
    private String dnsNameserver;

    public static BaymodelBuilder builder() {
        return new BaymodelConcreteBuilder();
    }

    @Override
    public BaymodelBuilder toBuilder() {
        return new BaymodelConcreteBuilder(this);
    }

    @Override
    public String getInsecureRegistry() {
        return this.insecureRegistry;
    }

    @Override
    public List<GenericLink> getLinks() {
        return this.links;
    }

    @Override
    public String getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public Boolean isFloatingIpEnabled() {
        return this.floatingIpEnabled;
    }

    @Override
    public String getFixedSubnet() {
        return this.fixedSubnet;
    }

    @Override
    public String getMasterFlavorId() {
        return this.masterFlavorId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getNoProxy() {
        return this.noProxy;
    }

    @Override
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    @Override
    public Boolean isTlsDisabled() {
        return this.tlsDisabled;
    }

    @Override
    public String getKeypairId() {
        return this.keypairId;
    }

    @Override
    public Boolean isPublicBaymodel() {
        return this.publicBaymodel;
    }

    @Override
    public String getDockerVolumeSize() {
        return this.dockerVolumeSize;
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    @Override
    public String getExternalNetworkId() {
        return this.externalNetworkId;
    }

    @Override
    public String getClusterDistro() {
        return this.clusterDistro;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String getVolumeDriver() {
        return this.volumeDriver;
    }

    @Override
    public Boolean isRegistryEnabled() {
        return this.registryEnabled;
    }

    @Override
    public String getDockerStorageDriver() {
        return this.dockerStorageDriver;
    }

    @Override
    public String getApiserverPort() {
        return this.apiserverPort;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getNetworkDriver() {
        return this.networkDriver;
    }

    @Override
    public String getFixedNetwork() {
        return this.fixedNetwork;
    }

    @Override
    public String getCoe() {
        return this.coe;
    }

    @Override
    public String getFlavorId() {
        return this.flavorId;
    }

    @Override
    public Boolean isMasterLbEnabled() {
        return this.masterLbEnabled;
    }

    @Override
    public String getDnsNameserver() {
        return this.dnsNameserver;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("insecureRegistry", (Object)this.insecureRegistry).add("links", this.links).add("httpProxy", (Object)this.httpProxy).add("updatedAt", (Object)this.updatedAt).add("floatingIpEnabled", (Object)this.floatingIpEnabled).add("fixedSubnet", (Object)this.fixedSubnet).add("masterFlavorId", (Object)this.masterFlavorId).add("uuid", (Object)this.uuid).add("noProxy", (Object)this.noProxy).add("httpsProxy", (Object)this.httpsProxy).add("tlsDisabled", (Object)this.tlsDisabled).add("keypairId", (Object)this.keypairId).add("publicBaymodel", (Object)this.publicBaymodel).add("dockerVolumeSize", (Object)this.dockerVolumeSize).add("serverType", (Object)this.serverType).add("externalNetworkId", (Object)this.externalNetworkId).add("clusterDistro", (Object)this.clusterDistro).add("imageId", (Object)this.imageId).add("volumeDriver", (Object)this.volumeDriver).add("registryEnabled", (Object)this.registryEnabled).add("dockerStorageDriver", (Object)this.dockerStorageDriver).add("apiserverPort", (Object)this.apiserverPort).add("name", (Object)this.name).add("createdAt", (Object)this.createdAt).add("networkDriver", (Object)this.networkDriver).add("fixedNetwork", (Object)this.fixedNetwork).add("coe", (Object)this.coe).add("flavorId", (Object)this.flavorId).add("masterLbEnabled", (Object)this.masterLbEnabled).add("dnsNameserver", (Object)this.dnsNameserver).toString();
    }

    public static class Baymodels
    extends ListResult<MagnumBaymodel> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="baymodels")
        private List<MagnumBaymodel> list;

        @Override
        public List<MagnumBaymodel> value() {
            return this.list;
        }
    }

    public static class BaymodelConcreteBuilder
    implements BaymodelBuilder {
        MagnumBaymodel model;

        public BaymodelConcreteBuilder() {
            this(new MagnumBaymodel());
        }

        public BaymodelConcreteBuilder(MagnumBaymodel model) {
            this.model = model;
        }

        @Override
        public Baymodel build() {
            return this.model;
        }

        @Override
        public BaymodelBuilder from(Baymodel in) {
            if (in != null) {
                this.model = (MagnumBaymodel)in;
            }
            return this;
        }

        @Override
        public BaymodelBuilder insecureRegistry(String insecureRegistry) {
            this.model.insecureRegistry = insecureRegistry;
            return this;
        }

        @Override
        public BaymodelBuilder links(List<GenericLink> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public BaymodelBuilder httpProxy(String httpProxy) {
            this.model.httpProxy = httpProxy;
            return this;
        }

        @Override
        public BaymodelBuilder updatedAt(String updatedAt) {
            this.model.updatedAt = updatedAt;
            return this;
        }

        @Override
        public BaymodelBuilder isFloatingIpEnabled(Boolean floatingIpEnabled) {
            this.model.floatingIpEnabled = floatingIpEnabled;
            return this;
        }

        @Override
        public BaymodelBuilder fixedSubnet(String fixedSubnet) {
            this.model.fixedSubnet = fixedSubnet;
            return this;
        }

        @Override
        public BaymodelBuilder masterFlavorId(String masterFlavorId) {
            this.model.masterFlavorId = masterFlavorId;
            return this;
        }

        @Override
        public BaymodelBuilder uuid(String uuid) {
            this.model.uuid = uuid;
            return this;
        }

        @Override
        public BaymodelBuilder noProxy(String noProxy) {
            this.model.noProxy = noProxy;
            return this;
        }

        @Override
        public BaymodelBuilder httpsProxy(String httpsProxy) {
            this.model.httpsProxy = httpsProxy;
            return this;
        }

        @Override
        public BaymodelBuilder tlsDisabled(Boolean tlsDisabled) {
            this.model.tlsDisabled = tlsDisabled;
            return this;
        }

        @Override
        public BaymodelBuilder keypairId(String keypairId) {
            this.model.keypairId = keypairId;
            return this;
        }

        @Override
        public BaymodelBuilder publicBaymodel(Boolean publicBaymodel) {
            this.model.publicBaymodel = publicBaymodel;
            return this;
        }

        @Override
        public BaymodelBuilder dockerVolumeSize(String dockerVolumeSize) {
            this.model.dockerVolumeSize = dockerVolumeSize;
            return this;
        }

        @Override
        public BaymodelBuilder serverType(String serverType) {
            this.model.serverType = serverType;
            return this;
        }

        @Override
        public BaymodelBuilder externalNetworkId(String externalNetworkId) {
            this.model.externalNetworkId = externalNetworkId;
            return this;
        }

        @Override
        public BaymodelBuilder clusterDistro(String clusterDistro) {
            this.model.clusterDistro = clusterDistro;
            return this;
        }

        @Override
        public BaymodelBuilder imageId(String imageId) {
            this.model.imageId = imageId;
            return this;
        }

        @Override
        public BaymodelBuilder volumeDriver(String volumeDriver) {
            this.model.volumeDriver = volumeDriver;
            return this;
        }

        @Override
        public BaymodelBuilder registryEnabled(Boolean registryEnabled) {
            this.model.registryEnabled = registryEnabled;
            return this;
        }

        @Override
        public BaymodelBuilder dockerStorageDriver(String dockerStorageDriver) {
            this.model.dockerStorageDriver = dockerStorageDriver;
            return this;
        }

        @Override
        public BaymodelBuilder apiserverPort(String apiserverPort) {
            this.model.apiserverPort = apiserverPort;
            return this;
        }

        @Override
        public BaymodelBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public BaymodelBuilder createdAt(String createdAt) {
            this.model.createdAt = createdAt;
            return this;
        }

        @Override
        public BaymodelBuilder networkDriver(String networkDriver) {
            this.model.networkDriver = networkDriver;
            return this;
        }

        @Override
        public BaymodelBuilder fixedNetwork(String fixedNetwork) {
            this.model.fixedNetwork = fixedNetwork;
            return this;
        }

        @Override
        public BaymodelBuilder coe(String coe) {
            this.model.coe = coe;
            return this;
        }

        @Override
        public BaymodelBuilder flavorId(String flavorId) {
            this.model.flavorId = flavorId;
            return this;
        }

        @Override
        public BaymodelBuilder masterLbEnabled(Boolean masterLbEnabled) {
            this.model.masterLbEnabled = masterLbEnabled;
            return this;
        }

        @Override
        public BaymodelBuilder dnsNameserver(String dnsNameserver) {
            this.model.dnsNameserver = dnsNameserver;
            return this;
        }
    }
}

