/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.collect.Maps;
import java.util.Map;
import org.openstack4j.model.manila.Share;
import org.openstack4j.model.manila.ShareManage;
import org.openstack4j.model.manila.builder.ShareManageBuilder;

@JsonRootName(value="share")
public class ManilaShareManage
implements ShareManage {
    private Share.Protocol protocol;
    private String name;
    @JsonProperty(value="share_type")
    private String shareType;
    @JsonProperty(value="driver_options")
    private Map<String, String> driverOptions;
    @JsonProperty(value="export_path")
    private String exportPath;
    @JsonProperty(value="service_host")
    private String serviceHost;
    private String description;

    @Override
    public Share.Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShareType() {
        return this.shareType;
    }

    @Override
    public Map<String, String> getDriverOptions() {
        return this.driverOptions;
    }

    @Override
    public String getExportPath() {
        return this.exportPath;
    }

    @Override
    public String getServiceHost() {
        return this.serviceHost;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static ShareManageBuilder builder() {
        return new ShareManageConcreteBuilder();
    }

    @Override
    public ShareManageBuilder toBuilder() {
        return new ShareManageConcreteBuilder(this);
    }

    public static class ShareManageConcreteBuilder
    implements ShareManageBuilder {
        ManilaShareManage shareManage;

        public ShareManageConcreteBuilder() {
            this(new ManilaShareManage());
        }

        public ShareManageConcreteBuilder(ManilaShareManage shareManage) {
            this.shareManage = shareManage;
        }

        @Override
        public ShareManageBuilder protocol(Share.Protocol protocol) {
            this.shareManage.protocol = protocol;
            return this;
        }

        @Override
        public ShareManageBuilder name(String name) {
            this.shareManage.name = name;
            return this;
        }

        @Override
        public ShareManageBuilder shareType(String shareType) {
            this.shareManage.shareType = shareType;
            return this;
        }

        @Override
        public ShareManageBuilder addDriverOption(String key, String value) {
            if (this.shareManage.driverOptions == null) {
                this.shareManage.driverOptions = Maps.newHashMap();
            }
            this.shareManage.driverOptions.put(key, value);
            return this;
        }

        @Override
        public ShareManageBuilder driverOptions(Map<String, String> driverOptions) {
            this.shareManage.driverOptions = driverOptions;
            return this;
        }

        @Override
        public ShareManageBuilder exportPath(String exportPath) {
            this.shareManage.exportPath = exportPath;
            return this;
        }

        @Override
        public ShareManageBuilder serviceHost(String serviceHost) {
            this.shareManage.serviceHost = serviceHost;
            return this;
        }

        @Override
        public ShareManageBuilder description(String description) {
            this.shareManage.description = description;
            return this;
        }

        @Override
        public ShareManage build() {
            return this.shareManage;
        }

        @Override
        public ShareManageBuilder from(ShareManage in) {
            this.shareManage = (ManilaShareManage)in;
            return this;
        }
    }
}

