/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

public class Renderer_RICHLABEL
extends AbstractRenderer {
    private static final String VERSION = "5.9.33.0 (2018/06/01)";
    private static final CellRenderer dbCell = new Renderer_RICHLABEL();
    private static final String ignoreStr = "strong|font|a|br|p|span|div|pre|img|table|thead|tbody|tr|th|td|ul|li|h\\d";
    private final int cutSize;

    public Renderer_RICHLABEL() {
        this.cutSize = 0;
    }

    public Renderer_RICHLABEL(DBColumn dBColumn) {
        int n;
        String string = dBColumn.getRendererParam();
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        this.cutSize = n;
    }

    public CellRenderer newInstance(DBColumn dBColumn) {
        String string = dBColumn.getRendererParam();
        if (string != null && string.length() > 0) {
            return new Renderer_RICHLABEL(dBColumn);
        }
        return dbCell;
    }

    public String getValue(String string) {
        int n;
        String string2 = StringUtil.escapeFilter((String)string, (String)ignoreStr);
        if (this.cutSize <= 0) {
            return string2;
        }
        String string3 = StringUtil.tagCut((String)string2.replaceAll("(?i)<br[ /]*>", System.lineSeparator()));
        int n2 = string3.length();
        if (n2 * 2 <= this.cutSize) {
            return string3;
        }
        int n3 = 0;
        for (n = 0; n < n2 && n3 < this.cutSize; ++n) {
            char c = string3.charAt(n);
            if (c <= '\u007f' || c >= '\uff61' && c <= '\uff9f') {
                ++n3;
                continue;
            }
            n3 += 2;
        }
        if (n == n2 && n3 <= this.cutSize) {
            return string3;
        }
        if (n3 > this.cutSize) {
            --n;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("<span title=\"");
        stringBuilder.append(string3);
        stringBuilder.append("\">");
        stringBuilder.append(string3.substring(0, n));
        stringBuilder.append("...</span>");
        return stringBuilder.toString();
    }
}

