/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.daemon;

import java.io.IOException;
import java.util.Date;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.URLConnect;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;

public class Daemon_URLConnect
extends HybsTimerTask {
    private static final String VERSION = "4.3.4.4 (2009/01/01)";
    private static final String DEFAULT_USER = "SYSTEM:MANAGER";
    private static final int LOOP_COUNTER = 24;
    private static final String[] POST_LIST = new String[]{"POST", "PUT", "DELETE"};
    private int loopCnt = 0;
    private boolean debug = false;
    private boolean useSystemUser = true;
    private String method = "GET";
    private String urlStr = null;
    private int proxyPort = -1;
    private URLConnect conn = null;

    public void initDaemon() {
        this.debug = StringUtil.nval((String)this.getValue("DEBUG"), (boolean)this.debug);
        this.useSystemUser = StringUtil.nval((String)this.getValue("useSystemUser"), (boolean)this.useSystemUser);
        this.method = StringUtil.nval((String)this.getValue("method"), (String)this.method);
        this.urlStr = this.getValue("url");
        this.proxyPort = StringUtil.nval((String)this.getValue("proxyPort"), (int)this.proxyPort);
        String string = this.getValue("proxyHost");
        String string2 = this.getValue("keys");
        String string3 = this.getValue("vals");
        String string4 = this.getValue("authUserPass");
        if (this.useSystemUser) {
            string4 = DEFAULT_USER;
        }
        String string5 = XHTMLTag.urlEncode((String)string2, (String)string3);
        if (!"POST".equals(this.method)) {
            this.urlStr = XHTMLTag.addUrlEncode((String)this.urlStr, (String)string5);
        }
        this.conn = new URLConnect(this.urlStr, string4);
        if (string != null) {
            this.conn.setProxy(string, this.proxyPort);
        }
        if (this.check(this.method, POST_LIST) && string2 != null && string3 != null) {
            this.conn.setPostData(string5);
            this.conn.setMethodOverride(this.method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDaemon() {
        if (this.loopCnt % 24 == 0) {
            this.loopCnt = 1;
            System.out.println(this.toString() + " " + new Date() + " ");
        } else {
            ++this.loopCnt;
        }
        try {
            this.conn.connect();
            if (this.debug) {
                String string = "Daemon_URLConnect:url=[" + this.urlStr + "]" + HybsSystem.CR + this.conn.readData();
                LogWriter.log((String)string);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            String string = "Daemon_URLConnect:\u30c7\u30fc\u30bf\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " url=[" + this.urlStr + "]" + HybsSystem.CR + iOException;
            LogWriter.log((String)string);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
    }

    private boolean check(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

