/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.BasicAWSCredentials;
import com.ibm.cloud.objectstorage.auth.BasicSessionCredentials;
import com.ibm.cloud.objectstorage.oauth.BasicIBMOAuthCredentials;
import com.ibm.cloud.objectstorage.util.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements AWSCredentialsProvider {
    BasicIBMOAuthCredentials oAuthCredentials;

    @Override
    public AWSCredentials getCredentials() {
        String secretKey;
        if (System.getenv("IBM_API_KEY_ID") != null) {
            String apiKey = System.getenv("IBM_API_KEY_ID");
            String serviceInstanceId = System.getenv("IBM_SERVICE_INSTANCE_ID");
            if (this.oAuthCredentials == null) {
                this.oAuthCredentials = new BasicIBMOAuthCredentials(apiKey, serviceInstanceId);
            }
            return this.oAuthCredentials;
        }
        String accessKey = System.getenv("AWS_ACCESS_KEY_ID");
        if (accessKey == null) {
            accessKey = System.getenv("AWS_ACCESS_KEY");
        }
        if ((secretKey = System.getenv("AWS_SECRET_KEY")) == null) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        }
        accessKey = StringUtils.trim(accessKey);
        secretKey = StringUtils.trim(secretKey);
        String sessionToken = StringUtils.trim(System.getenv("AWS_SESSION_TOKEN"));
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new SdkClientException("Unable to load AWS credentials from environment variables (AWS_ACCESS_KEY_ID (or AWS_ACCESS_KEY) and AWS_SECRET_KEY (or AWS_SECRET_ACCESS_KEY))");
        }
        return sessionToken == null ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

