/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth.json;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.JsonCredentials;
import com.ibm.cloud.objectstorage.auth.json.BasicJsonConfigLoader;
import com.ibm.cloud.objectstorage.auth.json.internal.JsonStaticCredentialsProvider;
import com.ibm.cloud.objectstorage.profile.path.AwsProfileFileLocationProvider;
import com.ibm.cloud.objectstorage.util.ValidationUtils;
import java.io.File;

public class JsonConfigFile {
    private final File credentialFile;
    private AWSCredentialsProvider credentialProvider;
    private volatile long credentialFileLastModified;
    private volatile JsonCredentials credentials;

    public JsonConfigFile() throws SdkClientException {
        this(JsonConfigFile.getCredentialsJsonFile());
    }

    public JsonConfigFile(String filePath) {
        this(new File(JsonConfigFile.validateFilePath(filePath)));
    }

    private static String validateFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Unable to load IBM credentials: specified file path is null.");
        }
        return filePath;
    }

    public JsonConfigFile(File file) throws SdkClientException {
        this.credentialFile = ValidationUtils.assertNotNull(file, "IBM credential file");
        this.credentialFileLastModified = this.credentialFile.lastModified();
        this.credentials = JsonConfigFile.loadCredentials(file);
    }

    public AWSCredentials getCredentials() {
        if (this.credentialProvider != null) {
            return this.credentialProvider.getCredentials();
        }
        this.credentialProvider = new JsonStaticCredentialsProvider(this.credentials);
        return this.credentialProvider.getCredentials();
    }

    public void refresh() {
        if (this.credentialFile.lastModified() > this.credentialFileLastModified) {
            this.credentialFileLastModified = this.credentialFile.lastModified();
            this.credentials = JsonConfigFile.loadCredentials(this.credentialFile);
        }
        this.credentialProvider = new JsonStaticCredentialsProvider(this.credentials);
    }

    private static File getCredentialsJsonFile() {
        return AwsProfileFileLocationProvider.IBM_CREDENTIALS_LOCATION_PROVIDER.getLocation();
    }

    private static JsonCredentials loadCredentials(File file) {
        return BasicJsonConfigLoader.INSTANCE.loadCredentials(file);
    }
}

