/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain.ext;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.compute.ext.AvailabilityZone;
import org.openstack4j.openstack.common.ListResult;

public class ExtAvailabilityZone
implements AvailabilityZone {
    private static final long serialVersionUID = 1L;
    ExtZoneState zoneState;
    String zoneName;
    Map<String, Map<String, ExtNovaService>> hosts;

    @Override
    public AvailabilityZone.ZoneState getZoneState() {
        return this.zoneState;
    }

    @Override
    public String getZoneName() {
        return this.zoneName;
    }

    @Override
    public Map<String, Map<String, ? extends AvailabilityZone.NovaService>> getHosts() {
        HashMap<String, Map<String, ? extends AvailabilityZone.NovaService>> map = new HashMap<String, Map<String, ? extends AvailabilityZone.NovaService>>();
        if (this.hosts != null) {
            for (Map.Entry<String, Map<String, ExtNovaService>> entry : this.hosts.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("zoneState", (Object)this.zoneState).add("zoneName", (Object)this.zoneName).add("hosts", this.hosts).toString();
    }

    public static class AvailabilityZones
    extends ListResult<ExtAvailabilityZone> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="availabilityZoneInfo")
        private List<ExtAvailabilityZone> result;

        @Override
        protected List<ExtAvailabilityZone> value() {
            return this.result;
        }
    }

    static class ExtNovaService
    implements AvailabilityZone.NovaService {
        private static final long serialVersionUID = 1L;
        boolean available;
        @JsonProperty(value="active")
        String statusActive;
        @JsonProperty(value="updated_at")
        Date updateTime;

        ExtNovaService() {
        }

        @Override
        public boolean getAvailable() {
            return this.available;
        }

        @Override
        public String getStatusActive() {
            return this.statusActive;
        }

        @Override
        public Date getUpdateTime() {
            return this.updateTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("available", this.available).add("active", (Object)this.statusActive).add("updateTime", (Object)this.updateTime).toString();
        }
    }

    @JsonRootName(value="zoneState")
    static class ExtZoneState
    implements AvailabilityZone.ZoneState {
        private static final long serialVersionUID = 1L;
        boolean available;

        ExtZoneState() {
        }

        @Override
        public boolean getAvailable() {
            return this.available;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("available", this.available).toString();
        }
    }
}

