/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;

public class HttpConnect {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_LANG = "ja-JP";
    public static final String DEFAULT_AGENT = "openGion with Apache HttpClient";
    public static final int MAX_GET_LENGTH = 2000;
    private final String urlStr;
    private final String user;
    private final String pass;
    private int rpsCode = -1;
    private String rpsMessage;
    private String charset = "UTF-8";
    private String upldFile;
    private String dwldFile;
    private int timeout = -1;
    private boolean isPost;
    private boolean postRedirect;
    private boolean isDebug;
    private HttpHost proxy;
    private static final List<Header> INIT_HEADER = Arrays.asList(new BasicHeader("Accept-Charset", "UTF-8"), new BasicHeader("Accept-Language", "ja-JP"), new BasicHeader("User-Agent", "openGion with Apache HttpClient"));
    private final List<NameValuePair> reqParamList = new ArrayList<NameValuePair>();
    private final List<Header> headers = new ArrayList<Header>(INIT_HEADER);
    private final StringBuilder reqParamBuf = new StringBuilder(200);

    public HttpConnect(String string, String string2) {
        this.urlStr = StringUtil.urlEncode2(string);
        if (StringUtil.isNull(string2)) {
            this.user = null;
            this.pass = null;
        } else {
            String[] stringArray = StringUtil.csv2Array(string2, ':', 2);
            this.user = stringArray[0];
            this.pass = stringArray[1];
        }
    }

    public String readData() throws IOException, MalformedURLException {
        CloseableHttpClient closeableHttpClient;
        Object object;
        HttpPost httpPost;
        if (this.isPost) {
            if (this.isDebug) {
                System.out.println("POST URL=" + this.urlStr);
            }
            httpPost = new HttpPost(this.urlStr);
            if (!this.reqParamList.isEmpty()) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.reqParamList, DEFAULT_CHARSET));
                if (this.isDebug) {
                    this.reqParamList.forEach(nameValuePair -> System.out.println("PARAM KEY=" + nameValuePair.getName() + " , VAL=" + nameValuePair.getValue()));
                }
            }
            if (!StringUtil.isNull(this.upldFile)) {
                object = new File(this.upldFile);
                if (this.isDebug) {
                    System.out.println("  MULTI FILE=" + (File)object);
                }
                closeableHttpClient = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(StandardCharsets.UTF_8).addBinaryBody("upload", (File)object, ContentType.DEFAULT_BINARY, ((File)object).getName()).build();
                httpPost.setEntity((HttpEntity)closeableHttpClient);
            }
        } else {
            Object object2 = object = this.reqParamBuf.length() == 0 ? this.urlStr : this.reqParamBuf.toString();
            if (this.isDebug) {
                System.out.println("GET URL=" + (String)object);
            }
            httpPost = new HttpGet((String)object);
        }
        object = null;
        closeableHttpClient = this.getClient();
        try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            this.rpsCode = statusLine.getStatusCode();
            this.rpsMessage = (HttpConnect.code2Message(this.rpsCode) + HybsConst.CR + statusLine.getReasonPhrase()).trim();
            if (!StringUtil.isNull(this.dwldFile) && this.rpsCode >= 200 && this.rpsCode < 300) {
                Files.write(Paths.get(this.dwldFile, new String[0]), EntityUtils.toByteArray((HttpEntity)httpEntity), new OpenOption[0]);
                object = this.dwldFile;
            } else {
                object = httpEntity == null ? this.rpsMessage : EntityUtils.toString((HttpEntity)httpEntity, (String)this.charset);
            }
        }
        finally {
            if (closeableHttpClient != null) {
                closeableHttpClient.close();
            }
        }
        return object;
    }

    private CloseableHttpClient getClient() throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder builder = RequestConfig.custom().setCookieSpec("standard");
        if (this.timeout >= 0) {
            builder.setConnectTimeout(this.timeout * 1000).setSocketTimeout(this.timeout * 1000);
        }
        httpClientBuilder.setDefaultRequestConfig(builder.build());
        if (this.postRedirect) {
            httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        if (!this.headers.isEmpty()) {
            httpClientBuilder.setDefaultHeaders(this.headers);
        }
        if (!StringUtil.isNull(this.user)) {
            URL uRL = new URL(this.urlStr);
            AuthScope authScope = new AuthScope(uRL.getHost(), uRL.getPort());
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.user, this.pass);
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        if (this.proxy != null) {
            httpClientBuilder.setProxy(this.proxy);
        }
        return httpClientBuilder.build();
    }

    public void addRequestProperty(String string, String string2) {
        if (!StringUtil.isNull(string)) {
            this.reqParamList.add((NameValuePair)new BasicNameValuePair(string, string2));
            if (!this.isPost) {
                if (this.reqParamBuf.length() == 0) {
                    this.reqParamBuf.append(this.urlStr).append(this.urlStr.indexOf(63) > 0 ? (char)'&' : '?').append(StringUtil.urlEncode2(string)).append('=').append(StringUtil.urlEncode2(string2));
                } else if (this.reqParamBuf.length() > 2000) {
                    System.out.println("GET \u2192 POST\u5909\u66f4\uff1a URL\u306e\u9577\u3055\u5236\u9650\uff1c" + this.reqParamBuf.length());
                    this.isPost = true;
                } else {
                    this.reqParamBuf.append('&').append(StringUtil.urlEncode2(string)).append('=').append(StringUtil.urlEncode2(string2));
                }
            }
        }
    }

    public void setRequestProperty(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = StringUtil.csv2Array(string);
            if (stringArray2.length == (stringArray = StringUtil.csv2Array(string2)).length && stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.addRequestProperty(stringArray2[i], stringArray[i]);
                }
            } else {
                String string3 = "\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30ad\u30fc\u3068\u3001\u5024\u306e\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002" + HybsConst.CR + " key=[" + string + "]" + HybsConst.CR + " val=[" + string2 + "]";
                throw new IllegalArgumentException(string3);
            }
        }
    }

    public void setProxy(String string, int n) {
        if (!StringUtil.isNull(string)) {
            this.proxy = new HttpHost(string, n);
        }
    }

    public void addHeaderProperty(String string, String string2) {
        if (!StringUtil.isNull(string) && !StringUtil.isNull(string2)) {
            this.headers.add((Header)new BasicHeader(string, string2));
        }
    }

    public void setDownloadFile(String string) throws IOException {
        this.dwldFile = string;
    }

    public void setUploadFile(String string) throws IOException {
        if (string != null) {
            this.upldFile = string;
            this.isPost = true;
        }
    }

    public void setCharset(String string) {
        if (!StringUtil.isNull(string)) {
            this.charset = string;
        }
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void usePost(boolean bl) {
        this.isPost = bl;
    }

    public void setPostRedirect(boolean bl) {
        this.postRedirect = bl;
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    public int getCode() {
        return this.rpsCode;
    }

    public String getMessage() {
        return this.rpsMessage;
    }

    public static String code2Message(int n) {
        Object object;
        switch (n) {
            case 100: {
                object = "100: \u8981\u6c42\u306f\u7d9a\u884c\u53ef\u80fd\u3067\u3059\u3002";
                break;
            }
            case 101: {
                object = "101: \u30d7\u30ed\u30c8\u30b3\u30eb\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
                break;
            }
            case 200: {
                object = "200: OK \u3067\u3059\u3002";
                break;
            }
            case 201: {
                object = "201: \u4f5c\u6210\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 202: {
                object = "202: \u53d7\u3051\u5165\u308c\u3089\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 203: {
                object = "203: \u4fe1\u983c\u3067\u304d\u306a\u3044\u60c5\u5831\u3067\u3059\u3002";
                break;
            }
            case 204: {
                object = "204: \u30b3\u30f3\u30c6\u30f3\u30c4\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
                break;
            }
            case 205: {
                object = "205: \u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u3002";
                break;
            }
            case 206: {
                object = "206: \u90e8\u5206\u7684\u306a\u30b3\u30f3\u30c6\u30f3\u30c4\u3067\u3059\u3002";
                break;
            }
            case 300: {
                object = "300: \u8907\u6570\u306e\u9078\u629e\u80a2\u304c\u3042\u308a\u307e\u3059\u3002";
                break;
            }
            case 301: {
                object = "301: \u6c38\u7d9a\u7684\u306b\u79fb\u52d5\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 302: {
                object = "302: \u4e00\u6642\u7684\u306a\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u3002";
                break;
            }
            case 303: {
                object = "303: \u307b\u304b\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                break;
            }
            case 304: {
                object = "304: \u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                break;
            }
            case 305: {
                object = "305: \u30d7\u30ed\u30ad\u30b7\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002";
                break;
            }
            case 306: {
                object = "306: \u4ed5\u69d8\u306e\u62e1\u5f35\u6848\u3067\u3059\u3002";
                break;
            }
            case 307: {
                object = "307: \u4e00\u6642\u7684\u306a\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u3067\u3059\u3002";
                break;
            }
            case 400: {
                object = "400: \u4e0d\u5f53\u306a\u8981\u6c42\u3067\u3059\u3002";
                break;
            }
            case 401: {
                object = "401: \u8a8d\u8a3c\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                break;
            }
            case 402: {
                object = "402: \u652f\u6255\u3044\u304c\u5fc5\u8981\u3067\u3059\u3002";
                break;
            }
            case 403: {
                object = "403: \u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
                break;
            }
            case 404: {
                object = "404: \u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                break;
            }
            case 405: {
                object = "405: \u30e1\u30bd\u30c3\u30c9\u306f\u8a31\u53ef\u3055\u308c\u307e\u305b\u3093\u3002";
                break;
            }
            case 406: {
                object = "406: \u53d7\u3051\u5165\u308c\u3089\u308c\u307e\u305b\u3093\u3002";
                break;
            }
            case 407: {
                object = "407: \u30d7\u30ed\u30ad\u30b7\u306e\u8a8d\u8a3c\u304c\u5fc5\u8981\u3067\u3059\u3002";
                break;
            }
            case 408: {
                object = "408: \u8981\u6c42\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002";
                break;
            }
            case 409: {
                object = "409: \u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002";
                break;
            }
            case 410: {
                object = "410: \u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
                break;
            }
            case 411: {
                object = "411: \u9577\u3055\u304c\u5fc5\u8981\u3067\u3059\u3002";
                break;
            }
            case 412: {
                object = "412: \u524d\u63d0\u6761\u4ef6\u304c\u6e80\u305f\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                break;
            }
            case 413: {
                object = "413: \u8981\u6c42\u306e\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002";
                break;
            }
            case 414: {
                object = "414: \u8981\u6c42\u306eURI\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002";
                break;
            }
            case 415: {
                object = "415: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u30e1\u30c7\u30a3\u30a2\u30bf\u30a4\u30d7\u3067\u3059\u3002";
                break;
            }
            case 416: {
                object = "416: \u8981\u6c42\u3055\u308c\u305f\u7bc4\u56f2\u306f\u4e0d\u5341\u5206\u3067\u3059\u3002";
                break;
            }
            case 417: {
                object = "417: \u8981\u6c42\u3069\u304a\u308a\u306e\u51e6\u7406\u304c\u4e0d\u53ef\u80fd\u3067\u3059\u3002";
                break;
            }
            case 500: {
                object = "500: \u5185\u90e8\u30b5\u30fc\u30d0\u30a8\u30e9\u30fc\u3067\u3059\u3002";
                break;
            }
            case 501: {
                object = "501: \u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                break;
            }
            case 502: {
                object = "502: \u8aa4\u3063\u305f\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u3067\u3059\u3002";
                break;
            }
            case 503: {
                object = "503: \u30b5\u30fc\u30d3\u30b9\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
                break;
            }
            case 504: {
                object = "504: \u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002";
                break;
            }
            case 505: {
                object = "505: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044HTTP\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u3059\u3002";
                break;
            }
            default: {
                object = n + ": \u672a\u5b9a\u7fa9";
            }
        }
        return object;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        if (stringArray.length < 2) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.HttpConnect [-data/-binary] \u2026 url");
            LogWriter.log("   args[A] : url                     \uff35\uff32\uff2c\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002GET\u306e\u5834\u5408\u3001\u30d1\u30e9\u30e1\u30fc\u30bf\u306f ?KEY=VAL\u3067\u3059");
            LogWriter.log("   args[*] : [-param=key:value]      POST/GET\u6642\u306e\uff8a\uff9f\uff97\uff92\uff70\uff80\u306e\uff77\uff70\u3068\u5024\u3092:\u3067\u533a\u5207\u3063\u3066\u6307\u5b9a\u3057\u307e\u3059\u3002(\u8907\u6570\u56de\u6307\u5b9a\u53ef)");
            LogWriter.log("   args[*] : [-header=key:value]     \uff8d\uff6f\uff80\uff9e\uff70\u306b\u8a2d\u5b9a\u3059\u308b\uff8a\uff9f\uff97\uff92\uff70\uff80\u306e\uff77\uff70\u3068\u5024\u3092:\u3067\u533a\u5207\u3063\u3066\u6307\u5b9a\u3057\u307e\u3059\u3002(\u8907\u6570\u56de\u6307\u5b9a\u53ef)");
            LogWriter.log("   args[*] : [-auth=user:pass]       BASIC\u8a8d\u8a3c\u306e\u30a8\u30ea\u30a2\u3078\u306e\u30a2\u30af\u30bb\u30b9\u6642\u306e\u30e6\u30fc\u30b6\u30fc\u3068\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059");
            LogWriter.log("   args[*] : [-proxy=host:port]      proxy \u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u306e\u30db\u30b9\u30c8\u3068\u30dd\u30fc\u30c8\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
            LogWriter.log("   args[*] : [-timeout=3]            \u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u6642\u9593\u3092(\u79d2)\u3067\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:\u7121\u6307\u5b9a)");
            LogWriter.log("   args[*] : [-encode=UTF-8]         \u30a8\u30f3\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\u306f UTF-8)");
            LogWriter.log("   args[*] : [-out=\u30d5\u30a1\u30a4\u30eb\u540d]       \u7d50\u679c\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002\u521d\u671f\u5024\u306f\u6a19\u6e96\u51fa\u529b\u3067\u3059");
            LogWriter.log("   args[*] : [-download=\u30d5\u30a1\u30a4\u30eb\u540d]  \uff8c\uff67\uff72\uff99\u540d\u3092\u6307\u5b9a\u3057\u3066\u3001\uff80\uff9e\uff73\uff9d\uff9b\uff70\uff84\uff9e\u3057\u307e\u3059");
            LogWriter.log("   args[*] : [-upload=\u30d5\u30a1\u30a4\u30eb\u540d]    \uff8c\uff67\uff72\uff99\u540d\u3092\u6307\u5b9a\u3057\u3066\u3001multipart/form-data\u3067\uff8c\uff67\uff72\uff99\uff71\uff6f\uff8c\uff9f\uff9b\uff70\uff84\uff9e\u3057\u307e\u3059");
            LogWriter.log("   args[*] : [-postRedirect=true]    POST\u6642\u306b\u5f37\u5236\u7684\u306b\uff98\uff80\uff9e\uff72\uff9a\uff78\uff84\u3092\u884c\u3044\u307e\u3059(GET\u6642\u306f\u81ea\u52d5\u3067\uff98\uff80\uff9e\uff72\uff9a\uff78\uff84\u3057\u307e\u3059)(\u521d\u671f\u5024:false)");
            LogWriter.log("   args[*] : [-errEx=true/false]     true\u306e\u5834\u5408\u3001\uff9a\uff7d\uff8e\uff9f\uff9d\uff7d\uff7a\uff70\uff84\uff9e\u304c\u30014XX,5XX \u306e\u6642\u306b RuntimeException \u3092\u6295\u3052\u307e\u3059(\u521d\u671f\u5024:false)");
            LogWriter.log("   args[*] : [#\uff65\uff65\uff65\uff65]                 \uff7a\uff92\uff9d\uff84\u5f15\u6570\u3002(BAT\uff8c\uff67\uff72\uff99\u4e0a\u306b\u6b8b\u3057\u3066\u304a\u304d\u305f\u3044\u304c\u3001\u4f7f\u7528\u3057\u305f\u304f\u306a\u3044\u5834\u5408\u306a\u3069)");
            LogWriter.log("   args[*] : [-debug=true/false]     true\u306e\u5834\u5408\u3001\u9069\u5ea6\u306b\u30c7\u30d0\u30c3\u30b0\u7528\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u51fa\u529b\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
            return;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = DEFAULT_CHARSET;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string8 : stringArray) {
            if (string8.startsWith("-param=")) {
                object = StringUtil.csv2Array(string8.substring("-param=".length()), '=', 2);
                arrayList.add(object[0]);
                arrayList2.add(object[1]);
                continue;
            }
            if (string8.startsWith("-header=")) {
                object = StringUtil.csv2Array(string8.substring("-header=".length()), '=', 2);
                arrayList3.add(object[0]);
                arrayList4.add(object[1]);
                continue;
            }
            if (string8.startsWith("-auth=")) {
                string2 = string8.substring("-auth=".length());
                if (!StringUtil.isNull(string2)) continue;
                System.err.println(string8 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string8.startsWith("-proxy=")) {
                string3 = string8.substring("-proxy=".length());
                if (!StringUtil.isNull(string3)) continue;
                System.err.println(string8 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string8.startsWith("-timeout=")) {
                n = Integer.parseInt(string8.substring("-timeout=".length()));
                continue;
            }
            if (string8.startsWith("-encode=")) {
                string4 = string8.substring("-encode=".length());
                if (!StringUtil.isNull(string4)) continue;
                System.err.println(string8 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string8.startsWith("-out=")) {
                string5 = string8.substring("-out=".length());
                if (StringUtil.isNull(string5)) {
                    System.err.println(string8 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    continue;
                }
                if (!"null".equalsIgnoreCase(string5) && !"none".equalsIgnoreCase(string5)) continue;
                string5 = null;
                bl4 = true;
                continue;
            }
            if (string8.startsWith("-download=")) {
                string6 = string8.substring("-download=".length());
                if (!StringUtil.isNull(string6)) continue;
                System.err.println(string8 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string8.startsWith("-upload=")) {
                string7 = string8.substring("-upload=".length());
                if (!StringUtil.isNull(string7)) continue;
                System.err.println(string8 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string8.startsWith("-errEx=")) {
                bl = "true".equalsIgnoreCase(string8.substring("-errEx=".length()));
                continue;
            }
            if (string8.startsWith("-postRedirect=")) {
                bl3 = "true".equalsIgnoreCase(string8.substring("-postRedirect=".length()));
                continue;
            }
            if (string8.startsWith("-debug=")) {
                bl2 = "true".equalsIgnoreCase(string8.substring("-debug=".length()));
                continue;
            }
            if (StringUtil.startsChar(string8, '-')) {
                System.err.println("Error Argment:" + string8);
                continue;
            }
            if (StringUtil.startsChar(string8, '#')) continue;
            string = string8;
        }
        try {
            int n2;
            HttpConnect httpConnect = new HttpConnect(string, string2);
            httpConnect.setDebug(bl2);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                httpConnect.addRequestProperty((String)arrayList.get(n2), (String)arrayList2.get(n2));
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                httpConnect.addHeaderProperty((String)arrayList3.get(n2), (String)arrayList4.get(n2));
            }
            if (!StringUtil.isNull(string3)) {
                String[] stringArray2 = StringUtil.csv2Array(string3, ':', 2);
                String string9 = stringArray2[0];
                int n3 = Integer.parseInt(stringArray2[1]);
                httpConnect.setProxy(string9, n3);
            }
            httpConnect.setCharset(string4);
            httpConnect.setTimeout(n);
            httpConnect.setUploadFile(string7);
            httpConnect.setDownloadFile(string6);
            httpConnect.setPostRedirect(bl3);
            String string10 = httpConnect.readData();
            try (PrintWriter printWriter = StringUtil.isNull(string5) ? FileUtil.getLogWriter("System.out") : FileUtil.getPrintWriter(new File(string5), string4);){
                int n4;
                if (!bl4) {
                    printWriter.println(string10);
                }
                if ((n4 = httpConnect.getCode()) >= 400) {
                    object = httpConnect.getMessage();
                    printWriter.println((String)object);
                    if (bl) {
                        throw new OgRuntimeException((String)object);
                    }
                    System.exit(n4);
                }
            }
        }
        catch (Throwable throwable) {
            throw new OgRuntimeException(throwable);
        }
    }
}

