/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.daemon;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.opengion.fukurou.business.BizUtil;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueReceive;
import org.opengion.fukurou.queue.QueueReceiveFactory;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.queue.DBAccessQueue;

public class Daemon_QueueReceive
extends HybsTimerTask {
    private int loopCnt;
    private QueueReceive queueReceive;
    private static final int LOOP_COUNTER = 24;
    private static final char FPSC = File.pathSeparatorChar;
    private final String CLOUD_SQS_ACCESS_KEY = HybsSystem.sys((String)"CLOUD_SQS_ACCESS_KEY");
    private final String CLOUD_SQS_SECRET_KEY = HybsSystem.sys((String)"CLOUD_SQS_SECRET_KEY");
    private final String MQ_QUEUE_TYPE;
    private final String MQ_QURUE_SERVER_URL = HybsSystem.sys((String)"MQ_QUEUE_SERVER_URL");
    private final String MQ_QUEUE_RECEIVE_LISTENER = HybsSystem.sys((String)"MQ_QUEUE_RECEIVE_LISTENER");
    private final String SYSTEM_ID = HybsSystem.sys((String)"SYSTEM_ID");
    private final String USER_ID = "CYYYYY";
    private final String PG_ID;
    private final String DMN_NAME = "QueueReceiveDMN";
    private final DBAccessQueue dbAccessQueue;
    private final String REAL_PATH = HybsSystem.sys((String)"REAL_PATH");

    public Daemon_QueueReceive() {
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{HybsSystem.sys((String)"MQ_QUEUE_TYPE")})) {
            throw new RuntimeException("\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u306bMQ_QUEUE_TYPE\u3092\u767b\u9332\u3057\u3066\u4e0b\u3055\u3044");
        }
        this.MQ_QUEUE_TYPE = HybsSystem.sys((String)"MQ_QUEUE_TYPE").toUpperCase(Locale.JAPAN);
        this.PG_ID = StringUtil.cut((String)("QueRec" + this.MQ_QUEUE_TYPE), (int)10);
        this.dbAccessQueue = new DBAccessQueue(this.SYSTEM_ID, "CYYYYY", this.PG_ID, "QueueReceiveDMN");
    }

    public void initDaemon() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.MQ_QUEUE_TYPE == null) {
            stringBuilder.append("MQ_QUEUE_TYPE");
        }
        if (this.MQ_QURUE_SERVER_URL == null) {
            stringBuilder.append(" MQ_QUEUE_SERVER_URL");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" \u30ad\u30e5\u30fc\u30bf\u30a4\u30d7\u3092\u7279\u5b9a\u3059\u308b\u305f\u3081\u306b\u3001\u5de6\u8a18\u306e\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u3092\u767b\u9332\u3057\u3066\u4e0b\u3055\u3044\u3002");
            throw new HybsSystemException(stringBuilder.toString());
        }
        String string = this.MQ_QUEUE_TYPE.toUpperCase(Locale.JAPAN);
        System.out.println("MQ\u30ad\u30e5\u30fc\u30bf\u30a4\u30d7\uff1a" + string);
        System.out.println("MQ\u30b5\u30fc\u30d0\u30fcURL\uff1a" + this.MQ_QURUE_SERVER_URL);
        this.queueReceive = QueueReceiveFactory.newQueueReceive((String)string);
        this.queueReceive.connect(this.MQ_QURUE_SERVER_URL, this.CLOUD_SQS_ACCESS_KEY, this.CLOUD_SQS_SECRET_KEY);
    }

    protected void startDaemon() {
        if (this.loopCnt % 24 == 0) {
            this.loopCnt = 1;
            System.out.println();
            System.out.print(this.toString() + " " + new Date() + " ");
        } else {
            String[][] stringArray = this.dbAccessQueue.setlectGE67();
            if (stringArray.length == 0) {
                throw new RuntimeException("GE67\u306b\u30ad\u30e5\u30fc\u60c5\u5831\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            switch (this.MQ_QUEUE_TYPE) {
                case "MQ": {
                    this.processMq(stringArray);
                    break;
                }
                case "SQS": {
                    this.processSqs(stringArray);
                    break;
                }
                default: {
                    String string = "\u30ea\u30bd\u30fc\u30b9(MQ_QUEUE_TYPE)\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002\uff1a" + this.MQ_QUEUE_TYPE;
                    throw new RuntimeException(string);
                }
            }
            ++this.loopCnt;
        }
    }

    private void processMq(String[][] stringArray) {
        boolean bl = false;
        if ("true".equals(this.MQ_QUEUE_RECEIVE_LISTENER)) {
            bl = true;
        }
        if (bl) {
            this.queueReceive.closeListener();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i][0];
            String string2 = stringArray[i][1];
            if (bl) {
                object = new QueueReceiveListener(string, string2);
                this.queueReceive.setListener(string, (MessageListener)object);
                continue;
            }
            object = this.queueReceive.receive(string);
            if (object == null) continue;
            this.processMessage(string, string2, object.getMessage());
            break;
        }
    }

    private void processSqs(String[][] stringArray) {
        QueueInfo queueInfo = this.queueReceive.receive(null);
        if (queueInfo == null) {
            return;
        }
        String string = queueInfo.getSqsFifoGroupId();
        Boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            if (string == null || !string.equals(string2)) continue;
            String string3 = stringArray[i][1];
            this.processMessage(string2, string3, queueInfo.getMessage());
            bl = true;
            break;
        }
        if (!bl.booleanValue()) {
            String string4 = this.dbAccessQueue.generateSyoriNo();
            this.dbAccessQueue.insertGE68(string, string4, null, queueInfo.getMessage());
            this.dbAccessQueue.updateGE68Error(string4, "SQS\u30ad\u30e5\u30fc\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u30b0\u30eb\u30fc\u30d7ID\u304c\u3001GE67\u306b\u672a\u767b\u9332\u3067\u3059\u3002");
        }
    }

    public boolean cancel() {
        if (this.queueReceive != null) {
            this.queueReceive.close();
        }
        return super.cancel();
    }

    private void processMessage(String string, String string2, String string3) {
        String string4 = "";
        try {
            string4 = this.dbAccessQueue.generateSyoriNo();
            this.dbAccessQueue.insertGE68(string, string4, string2, string3);
            this.callActBizLogic(this.SYSTEM_ID, string2, string3);
            this.dbAccessQueue.updateGE68(string4, "3");
        }
        catch (Throwable throwable) {
            String string5 = null;
            string5 = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
            System.out.println(string5);
            try {
                this.dbAccessQueue.updateGE68Error(string4, string5);
            }
            catch (Exception exception) {
                System.out.println("\u7ba1\u7406\u30c6\u30fc\u30d6\u30eb\u767b\u9332\u30a8\u30e9\u30fc\uff1a" + exception.getMessage());
            }
        }
    }

    private void callActBizLogic(String string, String string2, String string3) throws Throwable {
        String string4 = this.REAL_PATH + HybsSystem.sys((String)"BIZLOGIC_CLASS_PATH");
        String string5 = this.REAL_PATH + "WEB-INF" + File.separator;
        StringBuilder stringBuilder = new StringBuilder().append('.').append(FPSC);
        File file = new File(string5 + "lib");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File bl : fileArray) {
                stringBuilder.append(bl.getAbsolutePath()).append(FPSC);
            }
        }
        String string6 = stringBuilder.append(string5).append("classes").append(FPSC).append(string4).append(FPSC).toString();
        String string7 = this.REAL_PATH + HybsSystem.sys((String)"BIZLOGIC_SRC_PATH");
        int n = HybsSystem.sysBool((String)"BIZLOGIC_AUTO_COMPILE") ? 1 : 0;
        boolean bl = HybsSystem.sysBool((String)"BIZLOGIC_HOT_DEPLOY");
        String[] stringArray = new String[]{"message"};
        String[] stringArray2 = new String[]{string3};
        BizUtil.actBizLogic((String)string7, (String)string4, n != 0, (boolean)bl, (String)string6, (String)string, (String)string2, (String[])stringArray, (String[])stringArray2);
    }

    private final class QueueReceiveListener
    implements MessageListener {
        private final String queueId;
        private final String bizLogicId;

        public QueueReceiveListener(String string, String string2) {
            this.queueId = string;
            this.bizLogicId = string2;
        }

        public void onMessage(Message message) {
            TextMessage textMessage = (TextMessage)message;
            String string = "";
            try {
                string = textMessage.getText();
                textMessage.acknowledge();
                Daemon_QueueReceive.this.processMessage(this.queueId, this.bizLogicId, string);
            }
            catch (JMSException jMSException) {
                try {
                    Daemon_QueueReceive.this.dbAccessQueue.updateGE68("", "4");
                }
                catch (Exception exception) {
                    System.out.println("\u7ba1\u7406\u30c6\u30fc\u30d6\u30eb\u767b\u9332\u30a8\u30e9\u30fc\uff1a" + exception.getMessage());
                }
                throw new HybsSystemException("bizLogic\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + jMSException.getMessage());
            }
        }
    }
}

