/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.jdbc.FirebirdConnection;

public final class FirebirdSupportInfo {
    private final GDSServerVersion serverVersion;

    private FirebirdSupportInfo(GDSServerVersion serverVersion) {
        if (serverVersion == null) {
            throw new NullPointerException("serverVersion");
        }
        if (serverVersion.equals(GDSServerVersion.INVALID_VERSION)) {
            throw new IllegalArgumentException("serverVersion is an invalid version (GDSServerVersion.INVALID_VERSION)");
        }
        this.serverVersion = serverVersion;
    }

    public boolean isVersionEqualOrAbove(int majorVersion, int minorVersion) {
        return this.serverVersion.isEqualOrAbove(majorVersion, minorVersion);
    }

    public boolean isVersionEqualOrAbove(int requiredMajorVersion, int requiredMinorVersion, int requiredVariant) {
        return this.serverVersion.isEqualOrAbove(requiredMajorVersion, requiredMinorVersion, requiredVariant);
    }

    public boolean isVersionBelow(int majorVersion, int minorVersion) {
        return !this.isVersionEqualOrAbove(majorVersion, minorVersion);
    }

    public boolean supportsBigint() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsBoolean() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsDecfloat() {
        return this.isVersionEqualOrAbove(4, 0);
    }

    public boolean supportsDecimalPrecision(int precision) {
        if (precision < 1) {
            return false;
        }
        if (precision <= 18) {
            return true;
        }
        if (precision <= 38) {
            return this.isVersionEqualOrAbove(4, 0);
        }
        return false;
    }

    public int maxDecimalPrecision() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 38;
        }
        return 18;
    }

    public boolean supportsInt128() {
        return this.isVersionEqualOrAbove(4, 0);
    }

    public boolean supportsComment() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsGetSetContext() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsCase() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean reportsBlobCharSetInDescriptor() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean reportsByteLengthInDescriptor() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsInsertReturning() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsUpdateReturning() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsReturningAll() {
        return this.isVersionEqualOrAbove(4, 0);
    }

    public boolean supportsUtf8() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsSavepoint() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsExecuteBlock() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsSqlUserManagement() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsCancelOperation() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsTableAlias() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsNullDataType() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsUserAndGroupIdInUser() {
        return this.isVersionBelow(3, 0);
    }

    public boolean supportsProtocol(int protocolVersion) {
        switch (protocolVersion) {
            case 10: {
                return true;
            }
            case 11: {
                return this.isVersionEqualOrAbove(2, 1);
            }
            case 12: {
                return this.isVersionEqualOrAbove(2, 5);
            }
            case 13: {
                return this.isVersionEqualOrAbove(3, 0);
            }
            case 14: 
            case 15: {
                return this.isVersionEqualOrAbove(3, 0, 2);
            }
            case 16: {
                return this.isVersionEqualOrAbove(4, 0, 0);
            }
        }
        return false;
    }

    public boolean supportsCustomExceptionMessages() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsParametrizedExceptions() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsMonitoringTables() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsGlobalTemporaryTables() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsFullSearchableBlobs() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsIdentityColumns() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public int maxIdentifierLengthCharacters() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 63;
        }
        return 31;
    }

    public int maxIdentifierLengthBytes() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 252;
        }
        return 31;
    }

    public int maxReportedIdentifierLengthBytes() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 252;
        }
        if (this.reportsByteLengthInDescriptor()) {
            return 93;
        }
        return 31;
    }

    public int reportedMetadataCharacterSetId() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 4;
        }
        return 3;
    }

    public boolean supportsPageSize(int pageSize) {
        switch (pageSize) {
            case 1024: {
                return !this.isVersionEqualOrAbove(2, 1);
            }
            case 2048: {
                return !this.isVersionEqualOrAbove(2, 1);
            }
            case 4096: {
                return true;
            }
            case 8192: {
                return true;
            }
            case 16384: {
                return this.isVersionEqualOrAbove(2, 0);
            }
            case 32768: {
                return this.isVersionEqualOrAbove(4, 0);
            }
        }
        return false;
    }

    public boolean supportsWireEncryption() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsWireCompression() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsNativeUserDefinedFunctions() {
        return this.isVersionBelow(4, 0);
    }

    public boolean supportsPsqlFunctions() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsAuthenticationPlugin(String pluginName) {
        switch (pluginName) {
            case "Legacy_Auth": {
                return true;
            }
            case "Srp": {
                return this.isVersionEqualOrAbove(3, 0);
            }
            case "Srp224": 
            case "Srp256": 
            case "Srp384": 
            case "Srp512": {
                return this.isVersionEqualOrAbove(3, 0, 4);
            }
        }
        return false;
    }

    public boolean supportsRecordVersionPseudoColumn() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public int getSystemTableCount() {
        int databaseMajorVersion = this.serverVersion.getMajorVersion();
        int databaseMinorVersion = this.serverVersion.getMinorVersion();
        if (databaseMajorVersion < 2) {
            return 32;
        }
        if (databaseMajorVersion == 2 && databaseMinorVersion == 0) {
            return 33;
        }
        if (databaseMajorVersion == 2 && databaseMinorVersion == 1) {
            return 40;
        }
        if (databaseMajorVersion == 2 && databaseMinorVersion == 5) {
            return 42;
        }
        if (databaseMajorVersion == 3 && databaseMinorVersion == 0) {
            return 50;
        }
        if (databaseMajorVersion == 4 && databaseMinorVersion == 0) {
            return 53;
        }
        return -1;
    }

    public boolean supportsCaseSensitiveUserNames() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsExplainedExecutionPlan() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsTimeZones() {
        return this.isVersionEqualOrAbove(4, 0);
    }

    public boolean supportsPackages() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsFloatBinaryPrecision() {
        return this.isVersionEqualOrAbove(4, 0);
    }

    public boolean supportsStatementTimeouts() {
        return this.isVersionEqualOrAbove(4, 0);
    }

    public static FirebirdSupportInfo supportInfoFor(GDSServerVersion serverVersion) {
        return new FirebirdSupportInfo(serverVersion);
    }

    public static FirebirdSupportInfo supportInfoFor(FbAttachment attachment) {
        return FirebirdSupportInfo.supportInfoFor(attachment.getServerVersion());
    }

    public static FirebirdSupportInfo supportInfoFor(Connection connection) {
        try {
            if (connection.isWrapperFor(FirebirdConnection.class)) {
                return FirebirdSupportInfo.supportInfoFor(connection.unwrap(FirebirdConnection.class).getFbDatabase());
            }
            throw new IllegalArgumentException("connection needs to be (or unwrap to) an org.firebirdsql.jdbc.FBConnection");
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

