/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.queue;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueReceive;

public class QueueReceive_MQ
implements QueueReceive {
    private QueueConnection connection = null;
    private QueueSession session = null;
    private QueueReceiver receiver = null;
    List<QueueReceiver> listReceiver = null;
    private boolean batch = false;

    @Override
    public void connect(String string, String string2, String string3) {
        this.connect(string);
    }

    private void connect(String string) {
        try {
            if (this.batch) {
                String string2 = System.getProperty("mqUserId");
                String string3 = System.getProperty("mqPassword");
                ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(string);
                this.connection = activeMQConnectionFactory.createQueueConnection(string2, string3);
            } else {
                InitialContext initialContext = new InitialContext();
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)initialContext.lookup("java:comp/env/" + string);
                this.connection = queueConnectionFactory.createQueueConnection();
            }
            this.connection.start();
            this.session = this.connection.createQueueSession(false, 2);
            this.listReceiver = new ArrayList<QueueReceiver>();
        }
        catch (Exception exception) {
            throw new RuntimeException("MQ\u30b5\u30fc\u30d0\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\uff1a" + exception.getMessage());
        }
    }

    @Override
    public QueueInfo receive(String string) {
        QueueInfo queueInfo = null;
        try {
            Queue queue = this.session.createQueue(string);
            this.receiver = this.session.createReceiver(queue);
            TextMessage textMessage = (TextMessage)this.receiver.receive(1000L);
            if (textMessage != null) {
                textMessage.acknowledge();
                queueInfo = new QueueInfo();
                queueInfo.setMessage(textMessage.getText());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            try {
                this.receiver.close();
            }
            catch (Exception exception) {}
        }
        return queueInfo;
    }

    @Override
    public void setListener(String string, MessageListener messageListener) {
        QueueReceiver queueReceiver = null;
        try {
            Queue queue = this.session.createQueue(string);
            queueReceiver = this.session.createReceiver(queue);
            queueReceiver.setMessageListener(messageListener);
            this.listReceiver.add(queueReceiver);
        }
        catch (JMSException jMSException) {
            throw new RuntimeException("\u30ea\u30b9\u30ca\u30fc\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + jMSException.getMessage());
        }
    }

    @Override
    public void closeListener() {
        for (QueueReceiver queueReceiver : this.listReceiver) {
            try {
                queueReceiver.close();
            }
            catch (Exception exception) {}
        }
        this.listReceiver = null;
        this.listReceiver = new ArrayList<QueueReceiver>();
    }

    @Override
    public void close() {
        if (this.receiver != null) {
            try {
                this.receiver.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setBatchFlg(Boolean bl) {
        this.batch = bl;
    }

    public static void main(String[] stringArray) {
        QueueReceive_MQ queueReceive_MQ = new QueueReceive_MQ();
        queueReceive_MQ.setBatchFlg(true);
        System.setProperty("mqUserId", "admin");
        System.setProperty("mqPassword", "admin");
        queueReceive_MQ.connect("tcp://localhost:61616", null, null);
        String string = "queue01";
        QueueInfo queueInfo = queueReceive_MQ.receive(string);
        if (queueInfo != null) {
            System.out.println("message:" + queueInfo.getMessage());
        } else {
            System.out.println("\u30ad\u30e5\u30fc\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        queueReceive_MQ.closeListener();
        queueReceive_MQ.close();
    }

    static class QueueReceiveListener
    implements MessageListener {
        QueueReceiveListener() {
        }

        public void onMessage(Message message) {
            TextMessage textMessage = (TextMessage)message;
            String string = "";
            try {
                string = textMessage.getText();
                textMessage.acknowledge();
                System.out.println("message:" + string);
            }
            catch (JMSException jMSException) {
                throw new RuntimeException(jMSException.getMessage());
            }
        }
    }
}

