/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.business;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.business.ArrayTableModel;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.SystemParameter;

public abstract class AbstractBizLogic {
    private static final String CR = System.getProperty("line.separator");
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int NG = 2;
    protected static final int EXCEPTION = 8;
    protected static final int ORCL_ERR = 9;
    private Connection conn = null;
    private Transaction tran = null;
    private String dbid = null;
    DBFunctionName dbName = null;
    private HybsLoader loader = null;
    private String[] keys = null;
    private String[] vals = null;
    private final StringBuilder paramKeysStr = new StringBuilder("|");
    private final Map<String, String> variableMap = new HashMap<String, String>();
    private final Map<String, Formatter> formatMap = new HashMap<String, Formatter>();
    private final Map<String, SystemParameter> sysParamMap = new HashMap<String, SystemParameter>();
    private final ErrorMessage errMsg = new ErrorMessage();
    private String bizRtn = null;
    private boolean debugFlag = false;
    private final StringBuilder debugMsg = new StringBuilder();
    private boolean useParamMetaData = false;
    protected ArrayTableModel table = null;
    protected int row = -1;

    public void setTransaction(Transaction transaction) {
        this.tran = transaction;
        this.conn = this.tran.getConnection(this.dbid);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.dbid);
    }

    void setDbid(String string) {
        this.dbid = string;
    }

    void setLoader(HybsLoader hybsLoader) {
        if (this.loader != null) {
            String string = "\u65e2\u306b\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u30fc\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            throw new RuntimeException(string);
        }
        this.loader = hybsLoader;
    }

    void setTable(ArrayTableModel arrayTableModel) {
        if (this.table != null) {
            String string = "\u65e2\u306b\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            throw new RuntimeException(string);
        }
        this.table = arrayTableModel;
    }

    void setKeys(String[] stringArray) {
        if (this.keys != null) {
            String string = "\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u30ad\u30fc)\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + CR + "   KESY   =" + Arrays.toString(this.keys) + CR + "   in keys=" + Arrays.toString(stringArray);
            throw new RuntimeException(string);
        }
        this.keys = stringArray;
    }

    void setVals(String[] stringArray) {
        if (this.vals != null) {
            String string = "\u65e2\u306b\u56fa\u5b9a\u5024\u914d\u5217(\u5024)\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + CR + "   VALS   =" + Arrays.toString(this.vals) + CR + "   in vals=" + Arrays.toString(stringArray);
            throw new RuntimeException(string);
        }
        this.vals = stringArray;
    }

    void setUserId(String string) {
        this.variableMap.put("CON.USERID", string);
    }

    void setParentPgId(String string) {
        this.variableMap.put("CON.PGPID", string);
    }

    void setDebug() {
        this.debugFlag = true;
    }

    String getDebugMsg() {
        return this.debugMsg.toString();
    }

    boolean exec() throws Throwable {
        this.dbName = DBFunctionName.getDBName(ConnectionFactory.getDBName(this.dbid));
        this.makeParamMap();
        this.init();
        return this.main();
    }

    protected abstract void init();

    protected abstract boolean main();

    int getKekka() {
        return this.errMsg.getKekka();
    }

    ErrorMessage getErrMsg() {
        return this.errMsg;
    }

    String getReturn() {
        return this.bizRtn;
    }

    protected boolean isRequireTable() {
        return false;
    }

    protected final boolean isDebug() {
        return this.debugFlag;
    }

    protected final void debug(String string) {
        this.debugMsg.append(string).append(CR);
    }

    protected final String var(String string) {
        return this.variableMap.get(string);
    }

    protected final int vari(String string) {
        String string2 = this.var(string);
        return string2 == null || string2.isEmpty() ? 0 : Integer.parseInt(string2);
    }

    protected final double vard(String string) {
        String string2 = this.var(string);
        return string2 == null || string2.isEmpty() ? 0.0 : Double.parseDouble(string2);
    }

    protected final String[] varKeys() {
        Set<String> set = this.variableMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    protected final void set(String string, String string2) {
        if (this.paramKeysStr.indexOf("|" + string + "|") >= 0) {
            String string3 = "\u5f15\u6570\u3068\u540c\u3058\u540d\u524d\u306e\u5909\u6570\u3092\u5b9a\u7fa9\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "   key   =" + string + CR + "   \u5f15\u6570  =" + this.paramKeysStr;
            throw new RuntimeException(string3);
        }
        this.variableMap.put(string, string2);
    }

    protected final void set(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    protected final void set(String string, double d) {
        this.set(string, String.valueOf(d));
    }

    protected final String line(String string) {
        return this.line(string, this.row);
    }

    protected final String line(String string, int n) {
        if (this.table == null) {
            String string2 = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#line( String,int )\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "   line( " + string + "," + n + " );" + CR;
            throw new RuntimeException(string2);
        }
        if (n < 0 || n >= this.table.getRowCount()) {
            return null;
        }
        int n2 = this.table.getColumnNo(string);
        if (n2 < 0) {
            return null;
        }
        return this.table.getValue(n, n2);
    }

    protected final int linei(String string) {
        return this.linei(string, this.row);
    }

    protected final int linei(String string, int n) {
        String string2 = this.line(string, n);
        return string2 == null || string2.isEmpty() ? 0 : Integer.parseInt(string2);
    }

    protected final double lined(String string) {
        return this.lined(string, this.row);
    }

    protected final double lined(String string, int n) {
        String string2 = this.line(string, n);
        return string2 == null || string2.isEmpty() ? 0.0 : Double.parseDouble(string2);
    }

    protected final String[] lineKeys() {
        if (this.table == null) {
            String string = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#lineKeys()\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string);
        }
        return this.table.getNames();
    }

    protected final boolean isLine(String string) {
        if (this.table == null) {
            String string2 = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001#isLine( String )\u30e1\u30bd\u30c3\u30c9\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "   isLine( " + string + " );" + CR;
            throw new RuntimeException(string2);
        }
        return this.table.getColumnNo(string) >= 0;
    }

    protected final void rtn(String string) {
        this.bizRtn = string;
    }

    protected final boolean call(String string, String string2, String string3) {
        return this.call(string, string2, string3, this.row, this.table);
    }

    protected final boolean call(String string, String string2, String string3, int n, ArrayTableModel arrayTableModel) {
        ErrMsg[] errMsgArray;
        boolean bl;
        AbstractBizLogic abstractBizLogic = (AbstractBizLogic)this.loader.newInstance(string);
        if (abstractBizLogic.isRequireTable()) {
            String string4 = "\u3053\u306e\u30af\u30e9\u30b9\u306f\u3001\u5916\u90e8\u304b\u3089\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u3092\u30bb\u30c3\u30c8\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u305f\u3081\u3001\u5b50\u30ed\u30b8\u30c3\u30af\u3068\u3057\u3066\u547c\u3073\u51fa\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "  [\u30af\u30e9\u30b9\u540d=" + abstractBizLogic.getClass().getName() + "]" + CR + "   subLogicName =" + string + "   key =[" + string2 + "]" + "   val =[" + string3 + "]" + CR;
            throw new RuntimeException(string4);
        }
        abstractBizLogic.setTransaction(this.tran);
        abstractBizLogic.setLoader(this.loader);
        abstractBizLogic.setKeys(StringUtil.csv2Array(string2));
        String[] stringArray = StringUtil.csv2Array(string3);
        for (bl = false; bl < stringArray.length; bl += 1) {
            stringArray[bl] = this.replaceParam(stringArray[bl], n, arrayTableModel);
        }
        abstractBizLogic.setVals(stringArray);
        abstractBizLogic.setUserId(this.variableMap.get("CON.USERID"));
        abstractBizLogic.setParentPgId(this.variableMap.get("CON.PGID"));
        if (this.debugFlag) {
            abstractBizLogic.setDebug();
        }
        bl = false;
        try {
            bl = abstractBizLogic.exec();
        }
        catch (Throwable throwable) {
            String string5 = "\u5b50\u30ed\u30b8\u30c3\u30af\u306e\u547c\u3073\u51fa\u3057\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "   subLogicName =" + string + CR + "   key =[" + string2 + "]" + "   val =[" + string3 + "]" + CR;
            throw new RuntimeException(string5, throwable);
        }
        this.variableMap.put("RETURN", abstractBizLogic.getReturn());
        if (this.debugFlag) {
            this.debug(abstractBizLogic.getDebugMsg());
        }
        if ((errMsgArray = abstractBizLogic.getErrMsg().toArray()).length > 0) {
            ErrorMessage errorMessage = new ErrorMessage();
            for (int i = 0; i < errMsgArray.length; ++i) {
                errorMessage.addMessage(errMsgArray[i].copy(n));
            }
            this.errMsg.append(errorMessage);
        }
        return bl;
    }

    protected final void sql(String string) {
        this.sql(string, this.row, this.table);
    }

    protected final void sql(String string, int n, ArrayTableModel arrayTableModel) {
        ArrayTableModel arrayTableModel2 = this.execSQL(string, n, arrayTableModel);
        if (arrayTableModel2 != null && arrayTableModel2.getRowCount() > 0) {
            String[] stringArray = arrayTableModel2.getNames();
            String[] stringArray2 = arrayTableModel2.getValues(0);
            for (int i = 0; i < stringArray.length; ++i) {
                this.variableMap.put(stringArray[i], stringArray2[i]);
            }
        }
    }

    protected final int seq(String string) {
        return this.dbName.getSequence(string, this.tran);
    }

    private ArrayTableModel execSQL(String string, int n, ArrayTableModel arrayTableModel) {
        ArrayTableModel arrayTableModel2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block13: {
            String string2 = string;
            string2 = this.replaceParam(string2, false);
            Formatter formatter = null;
            if (arrayTableModel != null && string2.indexOf(91) >= 0) {
                formatter = this.getFormatter(string2, arrayTableModel);
                string2 = formatter.getQueryFormatString();
            }
            preparedStatement = null;
            resultSet = null;
            arrayTableModel2 = null;
            try {
                int n2;
                Wrapper wrapper;
                preparedStatement = this.conn.prepareStatement(string2);
                if (arrayTableModel != null && formatter != null) {
                    int[] nArray = formatter.getClmNos();
                    if (this.useParamMetaData) {
                        wrapper = preparedStatement.getParameterMetaData();
                        for (n2 = 0; n2 < nArray.length; ++n2) {
                            int n3 = wrapper.getParameterType(n2 + 1);
                            String string3 = arrayTableModel.getValue(n, nArray[n2]);
                            if (string3 == null || string3.isEmpty()) {
                                preparedStatement.setNull(n2 + 1, n3);
                                continue;
                            }
                            preparedStatement.setObject(n2 + 1, (Object)string3, n3);
                        }
                    } else {
                        for (int i = 0; i < nArray.length; ++i) {
                            preparedStatement.setObject(i + 1, arrayTableModel.getValue(n, nArray[i]));
                        }
                    }
                }
                boolean bl = preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (bl) {
                    wrapper = resultSet.getMetaData();
                    n2 = wrapper.getColumnCount();
                    String[] stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = wrapper.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
                    }
                    String[][] stringArray2 = DBUtil.resultToArray(resultSet, false);
                    arrayTableModel2 = new ArrayTableModel(stringArray, stringArray2);
                    this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getFetchSize()));
                    break block13;
                }
                this.variableMap.put("SQL_ROWCOUNT", String.valueOf(preparedStatement.getUpdateCount()));
            }
            catch (SQLException sQLException) {
                try {
                    String string4 = "\u914d\u5217\u578b\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + "   sql =" + string2 + CR + "   ArrayTableModel=" + arrayTableModel;
                    throw new RuntimeException(string4, sQLException);
                }
                catch (Throwable throwable) {
                    Closer.resultClose(resultSet);
                    Closer.stmtClose(preparedStatement);
                    throw throwable;
                }
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(preparedStatement);
        return arrayTableModel2;
    }

    protected final void error(int n, String string, String ... stringArray) {
        this.error(this.row, n, string, stringArray);
    }

    protected final void error(int n, int n2, String string, String ... stringArray) {
        this.errMsg.addMessage(n, n2, string, this.replaceParam(stringArray));
    }

    protected final boolean must(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = true;
        String[] stringArray = StringUtil.csv2Array(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.variableMap.get(stringArray[i]);
            if (string2 != null && string2.length() != 0) continue;
            this.error(2, "ERR0012", "{#" + stringArray[i] + "}");
            bl = false;
        }
        return bl;
    }

    protected final boolean exist(String string, String string2, String string3, String string4) {
        return this.exist(string, string2, string3, string4, null, null, true);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.exist(string, string2, string3, string4, string5, string6, true);
    }

    protected final boolean exist(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        int n;
        String string7;
        String[] stringArray;
        if (string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0) {
            String string8 = "\u30ab\u30e9\u30e0\u53c8\u306f\u3001\u5024\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "   ns =[" + string3 + "]" + "   vs =[" + string4 + "]";
            throw new RuntimeException(string8);
        }
        String string9 = string3 + (string5 == null || string5.length() == 0 ? "" : "," + string5);
        String[] stringArray2 = StringUtil.csv2Array(string9);
        if (stringArray2.length != (stringArray = StringUtil.csv2Array(string7 = string4 + (string6 == null || string6.length() == 0 ? "" : "," + string6))).length) {
            String string10 = "\u30ab\u30e9\u30e0\u3068\u5024\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + CR + "   names = [" + string9 + "]" + CR + "   vals  = [" + string7 + "]";
            throw new RuntimeException(string10);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select count(*) CNT from ").append(string2);
        for (n = 0; n < stringArray2.length; ++n) {
            if (n == 0) {
                stringBuilder.append(" where ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(stringArray2[n]).append(" = ").append(stringArray[n]);
        }
        n = 0;
        ArrayTableModel arrayTableModel = this.execSQL(stringBuilder.toString(), this.row, this.table);
        if (arrayTableModel != null && arrayTableModel.getRowCount() >= 0) {
            n = Integer.valueOf(arrayTableModel.getValues(0)[0]);
        }
        String string11 = this.replaceParam(string4);
        if ("true".equalsIgnoreCase(string)) {
            if (n <= 0) {
                if (bl) {
                    this.error(2, "ERR0025", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else if ("false".equalsIgnoreCase(string)) {
            if (n > 0) {
                if (bl) {
                    this.error(2, "ERR0026", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else if ("one".equalsIgnoreCase(string)) {
            if (n > 1) {
                if (bl) {
                    this.error(2, "ERR0027", "{#" + string3 + "}", string11);
                }
                return false;
            }
        } else {
            String string12 = "type\u306f\u3001true\u3001false\u3001one\u306e\u3044\u305a\u308c\u304b\u3067\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + CR + "   type = [" + string + "]";
            throw new RuntimeException(string12);
        }
        return true;
    }

    private void makeParamMap() {
        if (this.keys != null && this.vals != null) {
            if (this.keys.length == this.vals.length) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.paramKeysStr.append(this.keys[i]).append("|");
                    this.variableMap.put(this.keys[i], this.vals[i]);
                }
            } else {
                String string = "keys\u3068vals\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + CR + "   keys   =" + Arrays.toString(this.keys) + CR + "   vals   =" + Arrays.toString(this.vals);
                throw new RuntimeException(string);
            }
        }
        String string = HybsDateUtil.getDate("yyyyMMddHHmmss");
        this.variableMap.put("CON.YMDH", string);
        this.variableMap.put("CON.YMD", string.substring(0, 8));
        this.variableMap.put("CON.HMS", string.substring(8));
        this.variableMap.put("CON.PGID", this.getClass().getSimpleName());
    }

    private String replaceParam(String string) {
        return this.replaceParam(string, this.row, this.table);
    }

    private String replaceParam(String string, boolean bl) {
        return bl ? this.replaceParam(string, this.row, this.table) : this.replaceParam(string, 0, null);
    }

    private String replaceParam(String string, int n, ArrayTableModel arrayTableModel) {
        Object object;
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = string;
        if (this.variableMap.size() > 0 && string2.indexOf("{@") >= 0) {
            object = this.getSysParam(string2);
            string2 = ((SystemParameter)object).replace(this.variableMap);
        }
        if (arrayTableModel != null && string2.indexOf(91) >= 0) {
            object = this.getFormatter(string2, arrayTableModel);
            string2 = ((Formatter)object).getFormatString(n);
            string2 = ',' + string2;
            string2 = string2.replace(",null", ",");
            string2 = string2.substring(1);
        }
        return string2;
    }

    private String[] replaceParam(String[] stringArray) {
        return this.replaceParam(stringArray, this.row, this.table);
    }

    private String[] replaceParam(String[] stringArray, int n, ArrayTableModel arrayTableModel) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.replaceParam(stringArray[i], n, arrayTableModel);
        }
        return stringArray;
    }

    private Formatter getFormatter(String string, ArrayTableModel arrayTableModel) {
        Formatter formatter = this.formatMap.get(string + arrayTableModel.toString());
        if (formatter == null) {
            formatter = new Formatter(arrayTableModel);
            formatter.setFormat(string);
            this.formatMap.put(string + arrayTableModel.toString(), formatter);
        }
        return formatter;
    }

    private SystemParameter getSysParam(String string) {
        SystemParameter systemParameter = this.sysParamMap.get(string);
        if (systemParameter == null) {
            systemParameter = new SystemParameter(string);
            this.sysParamMap.put(string, systemParameter);
        }
        return systemParameter;
    }

    protected final ArrayTableModel createTableBySql(String string) {
        return this.createTableBySql(string, this.row, this.table);
    }

    protected final ArrayTableModel createTableBySql(String string, int n, ArrayTableModel arrayTableModel) {
        return this.execSQL(string, n, arrayTableModel);
    }
}

