/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cloudstorage.api.queryparam.QueryParam;
import oracle.cloudstorage.api.request.IAttribute;

public abstract class AttributeProvider<V, P extends AttributeProvider<V, P, A>, A extends IAttribute>
implements Iterable<Map.Entry<String, V>> {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    final String key;
    V value;
    private final Map.Entry<String, V> entry = new Map.Entry<String, V>(){

        @Override
        public String getKey() {
            return AttributeProvider.this.key;
        }

        @Override
        public V getValue() {
            return AttributeProvider.this.value;
        }

        @Override
        public V setValue(V value) {
            AttributeProvider.this.value = value;
            return AttributeProvider.this.value;
        }
    };
    private static final Pattern URL_SPACE = Pattern.compile("\\+");
    private static final String HEX_SPACE = "%20";

    public AttributeProvider(String key, V value) {
        this.key = key == null || key.equals(QueryParam.repPolicy.toString()) ? key : key.toLowerCase();
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public P encode() {
        return this.encode(UTF_8);
    }

    public final P encode(Charset encoding) {
        this.value = this.encode(encoding, this.value);
        return (P)this;
    }

    protected abstract V encode(Charset var1, V var2);

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        return Arrays.asList(this.entry).iterator();
    }

    protected String encode(Charset encoding, String unencoded) {
        return AttributeProvider.encode(encoding, unencoded, this.key);
    }

    public static String encode(Charset encoding, String unencoded, String key) {
        try {
            String urlEncoded = URLEncoder.encode(unencoded, encoding.toString());
            String encoded = URL_SPACE.matcher(urlEncoded).replaceAll(HEX_SPACE);
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Attempting to encode value [" + unencoded + "] of " + key + " using encoding " + encoding, e);
        }
    }
}

