/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import oracle.cloudstorage.io.Md5Stream;

public class Md5InputStream
extends FilterInputStream {
    private final Md5Stream md5er;

    public Md5InputStream(InputStream in) {
        this(in, null);
    }

    public Md5InputStream(InputStream source, oracle.cloudstorage.concurrent.Future<String> futureMd5) {
        super(source);
        this.md5er = new Md5Stream(futureMd5);
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        this.update(null, 0, read);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        this.update(b, 0, read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.update(b, off, read);
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.md5er.reset();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.md5er.digest();
    }

    protected final void update(byte[] b, int off, int len) {
        if (len < 0) {
            this.md5er.digest();
        } else {
            this.md5er.update(b, off, len);
        }
    }

    public Future<String> getFutureMd5() {
        return this.md5er.getFutureMd5();
    }
}

