<jsp:directive.page pageEncoding="UTF-8" />

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @FROM_DBID}" val2="ORACLE">
  <og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="0" scope="request">
		select A.TABLE_NAME,COALESCE(B.COMMENTS,A.TABLE_NAME) AS NAME_JA,
				A.COLUMN_ID AS SEQNO,
				A.COLUMN_NAME,COALESCE(C.COMMENTS,A.COLUMN_NAME) AS CLM_NAME,
			    DATA_TYPE,
		--		(CASE WHEN DATA_PRECISION IS NULL THEN DATA_LENGTH ELSE (DATA_PRECISION+0.1*DATA_SCALE) END) AS DATA_LENGTH,
					( CASE	WHEN DATA_TYPE = 'BLOB' or DATA_TYPE = 'CLOB'
								THEN NULL
							WHEN DATA_TYPE = 'NUMBER' AND DATA_PRECISION IS NULL 
								THEN NULL
							WHEN DATA_TYPE = 'VARCHAR2'
								THEN to_char(DATA_LENGTH)
							WHEN DATA_PRECISION IS NULL 
								THEN to_char(DATA_LENGTH)
								ELSE (	CASE WHEN DATA_SCALE = 0 or DATA_SCALE is null
											THEN to_char(DATA_PRECISION)
											ELSE DATA_PRECISION || ',' || DATA_SCALE
									  	END )
							 END ) AS USE_LENGTH ,
		--		DECODE(NULLABLE,'N','NN','') AS NN,
			    (CASE NULLABLE WHEN 'N' THEN 'NN' ELSE '' END) AS NN ,
				DATA_DEFAULT
		from USER_TAB_COLS A left outer join USER_TAB_COMMENTS B
				on A.TABLE_NAME = B.TABLE_NAME
					 left outer join USER_COL_COMMENTS C
					on  A.TABLE_NAME  = C.TABLE_NAME
					and A.COLUMN_NAME = C.COLUMN_NAME
		<og:where>
			<og:and value="A.TABLE_NAME  like '{@TABLE_NAME}%'"		/>
			<og:and value="A.COLUMN_NAME like '{@COLUMN_NAME}%'"	/>
		</og:where>
		<og:appear startKey = "order by" value = "{@ORDER_BY}"
					defaultVal = "1,3" />
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @FROM_DBID}" val2="FIREBIRD">
  <og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="0" scope="request">
			select
				trim(r.RDB$RELATION_NAME)	AS TABLE_NAME,
				trim(r.RDB$RELATION_NAME)	AS NAME_JA,
				r.RDB$FIELD_POSITION		AS SEQNO,
				trim(r.RDB$FIELD_NAME)		AS COLUMN_NAME,
				trim(r.RDB$FIELD_NAME)		AS CLM_NAME,
				CASE f.RDB$FIELD_TYPE
					WHEN   7 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'SMALLINT'
						END
					WHEN   8 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'INTEGER'
						END
					WHEN  16 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'INT64'
						END
					WHEN   9 THEN 'QUAD'
					WHEN  10 THEN 'FLOAT'
					WHEN  11 THEN 'D_FLOAT'
					WHEN  12 THEN 'DATE'
					WHEN  13 THEN 'TIME'
					WHEN  14 THEN 'CHAR'
					WHEN  27 THEN 'DOUBLE'
					WHEN  35 THEN 'TIMESTAMP'
					WHEN  37 THEN 'VARCHAR'
					WHEN  40 THEN 'CSTRING'
					WHEN 261 THEN 'BLOB'
					ELSE 'UNKNOWN'
					END AS DATA_TYPE ,
				f.RDB$CHARACTER_LENGTH 		AS DATA_LENGTH ,
				( CASE WHEN r.RDB$NULL_FLAG = '1' THEN 'NN' ELSE '' END ) AS NN,
				replace(upper(r.RDB$DEFAULT_SOURCE),'DEFAULT ','') AS DATA_DEFAULT
			from RDB$RELATION_FIELDS r LEFT JOIN RDB$FIELDS f
			ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
			where r.RDB$SYSTEM_FLAG = 0
			<og:where startKey="and">
				<og:and value = "r.RDB$RELATION_NAME like '{@TABLE_NAME}%'"		/>
				<og:and value = "r.RDB$FIELD_NAME    like '{@COLUMN_NAME}%'"	/>
			</og:where>
		<og:appear startKey = "order by" value = "{@ORDER_BY}"
					defaultVal = "1,3" />
  </og:query>
</og:equals>

<!-- ORACLE,FIREBIRD 以外の場合 -->
<og:equals val1="ORACLE,FIREBIRD" val2="{@DBF.NAME @FROM_DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2010}" val1="{@DBF.NAME @FROM_DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:tableFilter classId="LABEL" scope="request" caseNN="{@SYSTEM_ID}"
		 keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},NAME_JA,NAME_JA" caseKey="NEW" caseVal="{@command}" />

<!-- CLM_NAME にリソースを適用します。 -->
<og:tableFilter classId="LABEL" scope="request" caseNN="{@SYSTEM_ID}"
		 keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},CLM_NAME,CLM_NAME" caseKey="NEW" caseVal="{@command}" />
