<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			  omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
<!--
  <xsl:param name="DYSET"	  select='java:org.opengion.fukurou.tools.util.DateSet.getDate("yyyyMMddHHmmss")' />
-->

  <xsl:param name="row_header" >
	 <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <TBLSYU	><xsl:value-of select="$TBLSYU"    /></TBLSYU>
	 <ADDRESS	><xsl:value-of select="$ADDRESS"   /></ADDRESS>
	 <FILENAME	><xsl:value-of select="$FILENAME"  /></FILENAME>
	 <FILEPATH	><xsl:value-of select="$FILEPATH"  /></FILEPATH>
	 <MODIFIED	><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root" >
	 <xsl:if test="not(@version='2.0')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR01</MSGCD>
		 <MSGTXT >jsp:root タグのversion属性は、2.0 を指定してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>

	<xsl:apply-templates select="//og:link" />
	<xsl:apply-templates select="//og:sql | //og:update | //og:tableExist | //og:tabTable | //og:tab" />
	<xsl:apply-templates select="//og:head" />
	<xsl:apply-templates select="//og:writeTable" />
	<xsl:apply-templates select="//og:option" />
	<xsl:apply-templates select="//og:query" />
	<xsl:apply-templates select="//og:userInfo" />
	<xsl:apply-templates select="//og:view" />
	<xsl:apply-templates select="//og:submit" />
	<xsl:apply-templates select="//og:equals" />
	<xsl:apply-templates select="//og:value" />
	<xsl:apply-templates select="//og:entry" />
	<xsl:apply-templates select="//og:viewLink" />
	<xsl:apply-templates select="//og:viewMarker" />
	<xsl:apply-templates select="//og:writeCheck" />
	<xsl:apply-templates select="//og:input" />
	<xsl:apply-templates select="//*[starts-with( @onClick ,'window_open' )]" />
	<xsl:apply-templates select="//*[@tableId]" />
	<xsl:apply-templates select="//*[@msg] | //*[@msgParamKeys]" />
	<xsl:apply-templates select="//*[@optionAttributes]" />
	<xsl:apply-templates select="//og:columnCheck" />
	<xsl:apply-templates select="//og:column" />
	<xsl:apply-templates select="//og:column | //og:input | //og:select | //og:hidden | //og:submit | //og:textarea | //input | //select | //textarea"
						 mode="form-in" />
	<xsl:apply-templates select="//og:hidden" />
	<xsl:apply-templates select="//form" />
	<xsl:apply-templates select="//frameset" />
	<xsl:apply-templates select="//og:frame" />
	<xsl:apply-templates select="//*[@width] | //*[@height]" />
	<xsl:apply-templates select="//og:message" />
	<xsl:apply-templates select="//og:appear" />
	<xsl:apply-templates select="//og:forward" />
	<xsl:apply-templates select="//og:comment" />
	<xsl:apply-templates select="//og:button" />
	<xsl:apply-templates select="//jsp:text" />
	<xsl:apply-templates select="//tr" />

	<xsl:if test="(starts-with( $FILENAME ,'query' ) or starts-with( $FILENAME ,'result' ) or starts-with( $FILENAME ,'update' ) or starts-with( $FILENAME ,'entry' ) ) and not(//og:comment)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD	>ERROR23</MSGCD>
		<MSGTXT >comment タグを記述して下さい。</MSGTXT>
		<TEXT_DATA	><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="starts-with( $FILENAME ,'result' ) and not(//og:errorMessage) and (//og:writeCheck)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING16</MSGCD>
		<MSGTXT >errorMessage タグを記述して下さい。</MSGTXT>
		<TEXT_DATA	><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="($FILENAME = 'copy.jsp' ) or ( $FILENAME = 'modify.jsp' ) or ( $FILENAME = 'delete.jsp' ) or ( $FILENAME = 'insert.jsp' )" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING24</MSGCD>
		<MSGTXT ><xsl:value-of select="$FILENAME" /> は、update.jsp として統合する方向で検討してください。</MSGTXT>
		<TEXT_DATA	><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="(starts-with( $FILENAME ,'コピー' ) or string-length( $FILENAME ) &gt; 15)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING25</MSGCD>
		<MSGTXT ><xsl:value-of select="$FILENAME" /> は、ファイル名が長すぎます。バックアップファイルならば、backup フォルダに移動してください。</MSGTXT>
		<TEXT_DATA	><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

  </xsl:template>

  <xsl:template match="og:link" >
	 <xsl:if test="@value and not(preceding::og:link)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02</MSGCD>
		 <MSGTXT >link タグのvalue属性は廃止属性です。vals 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and ( @value | @vals )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03</MSGCD>
		 <MSGTXT >link タグのvals 属性とペアの keys属性が存在しません。keys,vals 属性はセットで使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@gamenId) and starts-with( @href ,'../' ) and not(@useGamenId='false')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04</MSGCD>
		 <MSGTXT >link タグで別画面へ飛ばす場合は、gamenId 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and contains( @href ,'?' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR05</MSGCD>
		 <MSGTXT >link タグの href でパラメータを渡す場合、keys,vals 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@fileCheck='false') or (@filePath='false') or (@useDirectJump='false') or (@hrefOnly='false') or (@useURLCheck='false')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27A</MSGCD>
		 <MSGTXT >link タグの fileCheck,filePath,useDirectJump,hrefOnly,useURLCheck 属性は、初期値 false ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@onLink='true') or (@markList='true') or (@useGamenId='true') or (@useRequestCache='true')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27B</MSGCD>
		 <MSGTXT >link タグの onLink,markList,useGamenId,useRequestCache 属性は、初期値 true ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@href) and not(@name)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING30</MSGCD>
		 <MSGTXT >link タグの href 属性は出来るだけ指定してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:sql" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06A</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。代わりに valueタグを使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:tabTable | og:tab" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06B</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。tabLink、tabList の使用をご検討ください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:tableExist" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06C</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。代わりに dataCheckタグを使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:update" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06D</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。代わりに tableUpdateタグを使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:head" >
	 <xsl:if test="@useTimeSet | @useToggleFrame | @useInputFocus | @useHilightRow | @usePrintLine | @useRealTimeCheck | @useAutoConvert | @useFocusHilight | @useFocusFirstElm | @useAdjustFrameHeight" >	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING22</MSGCD>
		 <MSGTXT >head タグの属性に廃止属性が含まれます。代替方法はありませんので、廃止属性を削除してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- -jspInclude=false で実行しないと、include が取り込まれるため、チェックできない。-->
<!--
	 <xsl:if test="( not($FILENAME = 'forward.jsp' ) and not(//jsp:directive.include[@file='/jsp/common/htmlend.jsp']) )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING26</MSGCD>
		 <MSGTXT >head タグを記述する場合は、/jsp/common/htmlend.jsp ファイルをインポートしてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
-->
  </xsl:template>

  <xsl:template match="og:writeTable" >
	 <xsl:if test="@direct" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING23</MSGCD>
		 <MSGTXT >writeTable タグのdirect属性は廃止属性です。結果をダイレクトするとエンコード等でおかしな動きをする可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@useNumber='true')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27B</MSGCD>
		 <MSGTXT >writeTable タグの useNumber 属性は、初期値 true ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:option" >
	 <xsl:if test="@code" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR07</MSGCD>
		 <MSGTXT >option タグのcode属性は廃止属性です。カラムリソースで、コードカラム属性を定義して使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="ancestor::og:queryOption" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING18</MSGCD>
		 <MSGTXT >option タグは、queryOption タグのBODY部に入れずに、select タグの直下に配置してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:query" >
	 <xsl:if test="string-length(.) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING01</MSGCD>
		 <MSGTXT >query タグの設定文字数が多すぎます(制限1000文字)。QUERY文を見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:userInfo" >
	 <xsl:if test="@query" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR08</MSGCD>
		 <MSGTXT >userInfo タグのquery属性は廃止属性です。属性そのものを削除可能です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@nullSet" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR09</MSGCD>
		 <MSGTXT >userInfo タグのnullSet属性は廃止属性です。value タグの使用を検討願います。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02</MSGCD>
		 <MSGTXT >userInfo タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:view" >
	 <xsl:if test="@changeLabelKeys | @changeLabelVals" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR10</MSGCD>
		 <MSGTXT >view タグのchangeLabel***属性は廃止属性です。columnEditor タグで、ラベルを入れ替える方法で代替してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::og:message" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING03</MSGCD>
		 <MSGTXT >message タグは、{@LBL.XXXX} に置き換え可能です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (ancestor::table | ancestor::div)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21A</MSGCD>
		 <MSGTXT >view タグを、table , div などで囲うとヘッダー固定が崩れる可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and ((following::og:link) | (following::og:column))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21B</MSGCD>
		 <MSGTXT >view タグの後ろに、link や column タグがあると、ヘッダー固定時に見えなくなります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (last() &gt; 1) and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21C</MSGCD>
		 <MSGTXT >view タグが複数存在すると、ヘッダー固定が崩れる可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useScrollBar='true'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21D</MSGCD>
		 <MSGTXT >view のヘッダー固定は、推奨機能なので、個別に設定しないでください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:submit" >
	 <xsl:if test="not(//og:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11</MSGCD>
		 <MSGTXT >submit タグは、writeCheck タグの子要素として使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with( $FILENAME ,'query' ) and not(//og:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING19</MSGCD>
		 <MSGTXT >submit タグが、queryButton タグに置き換え可能か検討してしてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@value='update'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28A</MSGCD>
		 <MSGTXT >submit タグで、value="update" は、action属性で置換えを検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with( $FILENAME ,'update' ) and ( @value='entry' or @value='reset' ))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28B</MSGCD>
		 <MSGTXT >submit タグで、value="entry" 又は "entry" の場合は、action属性で置換えを検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:button" >
	 <xsl:if test="(starts-with( $FILENAME ,'query' ) and @type='submit' and not(//og:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING20</MSGCD>
		 <MSGTXT >button タグが、queryButton タグに置き換え可能か検討してしてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:equals" >
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING04</MSGCD>
		 <MSGTXT >equals タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:value" >
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING05</MSGCD>
		 <MSGTXT >value タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="count( //og:value[@command='SQL' and contains( * ,'DUAL')] ) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING06</MSGCD>
		 <MSGTXT >value タグの SQL 構文で、DUAL を複数使用しています。まとめる事が可能か検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@nullSet" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING24</MSGCD>
		 <MSGTXT >value タグのnullSet属性は廃止属性です。属性そのものを削除可能です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:entry" >
	 <xsl:if test="(position() = last()) and count( //og:entry[not(ancestor::og:equals)] ) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR12</MSGCD>
		 <MSGTXT >entry タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewLink" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR13</MSGCD>
		 <MSGTXT >viewLink タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewMarker" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR14</MSGCD>
		 <MSGTXT >viewMarker タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:writeCheck" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING07</MSGCD>
		 <MSGTXT >writeCheck タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(descendant::og:submit)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11B</MSGCD>
		 <MSGTXT >writeCheck タグの子要素には、submit タグを使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:input" >
	 <xsl:if test="(//og:writeCheck) and (@type='submit')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING08</MSGCD>
		 <MSGTXT >input タグは、writeCheck タグの子要素として使用しないでください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[starts-with( @onClick ,'window_open' )]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING09</MSGCD>
		 <MSGTXT >window_open の代わりに、popup タグの使用を検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@tableId]" >
	 <xsl:if test="last() &gt; 3 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING10</MSGCD>
		 <MSGTXT >tableId 属性を使いすぎです(制限3個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@msg] | *[@msgParamKeys]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR25</MSGCD>
		 <MSGTXT >msg 属性やmsgParamKeys属性は廃止属性です。lbl属性,lblParamKeys属性に置き換えてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@optionAttributes]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING29</MSGCD>
		 <MSGTXT >optionAttributes 属性は、古い仕様です。JavaScriptのイベント系は専用属性をご使用ください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:columnCheck" >
	 <xsl:if test="preceding-sibling::og:entry" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15A</MSGCD>
		 <MSGTXT >columnCheck タグでチェックする前に、entry タグがあります。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>

<!--
	 <xsl:if test="not(following-sibling::og:entry) and starts-with( $FILENAME ,'result' ) and (//og:writeCheck)" >
-->
	 <xsl:if test="not(//og:entry) and starts-with( $FILENAME ,'result' ) and (//og:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15B</MSGCD>
		 <MSGTXT >columnCheck タグのチェック後に、entry タグありません。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@nullCheck or @mustAnyCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING17</MSGCD>
		 <MSGTXT >columnCheck タグのnullCheck属性とmustAnyCheck属性は自動チェックされます。設定不要です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:column" >
	 <xsl:if test="(@addNoValue='true') or (@writable='true') or (@useRequestValue='true')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28</MSGCD>
		 <MSGTXT >column タグの addNoValue,writable,useRequestValue 属性は、初期値 true ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:column | og:input | og:select | og:hidden | og:submit | og:textarea | input | select | textarea"
				mode="form-in" >
	 <xsl:if test="not(@writable='false' or @writable='FALSE') and not(ancestor::form) and not(@onClick='history.back()')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR16</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグが、form タグの中にありません。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:hidden" >
	 <xsl:if test="@names" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR17</MSGCD>
		 <MSGTXT >hidden タグのnames属性は廃止属性です。keys 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@name and @keys) or (@value and @vals) or (@name and @vals) or (@keys and @value)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR18</MSGCD>
		 <MSGTXT >hidden タグは、name,value属性のペアか、keys,valsのペアで指定してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="form" >
	 <xsl:if test="descendant::og:view and not(@method='POST')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING11</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、method="POST" を使用することを検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::og:view and not(starts-with( @onSubmit ,'return oneClick' ) )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING12</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、２度押し防止JavaScript( return oneClick(); )の使用を検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="starts-with( @action ,'../' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR19</MSGCD>
		 <MSGTXT >form タグの action 属性に、相対パスを使用するのは避けてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="frameset" >
	 <xsl:if test="not(@name='SUB_FRAME') and not(@name='TOP_FRAME')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING13</MSGCD>
		 <MSGTXT >フレーム分割(frameset)時の自動調整機能を有効にするには、name="SUB_FRAME" が必要です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:frame" >
	 <xsl:if test="starts-with( @src ,'../' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR20</MSGCD>
		 <MSGTXT >frame タグの src 属性に、相対パスを指定するのは、良くない慣習です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@width] | *[@height]" >
	 <xsl:if test="not( string(number( @width | @height ) ) = 'NaN' ) and not(name() = 'og:chartCreate')">
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR21</MSGCD>
		 <MSGTXT >width や height 属性 を指定する場合は、単位(pt,px,%)が必要です。(IE7 必須)</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:message" >
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING14</MSGCD>
		 <MSGTXT >message タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:appear" >
	 <xsl:if test="not(@defaultVal)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING15</MSGCD>
		 <MSGTXT >appear タグで、defaultVal 属性を指定しないと、SQL構文エラーになる可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:forward" >
	 <xsl:if test="not(@gamenId) and starts-with( @page ,'../' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR22</MSGCD>
		 <MSGTXT >forward タグで別画面へ飛ばす場合は、gamenId 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:comment" >
	 <xsl:if test="not(@system) or not(@pgid)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR24</MSGCD>
		 <MSGTXT >comment タグにシステム名、(system,pgid)を指定して下さい。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>
  
  <xsl:template match="jsp:text" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING31</MSGCD>
		 <MSGTXT >jsp:text は、jsp:root 直下以外では使われなくなりました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>

    <xsl:if test="count( child::* ) &gt; 0" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  >ERROR26</MSGCD>
         <MSGTXT >jsp:textタグの内部にタグを書くと、tomcat8以降でエラーとなります。jsp:textを削除するか、場合によってはCDATAを利用してください。</MSGTXT>
         <TEXT_DATA   ><xsl:copy-of select="." /></TEXT_DATA>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="tr" >
	 <xsl:if test="count(*[not(descendant-or-self::og:*) and not(descendant-or-self::td)]) &gt; count(*[not(descendant-or-self::og:*) and not(descendant-or-self::td)]/ancestor::td)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING32</MSGCD>
		 <MSGTXT >trタグ内にtdタグで囲んでいない要素があります</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

</xsl:stylesheet>
