<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC22"
	title	= "テーブルカラム抜き出し"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	minRowCount	= "1"
	command		= "{@command}"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<og:value command = "SETTBL" action = "APPEND" key = "TABLE_NAME" separator="','" />
<!-- まずGF79から該当テーブルのデータを削除する。 -->
<!-- ここではqueryタグを利用して一度のDBアクセスで一気に消去していますが、 -->
<!-- このようにvalueのSETTBLとqueryタグの組み合わせで削除を行うのは正攻法ではありません。 -->
<!-- 通常はtableUpdateタグを利用してチェックした行を順々に消していきます。 -->
<og:query command="NEW" quotCheck="false" >
		DELETE FROM GF79
		WHERE	SYSTEM_ID	= '{@MEM.SYSTEM_ID}'
		AND		TBLSYU		= '{@MEM.TBLSYU}'
		AND		ADDRESS		IN ('{@TABLE_NAME}' )
		AND		KBRSC		= '2'
</og:query>
<!-- dbMetaDataQueryのtableNameは複数のテーブルを指定できない(パターンは可能)
とりあえず少々迂遠な感でも、Cタグで回して順番に取っていく -->
<c:forTokens items = "${TABLE_NAME}" delims = "','" var = "NMTBL">
	<og:dbMetaDataQuery
		command		= "NEW"
		dbid		= "{@MEM.DBID}"
		action		= "COLUMNS"
		schema		= "{@MEM.schema}"
		tableName	= "{@NMTBL}"
	/>
	
	<!-- 追加する -->
	<og:tableUpdate
	 command		= "{@command}"
	 queryType		= "JDBCTableUpdate"
	 selectedAll	= "true">
			INSERT INTO GF79
				(SYSTEM_ID
				,TBLSYU
				,ADDRESS
				,KBRSC
				,NAME_JA
				,FGJ
				,DYSET
				,USRSET
				,PGUPD
				,FGOMIT)
			VALUES
				('{@MEM.SYSTEM_ID}'
				,'{@MEM.TBLSYU}'
				,'{@NMTBL}'
				,'2'
				,[COLUMN_NAME]
				,'1'
				,'{@USER.YMDH}'
				,'{@USER.ID}'
				,'{@GUI.KEY}'
				,'0')
	</og:tableUpdate>
</c:forTokens>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
