<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT10"
	title	= "オブジェクトマスタ登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select ID,IDTYPE,SEQ,FORM,NAME_JA,DEF1,DEF2,DEF3,DEF4,DEF5,DEF6,
				ROLES,DYKAN,URL,CDKATU,FGJ
		from GF60
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"     />
		<og:and value = "ID         like '{@ID}%'"      />
		<og:and value = "IDTYPE        =   '{@IDTYPE}'"     />
		<og:and value = "NAME_JA       like '{@NAME_JA}%'"    />
		<og:and value = "DEF1       like '{@DEF1}%'"    />
		<og:and value = "DEF2       like '{@DEF2}%'"    />
		<og:and value = "DEF3       like '{@DEF3}%'"    />
		<og:and value = "DEF4       like '{@DEF4}%'"    />
		<og:and value = "DEF5       like '{@DEF5}%'"    />
		<og:and value = "DEF6       like '{@DEF6}%'"    />
		<og:and value = "FORM       like '{@FORM}%'"    />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "IDTYPE,SEQ" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="COPY"   noWritable="null" />
	<og:submit  action="MODIFY" noWritable="ID,IDTYPE,SEQ" />
	<og:submit  action="DELETE" columnWritable="null" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}"  />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
