<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2082"
	title	= "シーケンス"
	date	= "2010/07/28"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,SEQNAME,TABLE_NAME,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.TBLSYU,A.SEQNAME,A.INCREBY,A.STARTVAL,A.MINVAL,A.MAXVAL,A.FGCYCLE
			,A.SUCACHE,A.LAST_NUMBER,A.TABLE_NAME,A.CLM,B.NAME_JA
			,A.FGJ,A.SYSTEM_ID,A.UNIQ
		from GF09 A
		left outer join GF05 B
		on		A.SYSTEM_ID    = B.SYSTEM_ID
		and		A.TBLSYU       = B.TBLSYU
		and		A.TABLE_NAME   = B.TABLE_NAME
		and		A.CLM          = B.CLM
		and		A.FGJ          = B.FGJ
	<og:where>
		<og:and value = "A.FGJ          in   ('0','1')"           />
		<og:and value = "A.SYSTEM_ID    =    '{@SYSTEM_ID}'"      />
		<og:and value = "A.TBLSYU       =    '{@TBLSYU}'"         />
		<og:and value = "A.SEQNAME      like '{@SEQNAME}%'"       />
		<og:and value = "A.TABLE_NAME   like '{@TABLE_NAME}%'"    />
		<og:and value = "A.CLM          like '{@CLM}%'"           />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.TBLSYU,A.SEQNAME" />
</og:query>

<og:columnEditor columns="TBLSYU,SEQNAME,INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SYSTEM_ID" must="true" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="NAME_JA" />
	<og:submit  action="MODIFY"  accesskey="M" noWritable="SYSTEM_ID,TBLSYU,SEQNAME,NAME_JA"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
	<og:fieldset lbl="INSERT_GF09">
		<og:column  name="DBID"			codeKeyVal="{@DBID_INFO}" td="no" />
		<og:column  name="SYSTEM_ID"	defaultVal="{@SYSTEM_ID}"   size="5" td="no" />
		<og:column  name="TBLSYU"		defaultVal="T" addNoValue="false" td="no" />
		<og:column  name="SEQNAME"		size="5" td="no" />
		<og:submit  value="directGF09" lbl="DIRECT" command="INSERT" />
	</og:fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
