<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
<!--
  <xsl:param name="DYSET"     select='java:org.opengion.fukurou.tools.util.DateSet.getDate( "yyyyMMddHHmmss" )' />
-->

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:link" />
    <xsl:apply-templates select="//og:sql | //og:update" />
<!--
    <xsl:apply-templates select="//og:upload" />
-->
    <xsl:apply-templates select="//og:option" />
    <xsl:apply-templates select="//og:query" />
    <xsl:apply-templates select="//og:userInfo" />
    <xsl:apply-templates select="//og:view" />
    <xsl:apply-templates select="//og:submit" />
    <xsl:apply-templates select="//og:userInfo" />
    <xsl:apply-templates select="//og:equals" />
    <xsl:apply-templates select="//og:entry" />
    <xsl:apply-templates select="//og:viewLink" />
    <xsl:apply-templates select="//og:viewMarker" />
    <xsl:apply-templates select="//og:writeCheck" />
    <xsl:apply-templates select="//*[starts-with( @onClick ,'window_open' )]" />
    <xsl:apply-templates select="//*[@tableId]" />
    <xsl:apply-templates select="//og:columnCheck" />
    <xsl:apply-templates select="//og:column | //og:input | //og:select | //og:hidden | og:submit | //input | //select | //hidden" />
    <xsl:apply-templates select="//form" />
    <xsl:apply-templates select="//frameset" />
    <xsl:apply-templates select="//*[@width] | //*[@height]" />
    <xsl:apply-templates select="//og:message" />
  </xsl:template>

  <xsl:template match="og:link">
     <xsl:if test="@value and not(preceding::og:link)">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:linkタグのvalue属性は廃止属性です。vals を使用してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
     <xsl:if test="not(@gamenId) and starts-with( @href ,'../' ) and not(@useGamenId='false')">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:linkタグで別画面へ飛ばす場合は、gamenId 属性の使用をご検討ください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:sql | og:update">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT><xsl:value-of select="name()" />タグは廃止クラスです。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
  </xsl:template>

<!--
  <xsl:template match="og:upload">
     <xsl:if test="@filename">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:uploadタグのfilename属性は廃止属性です。file名_ENW をリクエストしてください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>
-->

  <xsl:template match="og:option">
     <xsl:if test="@code">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:optionタグのcode属性は廃止属性です。カラムリソースで、コードカラム属性を定義して使用してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:query">
     <xsl:if test="string-length( . ) &gt; 1000">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:queryタグの設定文字数が多すぎます。QUERY文を見直してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:userInfo">
     <xsl:if test="@query | @nullSet">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT><xsl:value-of select="name()" />属性は廃止属性です。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:view">
     <xsl:if test="@changeLabelKeys | @changeLabelVals">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT><xsl:value-of select="name()" />属性は廃止属性です。columnEditor タグで、ラベルを入れ替える方法で代替してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
     <xsl:if test="descendant::og:message" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:message タグは、{@MSG.XXXX} に置き換え可能です。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:submit">
     <xsl:if test="not(//og:writeCheck)">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:submit は、og:writeCheck の子要素として使用してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:userInfo">
     <xsl:if test="last() &gt; 10 and position() = last()" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:userInfo を使いすぎです。ソースを見直してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:equals">
     <xsl:if test="last() &gt; 10 and position() = last()">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:equals を使いすぎです。ソースを見直してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:entry">
     <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:entry が複数存在しています。これはエラーの可能性があります。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewLink">
     <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:viewLink が複数存在しています。これはエラーの可能性があります。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewMarker">
     <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:viewMarker が複数存在しています。これはエラーの可能性があります。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:writeCheck">
     <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:writeCheck が複数存在しています。これはエラーの可能性があります。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="*[starts-with( @onClick ,'window_open' )]">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>window_open の代わりに、og:popup タグの使用を検討してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
  </xsl:template>

  <xsl:template match="og:columnCheck">
     <xsl:if test="preceding-sibling::og:entry" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>og:columnCheck でチェックする前に、og:entry があります。エラーの可能性があります。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="*[@tableId]" >
     <xsl:if test="last() &gt; 5 and position() = last()" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>tableId 属性を使いすぎです。ソースを見直してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:column | og:input | og:select | og:hidden | og:submit | input | select | hidden" >
     <xsl:if test="not(@writable='false') and not(ancestor::form) and (following::form | preceding::form)" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT><xsl:value-of select="name()" /> タグが、form の中にありません。これはエラーの可能性があります。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="form" >
     <xsl:if test="descendant::og:view and not(@method='POST')" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>テーブル登録時の form には、method="POST" を使用することを検討してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
     <xsl:if test="descendant::og:view and not(starts-with( @onSubmit ,'return oneClick' ) )" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>テーブル登録時の form には、２度押し防止JavaScript( return oneClick(); )の使用を検討してください。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="frameset" >
     <xsl:if test="not(@name='SUB_FRAME') and not(@name='TOP_FRAME')" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>フレーム分割(frameset)時の自動調整機能を有効にするには、name="SUB_FRAME" が必要です。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="*[@width] | *[@height]" >
     <xsl:if test="not(contains( @width | @height ,'pt')) and not(contains( @width | @height ,'px')) and not(contains( @width | @height ,'%'))" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  ></MSGCD>
         <MSGTXT>width や height を指定する場合は、単位(pt,px,%)が必要です。</MSGTXT>
         <TEXT   ><xsl:copy-of select="." /></TEXT>
       </ROW>
     </xsl:if>
  </xsl:template>


</xsl:stylesheet>
